/*
 * Decompiled with CFR 0.152.
 */
package railcraft.common.blocks.tracks;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import railcraft.common.api.carts.CartTools;
import railcraft.common.api.tracks.ITrackLockdown;
import railcraft.common.api.tracks.ITrackPowered;
import railcraft.common.blocks.tracks.EnumTrack;
import railcraft.common.blocks.tracks.TrackLockingBase;
import railcraft.common.util.misc.Game;

public class TrackHolding
extends TrackLockingBase
implements ITrackPowered,
ITrackLockdown {
    protected static float DIR_THRESHOLD = 0.01f;
    protected boolean launchForward = true;
    protected byte reset = 0;

    @Override
    public EnumTrack getTrackType() {
        return EnumTrack.HOLDING;
    }

    @Override
    public void updateEntity() {
        if (this.getCurrentCart() != null && this.getCurrentCart().L) {
            this.setCurrentCart(null);
        }
        if (Game.isHost(this.getWorld())) {
            if (this.isPowered()) {
                this.delay = this.getDelayTime();
            } else if (this.delay > 0) {
                this.delay = (byte)(this.delay - 1);
                if (this.delay == 0) {
                    this.setCurrentCart(null);
                }
            }
            if (this.reset > 0) {
                this.reset = (byte)(this.reset - 1);
            }
        }
        if (this.prevDelay == 0 ^ this.delay == 0) {
            this.sendUpdateToClient();
        }
        this.prevDelay = this.delay;
    }

    @Override
    protected void checkCart(py cart) {
        if (this.delay > 0 && (cart != this.getCurrentCart() || this.reset == 0)) {
            this.delay = 0;
            this.setCurrentCart(cart);
            this.setLaunchDirection(cart);
        }
        this.reset = (byte)10;
    }

    @Override
    public void onMinecartPass(py cart) {
        this.checkCart(cart);
        int meta = this.tileEntity.p();
        if (this.isPowered() || this.delay > 0) {
            this.releaseCart(cart);
            double speed = CartTools.getCartSpeedUncapped(cart);
            double boostX = START_BOOST;
            double boostZ = START_BOOST;
            if (speed > 0.005) {
                boostX = Math.abs(cart.w) / speed * BOOST_FACTOR;
                boostZ = Math.abs(cart.y) / speed * BOOST_FACTOR;
            }
            if (meta == 0 || meta == 4 || meta == 5) {
                cart.y = this.launchForward ? (cart.y += boostZ) : (cart.y -= boostZ);
            } else if (meta == 1 || meta == 2 || meta == 3) {
                cart.w = this.launchForward ? (cart.w += boostX) : (cart.w -= boostX);
            }
        } else {
            if (this.getCurrentCart() == null) {
                this.setCurrentCart(cart);
                this.setLaunchDirection(cart);
            }
            if (this.getCurrentCart() == cart) {
                this.lockCart(cart);
                cart.w = 0.0;
                cart.y = 0.0;
                if (meta == 0 || meta == 4 || meta == 5) {
                    cart.b(cart.t, cart.u, (double)this.tileEntity.n + 0.5);
                } else {
                    cart.b((double)this.tileEntity.l + 0.5, cart.u, cart.v);
                }
            }
        }
    }

    protected void setLaunchDirection(py cart) {
        int meta = this.tileEntity.p();
        double speed = CartTools.getCartSpeedUncapped(cart);
        if (speed > (double)DIR_THRESHOLD) {
            boolean launch = this.launchForward;
            if (meta == 0 || meta == 4 || meta == 5) {
                launch = cart.y > 0.0;
            } else if (meta == 1 || meta == 2 || meta == 3) {
                boolean bl = launch = cart.w > 0.0;
            }
            if (this.launchForward != launch) {
                this.launchForward = launch;
                this.sendUpdateToClient();
            }
        }
    }

    @Override
    public void writeToNBT(bq data) {
        super.writeToNBT(data);
        data.a("launchForward", this.launchForward);
    }

    @Override
    public void readFromNBT(bq data) {
        super.readFromNBT(data);
        this.launchForward = data.n("launchForward");
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        data.writeBoolean(this.launchForward);
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        this.launchForward = data.readBoolean();
        this.markBlockNeedsUpdate();
    }
}

