/*
 * Decompiled with CFR 0.152.
 */
package railcraft.common.blocks.tracks;

import net.minecraftforge.common.ForgeDirection;
import railcraft.common.api.tracks.ITrackCustomPlaced;
import railcraft.common.blocks.RailcraftBlocks;
import railcraft.common.blocks.tracks.BlockTrack;
import railcraft.common.blocks.tracks.EnumTrack;
import railcraft.common.blocks.tracks.EnumTrackMeta;
import railcraft.common.blocks.tracks.TrackBaseRailcraft;
import railcraft.common.util.misc.Game;

public class TrackSuspended
extends TrackBaseRailcraft
implements ITrackCustomPlaced {
    @Override
    public EnumTrack getTrackType() {
        return EnumTrack.SUSPENDED;
    }

    @Override
    public int getTextureIndex() {
        return this.getTrackSpec().getTextureIndex();
    }

    @Override
    public boolean canMakeSlopes() {
        return false;
    }

    @Override
    public void onBlockPlaced() {
        super.onBlockPlaced();
        if (!this.isSupported()) {
            this.breakRail();
        }
    }

    @Override
    public void onNeighborBlockChange(int id) {
        yc world = this.getWorld();
        int i = this.tileEntity.l;
        int j = this.tileEntity.m;
        int k = this.tileEntity.n;
        if (this.isSupported()) {
            int myId = RailcraftBlocks.getBlockTrack().cm;
            if (id != myId) {
                world.h(i + 1, j, k, myId);
                world.h(i - 1, j, k, myId);
                world.h(i, j, k + 1, myId);
                world.h(i, j, k - 1, myId);
            }
        } else {
            this.breakRail();
        }
    }

    public void breakRail() {
        if (Game.isHost(this.getWorld())) {
            BlockTrack block = (BlockTrack)RailcraftBlocks.getBlockTrack();
            block.c(this.getWorld(), this.tileEntity.l, this.tileEntity.m, this.tileEntity.n, 0, 0);
            this.getWorld().e(this.tileEntity.l, this.tileEntity.m, this.tileEntity.n, 0);
        }
    }

    public boolean isSupportedRail(yc world, int i, int j, int k, int meta) {
        if (!alr.e_((yc)world, (int)i, (int)j, (int)k)) {
            return false;
        }
        if (this.isSupportedBelow(world, i, j, k)) {
            return true;
        }
        if (meta == EnumTrackMeta.NORTH_SOUTH.ordinal()) {
            if (this.isSupportedBelow(world, i, j, k + 1)) {
                return true;
            }
            return this.isSupportedBelow(world, i, j, k - 1);
        }
        if (meta == EnumTrackMeta.EAST_WEST.ordinal()) {
            if (this.isSupportedBelow(world, i + 1, j, k)) {
                return true;
            }
            return this.isSupportedBelow(world, i - 1, j, k);
        }
        return false;
    }

    public boolean isSupportedBelow(yc world, int i, int j, int k) {
        if (!world.f(i, j, k)) {
            return true;
        }
        if (alr.e_((yc)world, (int)i, (int)j, (int)k)) {
            return world.isBlockSolidOnSide(i, j - 1, k, ForgeDirection.UP);
        }
        return false;
    }

    public boolean isSupported() {
        int meta = this.tileEntity.p();
        return this.isSupported(this.getWorld(), this.tileEntity.l, this.tileEntity.m, this.tileEntity.n, meta);
    }

    public boolean isSupported(yc world, int i, int j, int k, int meta) {
        if (this.isSupportedRail(world, i, j, k, meta)) {
            return true;
        }
        if (meta == EnumTrackMeta.NORTH_SOUTH.ordinal()) {
            return this.isSupportedRail(world, i, j, k + 1, meta) || this.isSupportedRail(world, i, j, k - 1, meta);
        }
        if (meta == EnumTrackMeta.EAST_WEST.ordinal()) {
            return this.isSupportedRail(world, i + 1, j, k, meta) || this.isSupportedRail(world, i - 1, j, k, meta);
        }
        return false;
    }

    @Override
    public boolean canPlaceRailAt(yc world, int i, int j, int k) {
        if (this.isSupported(world, i, j, k, 0) || this.isSupported(world, i, j, k, 1)) {
            return true;
        }
        return world.isBlockSolidOnSide(i, j - 1, k, ForgeDirection.UP);
    }
}

