/*
 * Decompiled with CFR 0.152.
 */
package railcraft.common.blocks.tracks;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import railcraft.common.api.tracks.ITrackSwitch;
import railcraft.common.blocks.tracks.EnumTrackMeta;
import railcraft.common.blocks.tracks.TrackBaseRailcraft;
import railcraft.common.util.misc.Game;

public abstract class TrackSwitchBase
extends TrackBaseRailcraft
implements ITrackSwitch {
    private static final int SPRING_DURATION = 20;
    protected boolean mirrored;
    protected boolean switched;
    private byte sprung;
    private byte locked;

    @Override
    public boolean canMakeSlopes() {
        return false;
    }

    @Override
    public boolean canUpdate() {
        return true;
    }

    @Override
    public boolean isFlexibleRail() {
        return false;
    }

    @Override
    public boolean isMirrored() {
        return this.mirrored;
    }

    @Override
    public boolean isSwitched() {
        return !this.isLocked() && (this.switched || this.isSprung());
    }

    public boolean isLocked() {
        return this.locked > 0;
    }

    @Override
    public void onBlockPlaced() {
        this.determineTrackMeta();
        this.determineMirror();
    }

    protected void determineTrackMeta() {
        int i = this.tileEntity.l;
        int j = this.tileEntity.m;
        int k = this.tileEntity.n;
        int meta = this.tileEntity.p();
        if (meta == EnumTrackMeta.NORTH_SOUTH.ordinal()) {
            if (alr.e_((yc)this.getWorld(), (int)(i + 1), (int)j, (int)k) && alr.e_((yc)this.getWorld(), (int)(i - 1), (int)j, (int)k)) {
                this.getWorld().d(i, j, k, 1);
            }
        } else if (meta == EnumTrackMeta.EAST_WEST.ordinal() && alr.e_((yc)this.getWorld(), (int)i, (int)j, (int)(k + 1)) && alr.e_((yc)this.getWorld(), (int)i, (int)j, (int)(k - 1))) {
            this.getWorld().d(i, j, k, 0);
        }
    }

    protected void determineMirror() {
        int x = this.tileEntity.l;
        int y = this.tileEntity.m;
        int z = this.tileEntity.n;
        int meta = this.tileEntity.p();
        boolean prevValue = this.isMirrored();
        if (meta == EnumTrackMeta.NORTH_SOUTH.ordinal()) {
            int otherMeta;
            int ii = x;
            if (alr.e_((yc)this.getWorld(), (int)(x - 1), (int)y, (int)z)) {
                --ii;
                this.mirrored = true;
            } else {
                ++ii;
                this.mirrored = false;
            }
            if (alr.e_((yc)this.getWorld(), (int)ii, (int)y, (int)z) && (otherMeta = this.getWorld().h(ii, y, z)) == EnumTrackMeta.NORTH_SOUTH.ordinal()) {
                this.getWorld().d(ii, y, z, EnumTrackMeta.EAST_WEST.ordinal());
            }
        } else if (meta == EnumTrackMeta.EAST_WEST.ordinal()) {
            this.mirrored = alr.e_((yc)this.getWorld(), (int)x, (int)y, (int)(z - 1));
        }
        if (prevValue != this.isMirrored()) {
            this.sendUpdateToClient();
        }
    }

    @Override
    public void onNeighborBlockChange(int id) {
        if (alr.e((int)id) && Game.isHost(this.getWorld())) {
            this.determineTrackMeta();
            this.determineMirror();
        }
        super.onNeighborBlockChange(id);
    }

    @Override
    public void writeToNBT(bq nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.a("Direction", this.mirrored);
        nbttagcompound.a("Switched", this.switched);
    }

    @Override
    public void readFromNBT(bq nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.mirrored = nbttagcompound.n("Direction");
        this.switched = nbttagcompound.n("Switched");
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        data.writeBoolean(this.mirrored);
        data.writeBoolean(this.switched);
        data.writeByte(this.locked);
        data.writeByte(this.sprung);
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        this.mirrored = data.readBoolean();
        this.switched = data.readBoolean();
        this.locked = data.readByte();
        this.sprung = data.readByte();
        this.markBlockNeedsUpdate();
    }

    @Override
    public void setSwitched(boolean switched) {
        if (this.switched != switched) {
            this.switched = switched;
            this.sendUpdateToClient();
        }
    }

    public boolean isSprung() {
        return this.sprung > 0;
    }

    @Override
    public void updateEntity() {
        boolean springState;
        boolean wasLocked;
        if (Game.isNotHost(this.getWorld())) {
            return;
        }
        boolean bl = wasLocked = this.locked == 0;
        if (this.locked > 0) {
            this.locked = (byte)(this.locked - 1);
        }
        if (this.shouldLockSwitch()) {
            this.locked = (byte)20;
        }
        boolean bl2 = springState = this.sprung == 0;
        if (this.sprung > 0) {
            this.sprung = (byte)(this.sprung - 1);
        }
        if (!this.isLocked() && this.shouldSpringSwitch()) {
            this.sprung = (byte)20;
        }
        if (springState != (this.sprung == 0) || wasLocked != (this.locked == 0)) {
            this.sendUpdateToClient();
        }
    }

    protected abstract boolean shouldLockSwitch();

    protected abstract boolean shouldSpringSwitch();
}

