/*
 * Decompiled with CFR 0.152.
 */
package railcraft.common.gui.containers;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import railcraft.common.blocks.machine.beta.TileEngineSteamHobby;
import railcraft.common.gui.containers.RailcraftContainer;
import railcraft.common.gui.indicator.Indicator;
import railcraft.common.gui.slots.SlotFuel;
import railcraft.common.gui.slots.SlotOutput;
import railcraft.common.gui.slots.SlotWater;
import railcraft.common.liquids.LiquidGauge;

public class ContainerEngineSteamHobby
extends RailcraftContainer {
    private TileEngineSteamHobby tile;
    private sr fuel;
    private sr input;
    private sr output;
    private float lastBurnTime;
    private float lastItemBurnTime;
    private float lastEnergy;
    private float lastOutput;
    private float lastHeat;

    public ContainerEngineSteamHobby(qw inventoryplayer, TileEngineSteamHobby tile) {
        super(tile);
        this.tile = tile;
        this.addGauge(new LiquidGauge(tile.getTanks(null)[0], 17, 23, 16, 47));
        this.addGauge(new LiquidGauge(tile.getTanks(null)[1], 107, 23, 16, 47));
        this.addIndicator(new Indicator(tile.getHeatIndicator(), 40, 25, 6, 43, 176, 61));
        this.addIndicator(new Indicator(tile.getEnergyIndicator(), 94, 25, 6, 43, 182, 61));
        this.fuel = new SlotFuel(tile, 0, 62, 39);
        this.addSlot(this.fuel);
        this.input = new SlotWater(tile, 1, 143, 21);
        this.addSlot(this.input);
        this.output = new SlotOutput(tile, 2, 143, 56);
        this.addSlot(this.output);
        for (int i = 0; i < 3; ++i) {
            for (int k = 0; k < 9; ++k) {
                this.addSlot(new sr((la)inventoryplayer, k + i * 9 + 9, 8 + k * 18, 84 + i * 18));
            }
        }
        for (int j = 0; j < 9; ++j) {
            this.addSlot(new sr((la)inventoryplayer, j, 8 + j * 18, 142));
        }
    }

    public void a(rw icrafting) {
        super.a(icrafting);
        this.tile.getTankManager().initGuiData(this, icrafting, 0);
        this.tile.getTankManager().initGuiData(this, icrafting, 1);
        icrafting.a((rq)this, 10, Math.round(this.tile.burnTime));
        icrafting.a((rq)this, 11, Math.round(this.tile.currentItemBurnTime));
        icrafting.a((rq)this, 12, Math.round(this.tile.energy));
        icrafting.a((rq)this, 13, Math.round(this.tile.currentOutput * 100.0f));
        icrafting.a((rq)this, 14, Math.round(this.tile.heat));
    }

    public void b() {
        super.b();
        this.tile.getTankManager().updateGuiData(this, this.e, 0);
        this.tile.getTankManager().updateGuiData(this, this.e, 1);
        for (int var1 = 0; var1 < this.e.size(); ++var1) {
            rw var2 = (rw)this.e.get(var1);
            if (this.lastBurnTime != this.tile.burnTime) {
                var2.a((rq)this, 10, Math.round(this.tile.burnTime));
            }
            if (this.lastItemBurnTime != this.tile.currentItemBurnTime) {
                var2.a((rq)this, 11, Math.round(this.tile.currentItemBurnTime));
            }
            if (this.lastEnergy != this.tile.energy) {
                var2.a((rq)this, 12, Math.round(this.tile.energy));
            }
            if (this.lastOutput != this.tile.currentOutput) {
                var2.a((rq)this, 13, Math.round(this.tile.currentOutput * 100.0f));
            }
            if (this.lastHeat == this.tile.heat) continue;
            var2.a((rq)this, 14, Math.round(this.tile.heat));
        }
        this.lastBurnTime = this.tile.burnTime;
        this.lastItemBurnTime = this.tile.currentItemBurnTime;
        this.lastEnergy = this.tile.energy;
        this.lastOutput = this.tile.currentOutput;
        this.lastHeat = this.tile.heat;
    }

    @SideOnly(value=Side.CLIENT)
    public void b(int id, int value) {
        this.tile.getTankManager().processGuiUpdate(id, value);
        switch (id) {
            case 10: {
                this.tile.burnTime = value;
                break;
            }
            case 11: {
                this.tile.currentItemBurnTime = value;
                break;
            }
            case 12: {
                this.tile.energy = value;
                break;
            }
            case 13: {
                this.tile.currentOutput = (float)value / 100.0f;
                break;
            }
            case 14: {
                this.tile.heat = value;
            }
        }
    }
}

