/*
 * Decompiled with CFR 0.152.
 */
package railcraft.common.plugins.forestry;

import railcraft.common.blocks.aesthetics.wall.EnumWall;
import railcraft.common.lang.RailcraftLanguage;
import railcraft.common.plugins.forestry.BaseBackpack;
import railcraft.common.util.inventory.InvTools;
import railcraft.common.util.inventory.StandaloneInventory;

public class IcemanBackpack
extends BaseBackpack {
    private static IcemanBackpack instance;
    private static final ur SNOWBALL;
    private static final ur SNOWBLOCK;
    private static final String INV_TAG = "Items";

    public static IcemanBackpack getInstance() {
        if (instance == null) {
            instance = new IcemanBackpack();
        }
        return instance;
    }

    protected IcemanBackpack() {
    }

    public void setup() {
        this.addValidItem(amq.aV);
        this.addValidItem(amq.aX);
        this.addValidItem(amq.aW);
        this.addValidItem(EnumWall.SNOW.getItem());
        this.addValidItem(EnumWall.ICE.getItem());
        this.addValidItem(up.aD);
    }

    public void compactInventory(ur backpack) {
        StandaloneInventory inv = new StandaloneInventory(45);
        bq data = backpack.p();
        if (data == null) {
            return;
        }
        InvTools.readInvFromNBT(inv, INV_TAG, data);
        int numSnowballs = InvTools.countItems((la)inv, SNOWBALL);
        if (numSnowballs >= 16) {
            for (int i = 0; i < 4; ++i) {
                InvTools.removeOneItem((la)inv, SNOWBALL);
            }
            if (InvTools.moveItemStack(new ur(amq.aX), inv) == null) {
                InvTools.writeInvToNBT(inv, INV_TAG, data);
            }
        } else if (numSnowballs < 8 && InvTools.removeOneItem((la)inv, SNOWBLOCK) != null && InvTools.moveItemStack(new ur(up.aD, 4), inv) == null) {
            InvTools.writeInvToNBT(inv, INV_TAG, data);
        }
    }

    @Override
    public String getKey() {
        return "ICEMAN";
    }

    @Override
    public String getName() {
        return RailcraftLanguage.translate("backpack.iceman.t1");
    }

    @Override
    public int getPrimaryColour() {
        return 0xFFFFFF;
    }

    @Override
    public int getSecondaryColour() {
        return 0xFFFFFF;
    }

    static {
        SNOWBALL = new ur(up.aD);
        SNOWBLOCK = new ur(amq.aX);
    }
}

