/*
 * Decompiled with CFR 0.152.
 */
package railcraft.common.util.crafting;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import railcraft.common.api.crafting.IRockCrusherCraftingManager;
import railcraft.common.api.crafting.IRockCrusherRecipe;
import railcraft.common.api.crafting.RailcraftCraftingManager;
import railcraft.common.util.inventory.InvTools;
import railcraft.common.util.misc.MiscTools;

public class RockCrusherCraftingManager
implements IRockCrusherCraftingManager {
    private final List recipes = new ArrayList();

    public static IRockCrusherCraftingManager getInstance() {
        return RailcraftCraftingManager.rockCrusher;
    }

    @Override
    public List getRecipes() {
        ArrayList list = new ArrayList(this.recipes);
        return list;
    }

    @Override
    public void addRecipe(int inputId, int inputDamage, HashMap output) {
        this.recipes.add(new CrusherRecipe(inputId, inputDamage, output));
    }

    @Override
    public void addRecipe(ur input, HashMap output) {
        this.addRecipe(input.c, input.j(), output);
    }

    @Override
    public CrusherRecipe getRecipe(ur input) {
        return this.getRecipe(input.c, input.j());
    }

    @Override
    public CrusherRecipe getRecipe(int inputId, int inputDamage) {
        for (CrusherRecipe r : this.recipes) {
            if (r.inputId != inputId || r.inputDamage != inputDamage) continue;
            return r;
        }
        for (CrusherRecipe r : this.recipes) {
            if (r.inputId != inputId || r.inputDamage != -1) continue;
            return r;
        }
        return null;
    }

    public static class CrusherRecipe
    implements IRockCrusherRecipe {
        private final int inputId;
        private final int inputDamage;
        private final Map output;

        public CrusherRecipe(int inputId, int inputDamage, HashMap output) {
            this.inputId = inputId;
            this.inputDamage = inputDamage;
            this.output = output;
        }

        @Override
        public ur getInput() {
            return new ur(this.inputId, 1, this.inputDamage);
        }

        @Override
        public Map getOutputs() {
            return this.output;
        }

        @Override
        public List getPossibleOuput() {
            ArrayList<ur> list = new ArrayList<ur>();
            for (ur item : this.output.keySet()) {
                for (ur saved : list) {
                    if (!InvTools.isItemEqual(saved, item)) continue;
                    if (saved.a + item.a <= saved.d()) {
                        saved.a += item.a;
                        item = null;
                        break;
                    }
                    int diff = saved.d() - saved.a;
                    saved.a = saved.d();
                    item.a -= diff;
                    break;
                }
                if (item == null) continue;
                list.add(item.l());
            }
            return list;
        }

        @Override
        public List getRandomizedOuput() {
            ArrayList<ur> list = new ArrayList<ur>();
            for (Map.Entry entry : this.output.entrySet()) {
                if (!(MiscTools.getRand().nextFloat() <= ((Float)entry.getValue()).floatValue())) continue;
                list.add(((ur)entry.getKey()).l());
            }
            return list;
        }

        public int getNumberOfOutputs() {
            return this.output.size();
        }
    }
}

