/*
 * Decompiled with CFR 0.152.
 */
package codechicken.core.asm;

import codechicken.core.asm.InsnListPrinter;
import codechicken.core.asm.InstructionComparator;
import codechicken.core.asm.ObfuscationMappings;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.HashMap;
import java.util.List;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodNode;

public class ASMHelper {
    public static MethodNode findMethod(ObfuscationMappings.DescriptorMapping methodmap, ClassNode cnode) {
        for (MethodNode mnode : cnode.methods) {
            if (!methodmap.matches(mnode)) continue;
            return mnode;
        }
        return null;
    }

    public static FieldNode findField(ObfuscationMappings.DescriptorMapping fieldmap, ClassNode cnode) {
        for (FieldNode fnode : cnode.fields) {
            if (!fieldmap.matches(fnode)) continue;
            return fnode;
        }
        return null;
    }

    public static ClassNode createClassNode(byte[] bytes) {
        ClassNode cnode = new ClassNode();
        ClassReader reader = new ClassReader(bytes);
        reader.accept((ClassVisitor)cnode, 0);
        return cnode;
    }

    public static byte[] createBytes(ClassNode cnode, int i) {
        ClassWriter cw = new ClassWriter(i);
        cnode.accept((ClassVisitor)cw);
        return cw.toByteArray();
    }

    public static byte[] writeMethods(String name, byte[] bytes, Multimap writers) {
        if (writers.containsKey((Object)name)) {
            ClassNode cnode = ASMHelper.createClassNode(bytes);
            for (MethodWriter mw : writers.get((Object)name)) {
                MethodNode mv = ASMHelper.findMethod(mw.method, cnode);
                if (mv == null) {
                    mv = (MethodNode)cnode.visitMethod(mw.access, mw.method.s_name, mw.method.s_desc, null, mw.exceptions);
                }
                mv.access = mw.access;
                mv.instructions.clear();
                mw.write(mv);
            }
            bytes = ASMHelper.createBytes(cnode, 3);
        }
        return bytes;
    }

    public static byte[] injectMethods(String name, byte[] bytes, Multimap injectors) {
        if (injectors.containsKey((Object)name)) {
            ClassNode cnode = ASMHelper.createClassNode(bytes);
            for (MethodInjector injector : injectors.get((Object)name)) {
                MethodNode method = ASMHelper.findMethod(injector.method, cnode);
                if (method == null) {
                    throw new RuntimeException("Method not found: " + injector.method);
                }
                System.out.println("Injecting into " + injector.method + "\n" + ASMHelper.printInsnList(injector.injection));
                List callNodes = injector.before ? InstructionComparator.insnListFindStart(method.instructions, injector.needle) : InstructionComparator.insnListFindEnd(method.instructions, injector.needle);
                if (callNodes.size() == 0) {
                    throw new RuntimeException("Needle not found in Haystack: " + injector.method + "\n" + ASMHelper.printInsnList(injector.needle));
                }
                for (AbstractInsnNode node : callNodes) {
                    if (injector.before) {
                        System.out.println("Injected before: " + ASMHelper.printInsn(node));
                        method.instructions.insertBefore(node, ASMHelper.clone(injector.injection));
                        continue;
                    }
                    System.out.println("Injected after: " + ASMHelper.printInsn(node));
                    method.instructions.insert(node, ASMHelper.clone(injector.injection));
                }
            }
            bytes = ASMHelper.createBytes(cnode, 3);
        }
        return bytes;
    }

    public static String printInsnList(InsnList list) {
        InsnListPrinter p = new InsnListPrinter();
        p.visitInsnList(list);
        return p.textString();
    }

    public static String printInsn(AbstractInsnNode insn) {
        InsnListPrinter p = new InsnListPrinter();
        p.visitInsn(insn);
        return p.textString();
    }

    public static InsnList clone(InsnList list) {
        HashMap<LabelNode, LabelNode> labels = new HashMap<LabelNode, LabelNode>();
        AbstractInsnNode insn = list.getFirst();
        while (insn != null) {
            if (insn.getType() == 8) {
                labels.put((LabelNode)insn, new LabelNode());
            }
            insn = insn.getNext();
        }
        InsnList clone = new InsnList();
        AbstractInsnNode insn2 = list.getFirst();
        while (insn2 != null) {
            clone.add(insn2.clone(labels));
            insn2 = insn2.getNext();
        }
        return clone;
    }

    public static byte[] alterMethods(String name, byte[] bytes, HashMultimap altercators) {
        if (altercators.containsKey((Object)name)) {
            ClassNode cnode = ASMHelper.createClassNode(bytes);
            for (MethodAltercator injector : altercators.get((Object)name)) {
                MethodNode method = ASMHelper.findMethod(injector.method, cnode);
                if (method == null) {
                    throw new RuntimeException("Method not found: " + injector.method);
                }
                injector.alter(method);
            }
            bytes = ASMHelper.createBytes(cnode, 3);
        }
        return bytes;
    }

    public static String printInsnList(InstructionComparator.InsnListSection subsection) {
        InsnListPrinter p = new InsnListPrinter();
        p.visitInsnList(subsection);
        return p.textString();
    }

    public static int getLocal(List list, String name) {
        int found = -1;
        for (LocalVariableNode node : list) {
            if (!node.name.equals(name)) continue;
            if (found >= 0) {
                throw new RuntimeException("Duplicate local variable: " + name + " not coded to handle this scenario.");
            }
            found = node.index;
        }
        return found;
    }

    public static void replaceMethodCode(MethodNode original, MethodNode replacement) {
        original.instructions.clear();
        if (original.localVariables != null) {
            original.localVariables.clear();
        }
        if (original.tryCatchBlocks != null) {
            original.tryCatchBlocks.clear();
        }
        replacement.accept((MethodVisitor)original);
    }

    public static void removeSection(InsnList instructions, AbstractInsnNode first, AbstractInsnNode last) {
        AbstractInsnNode insn = first;
        while (true) {
            AbstractInsnNode next = insn.getNext();
            instructions.remove(insn);
            if (insn == last) break;
            insn = next;
        }
    }

    public static class CodeBlock {
        public Label start = new Label();
        public Label end = new Label();
    }

    public static class ForBlock
    extends CodeBlock {
        public Label cmp = new Label();
        public Label inc = new Label();
        public Label body = new Label();
    }

    public static abstract class MethodAltercator {
        public final ObfuscationMappings.DescriptorMapping method;

        public MethodAltercator(ObfuscationMappings.DescriptorMapping method) {
            this.method = method;
        }

        public abstract void alter(MethodNode var1);
    }

    public static class MethodInjector {
        public final ObfuscationMappings.DescriptorMapping method;
        public final InsnList needle;
        public final InsnList injection;
        public final boolean before;

        public MethodInjector(ObfuscationMappings.DescriptorMapping method, InsnList needle, InsnList injection, boolean before) {
            this.method = method;
            this.needle = needle;
            this.injection = injection;
            this.before = before;
        }
    }

    public static abstract class MethodWriter {
        public final int access;
        public final ObfuscationMappings.DescriptorMapping method;
        public final String[] exceptions;

        public MethodWriter(int access, ObfuscationMappings.DescriptorMapping method) {
            this(access, method, null);
        }

        public MethodWriter(int access, ObfuscationMappings.DescriptorMapping method, String[] exceptions) {
            this.access = access;
            this.method = method;
            this.exceptions = exceptions;
        }

        public abstract void write(MethodNode var1);
    }
}

