/*
 * Decompiled with CFR 0.152.
 */
package codechicken.core.colour;

import codechicken.core.colour.ColourRGBA;
import cpw.mods.fml.common.FMLCommonHandler;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;

public class CustomGradient {
    private int[] gradient;

    public CustomGradient(String textureFile) {
        try {
            BufferedImage img = ImageIO.read(Minecraft.x().C.e().a(textureFile));
            int[] data = new int[img.getWidth()];
            img.getRGB(0, 0, img.getWidth(), 1, data, 0, img.getWidth());
            this.gradient = new int[img.getWidth()];
            int i = 0;
            while (i < data.length) {
                this.gradient[i] = data[i] << 8 | data[i] >> 24 & 0xFF;
                ++i;
            }
        }
        catch (IOException var5) {
            FMLCommonHandler.instance().raiseException((Throwable)var5, "Error while reading gradient: " + textureFile, true);
        }
    }

    public ColourRGBA getColour(double position) {
        int off = (int)((double)this.gradient.length * position);
        if (off >= this.gradient.length) {
            off = this.gradient.length - 1;
        } else if (off < 0) {
            off = 0;
        }
        return new ColourRGBA(this.gradient[off]);
    }
}

