/*
 * Decompiled with CFR 0.152.
 */
package mistaqur.nei;

import codechicken.nei.NEIClientConfig;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.versioning.ArtifactVersion;
import cpw.mods.fml.common.versioning.VersionParser;
import java.io.File;
import java.io.FileInputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import mistaqur.nei.common.GuiNEIPlugins;
import mistaqur.nei.common.IPlugin;
import mistaqur.nei.common.VersionCheck;
import org.modstats.ModstatInfo;
import org.modstats.Modstats;

@ModstatInfo(prefix="neiplugin")
@Mod(modid="NEIPlugins", name="NEI Plugins", version="1.0.4.7", dependencies="required-after:NotEnoughItems")
public class NEIPlugins {
    public static final String VERSION = "1.0.4.7";
    public static Logger logger = Logger.getLogger("NEIPlugins");
    @Mod.Instance(value="NEIPlugins")
    public static NEIPlugins instance;
    public File modLocation;
    public Map plugins;
    public Map modVersions;

    public static NEIPlugins getMod() {
        return instance;
    }

    @Mod.PreInit
    public void preLoad(FMLPreInitializationEvent evt) {
        this.modLocation = evt.getSourceFile();
        this.plugins = new HashMap();
        this.modVersions = new HashMap();
    }

    @Mod.PostInit
    public void postLoad(FMLPostInitializationEvent evt) {
        if (FMLCommonHandler.instance().getSide().isClient()) {
            for (ModContainer mod : Loader.instance().getActiveModList()) {
                this.modVersions.put(mod.getModId(), mod.getProcessedVersion());
            }
            NEIClientConfig.globalConfig.getTag("mistaqur.checkUpdate").setDefaultValue("true");
            NEIClientConfig.globalConfig.getTag("mistaqur.checkAllUpdates").setDefaultValue("false");
            NEIClientConfig.globalConfig.getTag("mistaqur.enableDebug").setDefaultValue("false");
            this.loadPlugins();
            VersionCheck.checkForNewVersion();
            Modstats.instance().getReporter().registerMod(this);
        } else {
            logger.log(Level.WARNING, "NEIPlugins is client-side only mod ");
        }
    }

    public boolean hasMod(ArtifactVersion modVersion) {
        return this.modVersions.containsKey(modVersion.getLabel()) && modVersion.containsVersion((ArtifactVersion)this.modVersions.get(modVersion.getLabel()));
    }

    public boolean hasMod(String modVersion) {
        return this.hasMod(VersionParser.parseVersionReference((String)modVersion));
    }

    public void loadPlugins() {
        block8: {
            ClassLoader classLoader = NEIPlugins.class.getClassLoader();
            if (this.modLocation.isFile() && (this.modLocation.getName().endsWith(".jar") || this.modLocation.getName().endsWith(".zip"))) {
                try {
                    ZipEntry entry = null;
                    FileInputStream fileIO = new FileInputStream(this.modLocation);
                    ZipInputStream zipIO = new ZipInputStream(fileIO);
                    while (true) {
                        if ((entry = zipIO.getNextEntry()) == null) {
                            fileIO.close();
                            break block8;
                        }
                        String entryName = entry.getName();
                        File entryFile = new File(entryName);
                        String pluginName = entryFile.getName();
                        if (entry.isDirectory() || !pluginName.startsWith("NEIPlugins_") || !pluginName.endsWith(".class") || pluginName.indexOf(36) != -1) continue;
                        this.addPlugin(classLoader, pluginName, entryFile.getParent());
                    }
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            }
            if (this.modLocation.isDirectory()) {
                this.modLocation = new File(this.modLocation, "mistaqur" + File.separatorChar + "nei");
                File[] fileList = this.modLocation.listFiles();
                if (fileList != null) {
                    for (int i = 0; i < fileList.length; ++i) {
                        String pluginName = fileList[i].getName();
                        if (!fileList[i].isFile() || !pluginName.startsWith("NEIPlugins_") || !pluginName.endsWith(".class") || pluginName.indexOf(36) != -1) continue;
                        this.addPlugin(classLoader, pluginName, "mistaqur.nei");
                    }
                }
            }
        }
    }

    public void addPlugin(ClassLoader classLoader, String pluginName, String dirPath) {
        if (dirPath == null) {
            NEIPlugins.log(Level.WARNING, "Invalid addPlugin call for plugin \"{0}\"", new Object[]{pluginName});
            return;
        }
        String pluginClassName = dirPath.replace(File.separatorChar, '.') + '.' + pluginName.split("\\.")[0];
        try {
            Class<?> pluginClass = classLoader.loadClass(pluginClassName);
            if (pluginClass != null) {
                Object obj = pluginClass.newInstance();
                if (!(obj instanceof IPlugin)) {
                    return;
                }
                IPlugin plugin = (IPlugin)obj;
                NEIPlugins.log(Level.FINE, "Found NEIPlugins plugin {0} ({1})", new Object[]{plugin.getPluginName(), plugin.getPluginVersion()});
                this.plugins.put(plugin.getPluginName(), plugin);
            }
        }
        catch (NoClassDefFoundError ex) {
            logger.log(Level.WARNING, "Error while detecting plugin " + pluginName, ex);
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, "Error while detecting plugin " + pluginName, ex);
        }
    }

    public void loadConfig() {
        GuiNEIPlugins.addOptions();
        this.initPlugins();
    }

    public void initPlugins() {
        for (IPlugin plugin : this.plugins.values()) {
            try {
                if (!plugin.isValid()) {
                    NEIPlugins.log(Level.FINE, "Plugin {0} ({1}) not active", new Object[]{plugin.getPluginName(), plugin.getPluginVersion()});
                    continue;
                }
                plugin.init();
            }
            catch (Exception ex) {
                logger.log(Level.WARNING, "Error while initializing plugin " + plugin.getPluginName() + " (" + plugin.getPluginVersion() + ")", ex);
            }
        }
    }

    public static void log(Level level, String msg, Object[] params) {
        String m = msg;
        for (int i = 0; i < params.length; ++i) {
            m = m.replace("{" + i + "}", params[i].toString());
        }
        logger.log(level, m);
    }

    static {
        logger.setParent(FMLCommonHandler.instance().getFMLLogger());
    }
}

