/*
 * Decompiled with CFR 0.152.
 */
package org.modstats.reporter.v1;

import argo.jdom.JdomParser;
import argo.jdom.JsonNode;
import argo.jdom.JsonRootNode;
import argo.jdom.JsonStringNode;
import argo.saj.InvalidSyntaxException;
import com.google.common.base.Charsets;
import com.google.common.hash.Hashing;
import com.google.common.io.Files;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.versioning.ComparableVersion;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.NetworkInterface;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;
import org.modstats.ModVersionData;
import org.modstats.ModsUpdateEvent;
import org.modstats.reporter.v1.Reporter;

class DataSender
extends Thread {
    private static final String urlAutoTemplate = "http://modstats.org/api/v1/report?mc=%s&user=%s&data=%s&sign=%s&beta=%b&strict=%b";
    private static final String urlManualTemplate = "http://modstats.org/api/v1/check?mc=%s&user=%s&data=%s&sign=%s&beta=%b&strict=%b";
    private final Reporter reporter;
    public final boolean manual;

    public DataSender(Reporter reporter, boolean manual) {
        this.reporter = reporter;
        this.manual = manual;
    }

    private String toHexString(byte[] bytes) {
        char[] hexArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = hexArray[v / 16];
            hexChars[j * 2 + 1] = hexArray[v % 16];
        }
        return new String(hexChars);
    }

    private String getPlayerId() throws IOException {
        String data;
        String storedMac;
        File statDir = new File(Minecraft.b(), "stats");
        if (!statDir.exists()) {
            statDir.mkdirs();
        }
        String mac = "";
        try {
            InetAddress address = InetAddress.getLocalHost();
            NetworkInterface ni = NetworkInterface.getByInetAddress(address);
            byte[] macArray = ni.getHardwareAddress();
            if (macArray != null) {
                mac = this.toHexString(macArray);
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        File uidFile = new File(statDir, "player.uid");
        if (uidFile.exists() && uidFile.canRead() && uidFile.length() == (long)(32 + mac.length()) && (storedMac = (data = Files.toString((File)uidFile, (Charset)Charsets.US_ASCII)).substring(32)).equalsIgnoreCase(mac)) {
            return data.substring(0, 32);
        }
        uidFile.createNewFile();
        if (uidFile.canWrite()) {
            String uid = UUID.randomUUID().toString().replace("-", "");
            FileOutputStream output = new FileOutputStream(uidFile);
            output.write((uid + mac).getBytes());
            output.close();
            return uid;
        }
        return "";
    }

    private String getSignature(String data) {
        return Hashing.md5().hashString((CharSequence)data).toString();
    }

    private String getData() {
        StringBuilder b = new StringBuilder();
        for (Map.Entry item : this.reporter.registeredMods.entrySet()) {
            b.append((String)item.getKey()).append("+").append(((ModVersionData)item.getValue()).version).append("$");
        }
        return b.toString();
    }

    private boolean checkIsNewer(String current, String received) {
        return new ComparableVersion(received).compareTo(new ComparableVersion(current)) > 0;
    }

    private void parseResponse(String response) {
        try {
            JsonRootNode json = new JdomParser().parse(response);
            if (!json.isNode(new Object[]{"mods"})) {
                FMLLog.info((String)"[Modstats] Empty result", (Object[])new Object[0]);
                return;
            }
            List modList = json.getArrayNode(new Object[]{"mods"});
            ModsUpdateEvent event = new ModsUpdateEvent();
            for (JsonNode modObject : modList) {
                String prefix = modObject.getStringValue(new Object[]{"code"});
                if (!this.reporter.registeredMods.containsKey(prefix)) {
                    FMLLog.warning((String)"[Modstats] Extra mod '%s' in service response", (Object[])new Object[]{prefix});
                    continue;
                }
                String version = modObject.getStringValue(new Object[]{"ver"});
                if (version == null || version.equals(((ModVersionData)this.reporter.registeredMods.get((Object)prefix)).version) || !this.checkIsNewer(((ModVersionData)this.reporter.registeredMods.get((Object)prefix)).version, version)) continue;
                ModVersionData data = new ModVersionData(prefix, ((ModVersionData)this.reporter.registeredMods.get((Object)prefix)).name, version);
                Map fields = modObject.getFields();
                for (Map.Entry entry : fields.entrySet()) {
                    String fieldName = ((JsonStringNode)entry.getKey()).getText();
                    if (fieldName.equals("code") || fieldName.equals("ver")) continue;
                    if (!(entry.getValue() instanceof JsonStringNode)) {
                        FMLLog.warning((String)String.format("[Modstats] Too complex data in response for field '%s'.", fieldName), (Object[])new Object[0]);
                        continue;
                    }
                    String value = ((JsonStringNode)entry.getValue()).getText();
                    if (fieldName.equals("chlog")) {
                        data.changeLogUrl = value;
                        continue;
                    }
                    if (fieldName.equals("link")) {
                        data.downloadUrl = value;
                        continue;
                    }
                    data.extraFields.put(fieldName, value);
                }
                event.add(data);
            }
            if (event.getUpdatedMods().size() > 0) {
                MinecraftForge.EVENT_BUS.post((Event)event);
            }
            if (!event.isCanceled() && event.getUpdatedMods().size() > 0) {
                List updatedModsToOutput = event.getUpdatedMods();
                StringBuilder builder = new StringBuilder("Updates found: ");
                Iterator iterator = updatedModsToOutput.iterator();
                while (iterator.hasNext()) {
                    ModVersionData modVersionData = (ModVersionData)iterator.next();
                    builder.append(modVersionData.name).append(" (").append(modVersionData.version).append(")").append(iterator.hasNext() ? "," : ".");
                }
                FMLLog.info((String)"[Modstats] %s", (Object[])new Object[]{builder.toString()});
                if (!this.reporter.config.logOnly && FMLCommonHandler.instance().getSide().isClient()) {
                    Minecraft mc = FMLClientHandler.instance().getClient();
                    for (int maxTries = 30; mc.g == null && maxTries > 0; --maxTries) {
                        try {
                            DataSender.sleep(1000L);
                            continue;
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                    }
                    if (mc.g != null) {
                        mc.g.b(builder.toString());
                    }
                }
            }
        }
        catch (InvalidSyntaxException e) {
            FMLLog.warning((String)"[Modstats] Can't parse response: '%s'.", (Object[])new Object[]{e.getMessage()});
        }
    }

    @Override
    public void run() {
        try {
            String line;
            String data = this.getData();
            String playerId = this.getPlayerId();
            String hash = this.getSignature(playerId + "!" + data);
            String template = this.manual ? urlManualTemplate : urlAutoTemplate;
            String mcVersion = new b(null).a();
            URL url = new URL(String.format(template, mcVersion, playerId, data, hash, this.reporter.config.betaNotifications, this.reporter.config.forCurrentMinecraftVersion));
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setConnectTimeout(5000);
            connection.setReadTimeout(5000);
            BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            String out = "";
            while ((line = reader.readLine()) != null) {
                out = out + line;
            }
            reader.close();
            this.parseResponse(out);
        }
        catch (MalformedURLException e) {
            FMLLog.warning((String)"[Modstats] Invalid stat report url", (Object[])new Object[0]);
        }
        catch (IOException e) {
            FMLLog.info((String)("[Modstats] Stat wasn't reported '" + e.getMessage() + "'"), (Object[])new Object[0]);
        }
        catch (Exception e) {
            FMLLog.warning((String)("[Modstats] Something wrong: " + e.toString()), (Object[])new Object[0]);
        }
    }
}

