/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.core.CommonUtils;
import codechicken.core.IGuiPacketSender;
import codechicken.core.ServerUtils;
import codechicken.core.inventory.SlotDummy;
import codechicken.core.packet.PacketCustom;
import codechicken.core.vec.BlockCoord;
import codechicken.nei.AllowedPropertyMap;
import codechicken.nei.ContainerCreativeInv;
import codechicken.nei.ContainerEnchantmentModifier;
import codechicken.nei.ExtendedCreativeInv;
import codechicken.nei.InterActionMap;
import codechicken.nei.ItemHash;
import codechicken.nei.NEIServerConfig;
import codechicken.nei.NEIServerUtils;
import cpw.mods.fml.relauncher.Side;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;

public class NEISPH
implements PacketCustom.ICustomPacketHandler.IServerPacketHandler {
    public static final String channel = "NEI";

    public void handlePacket(PacketCustom packet, iv nethandler, iq sender) {
        if (!NEIServerConfig.authenticatePacket(sender, packet)) {
            return;
        }
        switch (packet.getType()) {
            case 1: {
                this.handleGiveItem(sender, packet);
                break;
            }
            case 4: {
                NEIServerUtils.deleteAllItems(sender);
                break;
            }
            case 5: {
                this.setInventorySlot(sender, packet);
                break;
            }
            case 6: {
                NEIServerUtils.toggleMagnetMode(sender);
                break;
            }
            case 7: {
                NEIServerUtils.setHourForward(sender.p, packet.readUnsignedByte(), true);
                break;
            }
            case 8: {
                NEIServerUtils.healPlayer((qx)sender);
                break;
            }
            case 9: {
                NEIServerUtils.toggleRaining(sender.p, true);
                break;
            }
            case 10: {
                this.sendPermissableActionsTo(sender);
                this.sendBannedBlocksTo(sender);
                this.sendDisabledPropertiesTo(sender, sender.aq);
                NEISPH.sendMagnetModeTo(sender, NEIServerUtils.isMagnetMode(sender));
                NEISPH.sendCreativeModeTo(sender, NEIServerUtils.getCreativeMode(sender));
                break;
            }
            case 11: {
                sender.a(sender.bL, sender.bL.a());
                break;
            }
            case 12: {
                this.handlePropertyChange(sender, packet);
                break;
            }
            case 13: {
                NEIServerUtils.toggleCreativeMode(sender);
                break;
            }
            case 14: {
                NEIServerUtils.cycleCreativeInv(sender, packet.readInt());
                break;
            }
            case 15: {
                this.handleMobSpawnerID(sender.p, packet.readCoord(), packet.readString());
                break;
            }
            case 21: {
                this.openEnchantmentGui(sender);
                break;
            }
            case 22: {
                this.modifyEnchantment(sender, packet.readUnsignedByte(), packet.readUnsignedByte(), packet.readBoolean());
                break;
            }
            case 23: {
                this.processCreativeInv(sender, packet.readBoolean());
                break;
            }
            case 25: {
                this.handleDummySlotSet(sender, packet);
            }
        }
    }

    private void handleDummySlotSet(iq sender, PacketCustom packet) {
        short slotNumber = packet.readShort();
        ur stack = packet.readItemStack(true);
        sr slot = sender.bL.a((int)slotNumber);
        if (slot instanceof SlotDummy) {
            slot.c(stack);
        }
    }

    private void handleMobSpawnerID(yc world, BlockCoord coord, String mobtype) {
        any tile = world.q(coord.x, coord.y, coord.z);
        if (tile instanceof ans) {
            ((ans)tile).a(mobtype);
            tile.d();
            world.i(coord.x, coord.y, coord.z);
        }
    }

    private void handlePropertyChange(iq sender, PacketCustom packet) {
        int id = packet.readUnsignedByte();
        if (NEIServerConfig.canPlayerUseFeature(sender.bR, (String)AllowedPropertyMap.idToFeatureClassMap.get(id))) {
            this.handlePropertyChange(sender.aq, id, packet.readBoolean());
        }
    }

    private void processCreativeInv(iq sender, boolean open) {
        if (open) {
            ServerUtils.openSMPContainer((iq)sender, (rq)new ContainerCreativeInv((qx)sender, new ExtendedCreativeInv(NEIServerConfig.forPlayer(sender.bR), Side.SERVER)), (IGuiPacketSender)new IGuiPacketSender(){

                public void sendPacket(iq player, int windowId) {
                    PacketCustom packet = new PacketCustom((Object)NEISPH.channel, 23);
                    packet.writeBoolean(true);
                    packet.writeByte(windowId);
                    ServerUtils.sendPacketTo((qx)player, (ef)packet.toPacket());
                }
            });
        } else {
            sender.k();
            PacketCustom packet = new PacketCustom((Object)channel, 23);
            packet.writeBoolean(false);
            ServerUtils.sendPacketTo((qx)sender, (ef)packet.toPacket());
        }
    }

    private void handlePropertyChange(int dim, int propID, boolean disable) {
        NEIServerConfig.setPropertyDisabled(dim, (String)AllowedPropertyMap.idToNameMap.get(propID), disable);
        this.sendDisabledPropertiesTo(null, dim);
    }

    private void sendDisabledPropertiesTo(iq player, int dim) {
        ArrayList<Integer> disabledProperties = new ArrayList<Integer>();
        for (Map.Entry prop : AllowedPropertyMap.nameToIDMap.entrySet()) {
            if (!NEIServerConfig.isPropertyDisabled(dim, (String)prop.getKey())) continue;
            disabledProperties.add((Integer)prop.getValue());
        }
        PacketCustom packet = new PacketCustom((Object)channel, 12);
        packet.writeByte(disabledProperties.size());
        Iterator iterator = disabledProperties.iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            packet.writeByte(i);
        }
        if (player != null) {
            ServerUtils.sendPacketTo((qx)player, (ef)packet.toPacket());
        } else {
            for (qx sendplayer : ServerUtils.getPlayersInDimension((int)dim)) {
                ServerUtils.sendPacketTo((qx)sendplayer, (ef)packet.toPacket());
            }
        }
    }

    private void handleGiveItem(iq player, PacketCustom packet) {
        boolean infinite = packet.readBoolean();
        boolean doSpawn = packet.readBoolean();
        int num = packet.readUnsignedByte();
        LinkedList<String> name = new LinkedList<String>();
        int i = 0;
        while (i < num) {
            name.add(packet.readString());
            ++i;
        }
        ur item = packet.readItemStack();
        if (item == null) {
            ServerUtils.sendChatTo((iq)player, (String)"\u00a7fNo such item.");
            return;
        }
        item.a = packet.readInt();
        NEIServerUtils.givePlayerItem(player, item, infinite, name, doSpawn);
    }

    private void setInventorySlot(iq player, PacketCustom packet) {
        boolean container = packet.readBoolean();
        short slot = packet.readShort();
        ur item = packet.readItemStack();
        if (!NEIServerConfig.canPlayerUseFeature(player.bR, item == null ? "delete" : "item")) {
            return;
        }
        NEIServerUtils.setSlotContents((qx)player, slot, item, container);
    }

    private void modifyEnchantment(iq player, int e, int lvl, boolean add) {
        ContainerEnchantmentModifier containerem = (ContainerEnchantmentModifier)player.bL;
        if (add) {
            containerem.addEnchantment(e, lvl);
        } else {
            containerem.removeEnchantment(e);
        }
    }

    private void openEnchantmentGui(iq player) {
        ServerUtils.openSMPContainer((iq)player, (rq)new ContainerEnchantmentModifier(player.bJ, player.p, 0, 0, 0), (IGuiPacketSender)new IGuiPacketSender(){

            public void sendPacket(iq player, int windowId) {
                PacketCustom packet = new PacketCustom((Object)NEISPH.channel, 21);
                packet.writeByte(windowId);
                ServerUtils.sendPacketTo((qx)player, (ef)packet.toPacket());
            }
        });
    }

    public static void sendMagnetModeTo(iq player, boolean enable) {
        PacketCustom packet = new PacketCustom((Object)channel, 6);
        packet.writeBoolean(enable);
        ServerUtils.sendPacketTo((qx)player, (ef)packet.toPacket());
    }

    public static void sendCreativeModeTo(iq player, int mode) {
        PacketCustom packet = new PacketCustom((Object)channel, 7);
        packet.writeByte(mode);
        ServerUtils.sendPacketTo((qx)player, (ef)packet.toPacket());
    }

    private void sendPermissableActionsTo(iq player) {
        LinkedList<Integer> actions = new LinkedList<Integer>();
        InterActionMap[] interActionMapArray = InterActionMap.values();
        int n = interActionMapArray.length;
        int n2 = 0;
        while (n2 < n) {
            InterActionMap action = interActionMapArray[n2];
            if (NEIServerConfig.canPlayerUseFeature(player.bR, action.getName())) {
                actions.add(action.ordinal());
            }
            ++n2;
        }
        PacketCustom packet = new PacketCustom((Object)channel, 10);
        packet.writeByte(actions.size());
        Iterator iterator = actions.iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            packet.writeByte(i);
        }
        ServerUtils.sendPacketTo((qx)player, (ef)packet.toPacket());
    }

    private void sendBannedBlocksTo(iq player) {
        ArrayList<ItemHash> bannedblocks = new ArrayList<ItemHash>();
        for (Map.Entry entry : NEIServerConfig.bannedblocks.entrySet()) {
            if (NEIServerConfig.isPlayerInList(player.bR, (HashSet)entry.getValue(), true)) continue;
            bannedblocks.add((ItemHash)entry.getKey());
        }
        PacketCustom packet = new PacketCustom((Object)channel, 11);
        packet.writeInt(bannedblocks.size());
        for (ItemHash hash : bannedblocks) {
            packet.writeShort((int)hash.item);
            packet.writeShort((int)hash.damage);
        }
        ServerUtils.sendPacketTo((qx)player, (ef)packet.toPacket());
    }

    public static void sendHasServerSideTo(iq player) {
        System.out.println("Sending serverside check to: " + player.bR);
        PacketCustom packet = new PacketCustom((Object)channel, 1);
        packet.writeByte(4);
        packet.writeString(CommonUtils.getWorldName((yc)player.p));
        ServerUtils.sendPacketTo((qx)player, (ef)packet.toPacket());
    }

    public static void sendAddMagneticItemTo(iq player, px item) {
        PacketCustom packet = new PacketCustom((Object)channel, 13);
        packet.writeInt(item.k);
        ServerUtils.sendPacketTo((qx)player, (ef)packet.toPacket());
    }
}

