/*
 * Decompiled with CFR 0.152.
 */
package thaumicbees.bees;

import forestry.api.apiculture.IAlleleBeeEffect;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.genetics.IEffectData;
import java.util.List;
import thaumicbees.bees.Allele;
import thaumicbees.main.ThaumicBees;
import thaumicbees.main.utils.LocalizationManager;

public abstract class AlleleEffect
extends Allele
implements IAlleleBeeEffect {
    public AlleleEffect(String id, boolean isDominant) {
        super(id, isDominant);
    }

    public boolean isCombinable() {
        return false;
    }

    public abstract IEffectData validateStorage(IEffectData var1);

    public String getIdentifier() {
        return LocalizationManager.getLocalizedString(this.getUID());
    }

    public abstract IEffectData doEffect(IBeeGenome var1, IEffectData var2, IBeeHousing var3);

    public IEffectData doFX(IBeeGenome genome, IEffectData storedData, IBeeHousing housing) {
        int[] area = genome.getTerritory();
        float mod = housing.getTerritoryModifier(genome);
        area[0] = Math.max((int)((float)area[0] * mod), 1);
        area[1] = Math.max((int)((float)area[1] * mod), 1);
        area[2] = Math.max((int)((float)area[2] * mod), 1);
        ThaumicBees.proxy.drawBeeEffects(housing.getWorld(), housing.getXCoord(), housing.getYCoord(), housing.getZCoord(), genome.getPrimaryAsBee().getPrimaryColor(), area[0], area[1], area[2]);
        return storedData;
    }

    public String getIconTextureFile() {
        return null;
    }

    public int getIconIndex() {
        return -1;
    }

    protected List getEntitiesWithinRange(IBeeGenome genome, IBeeHousing housing) {
        int[] area = genome.getTerritory();
        int[] min = new int[3];
        int[] max = new int[3];
        min[0] = housing.getXCoord() - area[0] / 2;
        max[0] = housing.getXCoord() + area[0] / 2;
        min[1] = housing.getYCoord() - area[1] / 2;
        max[1] = housing.getYCoord() + area[1] / 2;
        min[2] = housing.getZCoord() - area[2] / 2;
        max[2] = housing.getZCoord() + area[2] / 2;
        aoe bounds = aoe.a().a((double)min[0], (double)min[1], (double)min[2], (double)max[0], (double)max[1], (double)max[2]);
        return housing.getWorld().a(qx.class, bounds);
    }
}

