/*
 * Decompiled with CFR 0.152.
 */
package thaumicbees.bees;

import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAlleleSpecies;
import forestry.api.genetics.IClassification;
import java.util.ArrayList;
import thaumicbees.main.utils.LocalizationManager;

public enum BeeClassification implements IClassification
{
    ARCANE("Arcane", "Arcanus"),
    SUPERNATURAL("Supernatural", "Occultus"),
    SCHOLARLY("Scholarly", "Docto"),
    THAUMIC("Thaumic", "Thaumis"),
    SKULKING("Skulking", "Malevolens"),
    VIS("Vis", "Vis"),
    TIME("Time", "Tempestivus"),
    SOUL("Soul", "Animus"),
    ALCHEMICAL("Alchemical", "Alchimia"),
    METALLIC("Metallic", "Metallicis"),
    GEM("Gem", "Lapidi"),
    FLESHY("Fleshy", "Carnosa");

    private String uID;
    private String latin;
    private ArrayList species;
    private IClassification parent;
    private IClassification.EnumClassLevel level;

    /*
     * WARNING - void declaration
     */
    private BeeClassification() {
        void scientific;
        void name;
        this.uID = "classification." + name.toLowerCase();
        this.latin = scientific;
        this.level = IClassification.EnumClassLevel.GENUS;
        this.species = new ArrayList();
        this.parent = AlleleManager.alleleRegistry.getClassification("family.apidae");
        AlleleManager.alleleRegistry.registerClassification((IClassification)this);
    }

    public IClassification.EnumClassLevel getLevel() {
        return this.level;
    }

    public String getUID() {
        return this.uID;
    }

    public String getName() {
        return LocalizationManager.getLocalizedString(this.getUID());
    }

    public String getScientific() {
        return this.latin;
    }

    public String getDescription() {
        return LocalizationManager.getLocalizedString(this.getUID() + ".description");
    }

    public IClassification[] getMemberGroups() {
        return null;
    }

    public void addMemberGroup(IClassification group) {
    }

    public IAlleleSpecies[] getMemberSpecies() {
        return this.species.toArray(new IAlleleSpecies[this.species.size()]);
    }

    public void addMemberSpecies(IAlleleSpecies species) {
        if (!this.species.contains(species)) {
            this.species.add(species);
        }
    }

    public IClassification getParent() {
        return this.parent;
    }

    public void setParent(IClassification parent) {
        this.parent = parent;
    }
}

