/*
 * Decompiled with CFR 0.152.
 */
package thaumicbees.item.types;

import thaumcraft.api.EnumTag;
import thaumcraft.api.ObjectTags;
import thaumicbees.main.utils.LocalizationManager;

public enum HiveFrameType {
    MAGIC("magic", 32, 240, 1.0f, 1.0f, 1.0f, 2.0f, 2, 5, null),
    RESILIENT("resillient", 33, 840, 1.0f, 1.0f, 1.0f, 2.0f, 2, 5, new ObjectTags().add(EnumTag.ARMOR, 1)),
    GENTLE("gentle", 34, 200, 1.0f, 0.7f, 1.5f, 1.4f, 1, 5, new ObjectTags().add(EnumTag.HEAL, 1).add(EnumTag.LIFE, 1)),
    METABOLIC("metabolic", 35, 120, 1.0f, 1.8f, 1.0f, 1.2f, 5, 5, new ObjectTags().add(EnumTag.EXCHANGE, 1).add(EnumTag.MOTION, 1)),
    NECROTIC("necrotic", 36, 290, 1.0f, 1.0f, 0.3f, 0.75f, 1, 5, new ObjectTags().add(EnumTag.DEATH, 3).add(EnumTag.POISON, 2)),
    TEMPORAL("temporal", 37, 300, 1.0f, 1.0f, 2.5f, 1.0f, 1, 5, new ObjectTags().add(EnumTag.TIME, 5)),
    OBLIVION("oblivion", 38, 60, 1.0f, 1.0f, 1.0E-4f, 0.0f, 15, 1, new ObjectTags().add(EnumTag.TIME, 5).add(EnumTag.DEATH, 5));

    private String frameName;
    public int iconIdx;
    public int maxDamage;
    public float territoryMod;
    public float mutationMod;
    public float lifespanMod;
    public float productionMod;
    public float floweringMod;
    public boolean isSealed;
    public boolean isLit;
    public boolean isSunlit;
    public boolean isHellish;
    public ObjectTags flux;
    public int auraPerUse;
    public int wearTicksPerAura;

    /*
     * WARNING - Possible parameter corruption
     * WARNING - void declaration
     */
    private HiveFrameType(int name, float icon, float damage, float territory, float mutation, int lifespan, int production, ObjectTags auraUse) {
        this((String)var1_-1, (int)var2_-1, (String)name, (int)icon, (int)damage, territory, mutation, lifespan, production, 1.0f, false, false, false, false, (int)auraUse, (int)wearTicks, (ObjectTags)fluxTags);
        void fluxTags;
        void wearTicks;
        void var2_-1;
        void var1_-1;
    }

    /*
     * WARNING - Possible parameter corruption
     * WARNING - void declaration
     */
    private HiveFrameType(int name, float icon, float damage, float territory, float mutation, float lifespan, boolean production, boolean flowering, boolean sealed, boolean lit, int sunlit, int hellish, ObjectTags auraUse) {
        void wearTicks;
        void fluxTags;
        this.frameName = (String)name;
        this.iconIdx = (int)icon;
        this.maxDamage = (int)damage;
        this.territoryMod = territory;
        this.mutationMod = mutation;
        this.lifespanMod = lifespan;
        this.productionMod = (float)production;
        this.floweringMod = (float)flowering;
        this.isSealed = sealed;
        this.isLit = lit;
        this.isSunlit = sunlit;
        this.isHellish = hellish;
        this.auraPerUse = (int)auraUse;
        this.flux = fluxTags;
        this.wearTicksPerAura = wearTicks;
    }

    public String getName() {
        return LocalizationManager.getLocalizedString("tb.frame." + this.frameName);
    }
}

