/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.general.gui.frame;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.machinemuse.api.IPowerModule;
import net.machinemuse.api.IToggleableModule;
import net.machinemuse.api.MuseItemUtils;
import net.machinemuse.general.MuseRenderer;
import net.machinemuse.general.geometry.Colour;
import net.machinemuse.general.geometry.MusePoint2D;
import net.machinemuse.general.gui.MuseGui;
import net.machinemuse.general.gui.clickable.ClickableButton;
import net.machinemuse.general.gui.clickable.ClickableKeybinding;
import net.machinemuse.general.gui.clickable.ClickableModule;
import net.machinemuse.general.gui.clickable.IClickable;
import net.machinemuse.general.gui.frame.IGuiFrame;
import net.machinemuse.powersuits.client.KeybindManager;
import net.machinemuse.powersuits.common.Config;
import org.lwjgl.input.Keyboard;

public class KeybindConfigFrame
implements IGuiFrame {
    protected Set modules = new HashSet();
    protected IClickable selectedClickie;
    protected ClickableKeybinding closestKeybind;
    protected qx player;
    protected MusePoint2D ul;
    protected MusePoint2D br;
    protected MuseGui gui;
    protected boolean selecting;
    protected ClickableButton newKeybindButton;
    protected ClickableButton trashKeybindButton;
    protected long takenTime;

    public KeybindConfigFrame(MuseGui gui, MusePoint2D ul, MusePoint2D br, qx player) {
        for (ClickableKeybinding kb : KeybindManager.getKeybindings()) {
            for (ClickableModule module : kb.getBoundModules()) {
                this.modules.add(module);
            }
        }
        this.gui = gui;
        this.ul = ul;
        this.br = br;
        this.player = player;
        MusePoint2D center = br.plus(ul).times(0.5);
        this.newKeybindButton = new ClickableButton("New", center.plus(new MusePoint2D(0.0, -8.0)), true);
        this.trashKeybindButton = new ClickableButton("Trash", center.plus(new MusePoint2D(0.0, 8.0)), true);
    }

    @Override
    public void onMouseDown(double x, double y, int button) {
        if (button == 0) {
            if (this.selectedClickie == null) {
                for (ClickableModule module : this.modules) {
                    if (!module.hitBox(x, y)) continue;
                    this.selectedClickie = module;
                    return;
                }
                for (ClickableKeybinding keybind : KeybindManager.getKeybindings()) {
                    if (!keybind.hitBox(x, y)) continue;
                    this.selectedClickie = keybind;
                    return;
                }
            }
            if (this.newKeybindButton.hitBox(x, y)) {
                this.selecting = true;
            }
        }
    }

    public void refreshModules() {
        List installedModules = MuseItemUtils.getPlayerInstalledModules(this.player);
        List points = MuseRenderer.pointsInLine(installedModules.size(), new MusePoint2D(this.ul.x() + 10.0, this.ul.y() + 10.0), new MusePoint2D(this.ul.x() + 10.0, this.br.y() - 10.0));
        Iterator pointIterator = points.iterator();
        for (IPowerModule module : installedModules) {
            if (!(module instanceof IToggleableModule) || this.alreadyAdded(module)) continue;
            ClickableModule clickie = new ClickableModule(module, (MusePoint2D)pointIterator.next());
            this.modules.add(clickie);
        }
    }

    public boolean alreadyAdded(IPowerModule module) {
        for (ClickableModule clickie : this.modules) {
            if (!clickie.getModule().getName().equals(module.getName())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void onMouseUp(double x, double y, int button) {
        if (button == 0) {
            if (this.selectedClickie != null && this.closestKeybind != null && this.selectedClickie instanceof ClickableModule) {
                this.closestKeybind.bindModule((ClickableModule)this.selectedClickie);
            } else if (this.selectedClickie != null && this.selectedClickie instanceof ClickableKeybinding && this.trashKeybindButton.hitBox(x, y)) {
                arv binding = ((ClickableKeybinding)this.selectedClickie).getKeyBinding();
                arv.a.remove(binding);
                arv.b.d(binding.d);
                KeybindManager.getKeybindings().remove(this.selectedClickie);
            }
            this.selectedClickie = null;
        }
    }

    @Override
    public void update(double mousex, double mousey) {
        if (this.selecting) {
            return;
        }
        this.refreshModules();
        this.closestKeybind = null;
        double closestDistance = Double.MAX_VALUE;
        if (this.selectedClickie != null) {
            this.selectedClickie.move(mousex, mousey);
            if (this.selectedClickie instanceof ClickableModule) {
                ClickableModule selectedModule = (ClickableModule)this.selectedClickie;
                for (ClickableKeybinding keybind : KeybindManager.getKeybindings()) {
                    double distance = keybind.getPosition().minus(selectedModule.getPosition()).distance();
                    if (!(distance < closestDistance) || !((closestDistance = distance) < 32.0)) continue;
                    this.closestKeybind = keybind;
                }
            }
        }
        for (IClickable keybind : KeybindManager.getKeybindings()) {
            if (keybind != this.selectedClickie) {
                keybind.unbindFarModules();
            }
            keybind.attractBoundModules(this.selectedClickie);
        }
        for (IClickable module : this.modules) {
            if (module == this.selectedClickie) continue;
            this.repelOtherModules(module);
        }
        for (IClickable keybind : KeybindManager.getKeybindings()) {
            if (keybind == this.selectedClickie) continue;
            this.repelOtherModules(keybind);
        }
        for (IClickable module : this.modules) {
            this.clampClickiePosition(module);
        }
        for (IClickable keybind : KeybindManager.getKeybindings()) {
            this.clampClickiePosition(keybind);
        }
    }

    private void clampClickiePosition(IClickable clickie) {
        MusePoint2D position = clickie.getPosition();
        position.setX(this.clampDouble(position.x(), this.ul.x(), this.br.x()));
        position.setY(this.clampDouble(position.y(), this.ul.y(), this.br.y()));
    }

    private double clampDouble(double x, double lower, double upper) {
        if (x < lower) {
            return lower;
        }
        if (x > upper) {
            return upper;
        }
        return x;
    }

    private void repelOtherModules(IClickable module) {
        MusePoint2D modulePosition = module.getPosition();
        for (ClickableModule otherModule : this.modules) {
            if (otherModule == this.selectedClickie || otherModule == module || !(otherModule.getPosition().distanceTo(modulePosition) < 16.0)) continue;
            MusePoint2D euclideanDistance = otherModule.getPosition().minus(module.getPosition());
            MusePoint2D directionVector = euclideanDistance.normalize();
            MusePoint2D tangentTarget = directionVector.times(16.0).plus(module.getPosition());
            MusePoint2D midpointTangent = otherModule.getPosition().midpoint(tangentTarget);
            if (!(midpointTangent.distanceTo(module.getPosition()) > 2.0)) continue;
            otherModule.move(midpointTangent.x(), midpointTangent.y());
        }
    }

    @Override
    public void draw() {
        MusePoint2D center = this.ul.plus(this.br).times(0.5);
        if (this.selecting) {
            MuseRenderer.drawCenteredString("Press Key", center.x(), center.y());
            return;
        }
        this.newKeybindButton.draw();
        this.trashKeybindButton.draw();
        MuseRenderer.drawCenteredString("Use 'new' to bind new keys.", center.x(), center.y() + 40.0);
        MuseRenderer.drawCenteredString("Drag and drop modules to bind them to keys.", center.x(), center.y() + 50.0);
        MuseRenderer.drawCenteredString("Drop keys on 'trash' to unbind them.", center.x(), center.y() + 60.0);
        if (this.takenTime + 1000L > System.currentTimeMillis()) {
            MusePoint2D pos = this.newKeybindButton.getPosition().plus(new MusePoint2D(0.0, -20.0));
            MuseRenderer.drawCenteredString("Taken!", pos.x(), pos.y());
        }
        for (ClickableModule module : this.modules) {
            module.draw();
        }
        for (ClickableKeybinding keybind : KeybindManager.getKeybindings()) {
            keybind.draw();
        }
        if (this.selectedClickie != null && this.closestKeybind != null) {
            MuseRenderer.drawLineBetween(this.selectedClickie, this.closestKeybind, Colour.YELLOW);
        }
    }

    @Override
    public List getToolTip(int x, int y) {
        if (Config.doAdditionalInfo()) {
            for (ClickableModule module : this.modules) {
                if (!module.hitBox(x, y)) continue;
                return module.getToolTip();
            }
        }
        return null;
    }

    public void handleKeyboard() {
        if (this.selecting && Keyboard.getEventKeyState()) {
            int key = Keyboard.getEventKey();
            if (!arv.b.b(key)) {
                arv keybind = new arv(Keyboard.getKeyName((int)key), key);
                ClickableKeybinding clickie = new ClickableKeybinding(keybind, this.newKeybindButton.getPosition().plus(new MusePoint2D(0.0, -20.0)));
                KeybindManager.getKeybindings().add(clickie);
            } else {
                this.takenTime = System.currentTimeMillis();
            }
            this.selecting = false;
        }
    }
}

