/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.item;

import atomicscience.api.IAntiPoisonArmor;
import atomicscience.api.Poison;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.ICustomElectricItem;
import icbm.api.explosion.IEMPItem;
import icbm.api.explosion.IExplosive;
import java.util.ArrayList;
import java.util.List;
import net.machinemuse.api.ElectricItemUtils;
import net.machinemuse.api.IModularItem;
import net.machinemuse.api.ModuleManager;
import net.machinemuse.api.MuseCommonStrings;
import net.machinemuse.api.MuseItemUtils;
import net.machinemuse.general.MuseStringUtils;
import net.machinemuse.general.geometry.Colour;
import net.machinemuse.powersuits.common.Config;
import net.machinemuse.powersuits.common.ModCompatability;
import net.machinemuse.powersuits.item.ItemPowerArmorLegs;
import net.minecraftforge.common.IArmorTextureProvider;
import net.minecraftforge.common.ISpecialArmor;
import thermalexpansion.api.core.IChargeableItem;
import universalelectricity.core.electricity.ElectricInfo;
import universalelectricity.core.implement.IItemElectric;

public abstract class ItemPowerArmor
extends su
implements ISpecialArmor,
IModularItem,
IArmorTextureProvider,
IItemElectric,
ICustomElectricItem,
IEMPItem,
IAntiPoisonArmor,
IChargeableItem {
    Config.Items itemType;

    public ItemPowerArmor(int id, int renderIndex, int armorType) {
        super(id, sv.a, renderIndex, armorType);
        this.setTextureFile("/resources/machinemuse/sebkicons.png");
        this.d(1);
        this.a(Config.getCreativeTab());
    }

    public String getArmorTextureFile(ur itemstack) {
        if (itemstack != null) {
            bq itemTag = MuseItemUtils.getMuseItemTag(itemstack);
            if (itemTag.b("didColour")) {
                itemTag.o("didColour");
                return "/resources/machinemuse/blankarmor.png";
            }
            if (MuseItemUtils.itemHasActiveModule(itemstack, "Transparent Armor")) {
                return "/resources/machinemuse/blankarmor.png";
            }
            if (itemstack.b() instanceof ItemPowerArmorLegs) {
                if (MuseItemUtils.itemHasModule(itemstack, "Citizen Joe Style")) {
                    return "/resources/machinemuse/joearmorpants.png";
                }
                return "/resources/machinemuse/sebkarmorpants.png";
            }
            if (MuseItemUtils.itemHasModule(itemstack, "Citizen Joe Style")) {
                return "/resources/machinemuse/joearmor.png";
            }
            return "/resources/machinemuse/sebkarmor.png";
        }
        return "/resources/machinemuse/blankarmor.png";
    }

    public ISpecialArmor.ArmorProperties getProperties(md player, ur armor, lh source, double damage, int slot) {
        int priority = 1;
        double armorDouble = player instanceof qx ? this.getArmorDouble((qx)player, armor) : 2.0;
        double absorbRatio = 0.04 * armorDouble;
        int absorbMax = (int)armorDouble * 75;
        return new ISpecialArmor.ArmorProperties(priority, absorbRatio, absorbMax);
    }

    public static double clampDouble(double value, double min, double max) {
        if (value < min) {
            return min;
        }
        if (value > max) {
            return max;
        }
        return value;
    }

    public int c() {
        return 0;
    }

    public Colour getColorFromItemStack(ur stack) {
        double computedred = ModuleManager.computeModularProperty(stack, "Red Tint");
        double computedgreen = ModuleManager.computeModularProperty(stack, "Green Tint");
        double computedblue = ModuleManager.computeModularProperty(stack, "Blue Tint");
        Colour colour = new Colour(ItemPowerArmor.clampDouble(1.0 + computedred - (computedblue + computedgreen), 0.0, 1.0), ItemPowerArmor.clampDouble(1.0 + computedgreen - (computedblue + computedred), 0.0, 1.0), ItemPowerArmor.clampDouble(1.0 + computedblue - (computedred + computedgreen), 0.0, 1.0), 1.0);
        return colour;
    }

    @SideOnly(value=Side.CLIENT)
    public int a(ur stack, int par2) {
        Colour c = this.getColorFromItemStack(stack);
        return c.getInt();
    }

    public int b(ur stack) {
        bq itemTag = MuseItemUtils.getMuseItemTag(stack);
        itemTag.a("didColour", "yes");
        Colour c = this.getColorFromItemStack(stack);
        return c.getInt();
    }

    @SideOnly(value=Side.CLIENT)
    public boolean b() {
        return false;
    }

    public boolean a(ur stack) {
        bq itemTag = MuseItemUtils.getMuseItemTag(stack);
        return MuseItemUtils.tagHasModule(itemTag, "Red Tint") || MuseItemUtils.tagHasModule(itemTag, "Green Tint") || MuseItemUtils.tagHasModule(itemTag, "Blue Tint");
    }

    public int getArmorDisplay(qx player, ur armor, int slot) {
        return (int)this.getArmorDouble(player, armor);
    }

    public double getArmorDouble(qx player, ur stack) {
        double totalArmor = 0.0;
        bq props = MuseItemUtils.getMuseItemTag(stack);
        double energy = ElectricItemUtils.getPlayerEnergy(player);
        double physArmor = ModuleManager.computeModularProperty(stack, "Armor (Physical)");
        double enerArmor = ModuleManager.computeModularProperty(stack, "Armor (Energy)");
        double enerConsum = ModuleManager.computeModularProperty(stack, "Energy Per Damage");
        totalArmor += physArmor;
        if (energy > enerConsum) {
            totalArmor += enerArmor;
        }
        totalArmor = Math.min(6.0, totalArmor);
        return totalArmor;
    }

    public void damageArmor(md entity, ur stack, lh source, int damage, int slot) {
        bq itemProperties = MuseItemUtils.getMuseItemTag(stack);
        double enerConsum = ModuleManager.computeModularProperty(stack, "Energy Per Damage");
        double drain = enerConsum * (double)damage;
        if (entity instanceof qx) {
            ElectricItemUtils.drainPlayerEnergy((qx)entity, drain);
        } else {
            this.onUse(drain, stack);
        }
    }

    @Override
    public Config.Items getItemType() {
        return this.itemType;
    }

    public void a(ur stack, qx player, List currentTipList, boolean advancedToolTips) {
        MuseCommonStrings.addInformation(stack, player, currentTipList, advancedToolTips);
    }

    public static String formatInfo(String string, double value) {
        return string + "\t" + MuseStringUtils.formatNumberShort(value);
    }

    @Override
    public List getLongInfo(qx player, ur stack) {
        ArrayList<String> info = new ArrayList<String>();
        bq itemProperties = MuseItemUtils.getMuseItemTag(stack);
        info.add("Detailed Summary");
        info.add(ItemPowerArmor.formatInfo("Armor", this.getArmorDouble(player, stack)));
        info.add(ItemPowerArmor.formatInfo("Energy Storage", this.getMaxJoules(stack)) + "J");
        info.add(ItemPowerArmor.formatInfo("Weight", MuseCommonStrings.getTotalWeight(stack)) + "g");
        return info;
    }

    @Override
    public double onReceive(double amps, double voltage, ur itemStack) {
        double amount = ElectricInfo.getJoules(amps, voltage, 1.0);
        return ElectricItemUtils.charge(amount, itemStack);
    }

    @Override
    public double onUse(double joulesNeeded, ur itemStack) {
        return ElectricItemUtils.discharge(joulesNeeded, itemStack);
    }

    @Override
    public double getJoules(Object ... data) {
        return ElectricItemUtils.getJoules(this.getAsStack(data));
    }

    @Override
    public void setJoules(double joules, Object ... data) {
        ElectricItemUtils.setJoules(joules, this.getAsStack(data));
    }

    @Override
    public double getMaxJoules(Object ... data) {
        return ElectricItemUtils.getMaxJoules(this.getAsStack(data));
    }

    @Override
    public double getVoltage(Object ... data) {
        return ElectricItemUtils.getVoltage(this.getAsStack(data));
    }

    @Override
    public boolean canReceiveElectricity() {
        return true;
    }

    @Override
    public boolean canProduceElectricity() {
        return true;
    }

    private ur getAsStack(Object[] data) {
        if (data[0] instanceof ur) {
            return (ur)data[0];
        }
        throw new IllegalArgumentException("MusePowerSuits: Invalid ItemStack passed via UE interface");
    }

    @Override
    public int charge(ur stack, int amount, int tier, boolean ignoreTransferLimit, boolean simulate) {
        double joulesProvided = ModCompatability.joulesFromEU(amount);
        double maxJoules = ElectricItemUtils.getMaxJoules(stack);
        if (!ignoreTransferLimit && joulesProvided > maxJoules / 200.0) {
            joulesProvided = maxJoules / 200.0;
        }
        double currentJoules = ElectricItemUtils.getJoules(stack);
        double surplus = ElectricItemUtils.charge(joulesProvided, stack);
        if (simulate) {
            ElectricItemUtils.setJoules(currentJoules, stack);
        }
        return ModCompatability.joulesToEU(joulesProvided - surplus);
    }

    @Override
    public int discharge(ur stack, int amount, int tier, boolean ignoreTransferLimit, boolean simulate) {
        double joulesRequested = ModCompatability.joulesFromEU(amount);
        double maxJoules = ElectricItemUtils.getMaxJoules(stack);
        if (!ignoreTransferLimit && joulesRequested > maxJoules / 200.0) {
            joulesRequested = maxJoules / 200.0;
        }
        double currentJoules = ElectricItemUtils.getJoules(stack);
        double givenJoules = ElectricItemUtils.discharge(joulesRequested, stack);
        if (simulate) {
            ElectricItemUtils.setJoules(currentJoules, stack);
        }
        return ModCompatability.joulesToEU(givenJoules);
    }

    @Override
    public boolean canUse(ur stack, int amount) {
        double joulesRequested = ModCompatability.joulesFromEU(amount);
        double currentJoules = ElectricItemUtils.getJoules(stack);
        return currentJoules > joulesRequested;
    }

    @Override
    public boolean canShowChargeToolTip(ur itemStack) {
        return false;
    }

    @Override
    public boolean canProvideEnergy() {
        return true;
    }

    @Override
    public int getChargedItemId() {
        return this.cj;
    }

    @Override
    public int getEmptyItemId() {
        return this.cj;
    }

    @Override
    public int getMaxCharge() {
        return 1;
    }

    @Override
    public int getTier() {
        return 1;
    }

    @Override
    public int getTransferLimit() {
        return 0;
    }

    @Override
    public void onEMP(ur itemStack, lq entity, IExplosive empExplosive) {
        ElectricItemUtils.onEMP(itemStack, entity, empExplosive);
    }

    @Override
    public boolean isProtectedFromPoison(ur itemStack, md entityLiving, Poison type) {
        return MuseItemUtils.itemHasModule(itemStack, "Radiation Shielding");
    }

    @Override
    public void onProtectFromPoison(ur itemStack, md entityLiving, Poison type) {
    }

    @Override
    public float receiveEnergy(ur theItem, float energy, boolean doReceive) {
        return 0.0f;
    }

    @Override
    public float transferEnergy(ur theItem, float energy, boolean doTransfer) {
        return 0.0f;
    }

    @Override
    public float getEnergyStored(ur theItem) {
        return 0.0f;
    }

    @Override
    public float getMaxEnergyStored(ur theItem) {
        return 0.0f;
    }
}

