/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.network.packets;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.common.network.Player;
import cpw.mods.fml.relauncher.Side;
import java.io.DataInputStream;
import java.util.ArrayList;
import java.util.List;
import net.machinemuse.api.IPowerModule;
import net.machinemuse.api.ModuleManager;
import net.machinemuse.api.MuseItemUtils;
import net.machinemuse.powersuits.item.ItemComponent;
import net.machinemuse.powersuits.network.MusePacket;
import net.machinemuse.powersuits.network.packets.MusePacketInventoryRefresh;
import universalelectricity.core.implement.IItemElectric;

public class MusePacketInstallModuleRequest
extends MusePacket {
    protected ur stack;
    protected int itemSlot;
    protected String moduleName;

    public MusePacketInstallModuleRequest(Player player, int itemSlot, String moduleName) {
        super(player);
        this.writeInt(itemSlot);
        this.writeString(moduleName);
    }

    public MusePacketInstallModuleRequest(DataInputStream data, Player player) {
        super(data, player);
        this.itemSlot = this.readInt();
        this.moduleName = this.readString(64);
        Side side = FMLCommonHandler.instance().getEffectiveSide();
        if (side == Side.SERVER) {
            iq srvplayer = (iq)player;
            this.stack = srvplayer.bJ.a(this.itemSlot);
        }
    }

    @Override
    public void handleServer(iq playerEntity) {
        if (this.moduleName != null) {
            qw inventory = playerEntity.bJ;
            IPowerModule moduleType = ModuleManager.getModule(this.moduleName);
            if (moduleType == null || !moduleType.isAllowed()) {
                playerEntity.a("Server has disallowed this module. Sorry!");
                return;
            }
            List cost = moduleType.getInstallCost();
            if (!MuseItemUtils.itemHasModule(this.stack, this.moduleName) && MuseItemUtils.hasInInventory(cost, playerEntity.bJ) || playerEntity.cd.d) {
                MuseItemUtils.itemAddModule(this.stack, moduleType);
                for (ur itemCost : cost) {
                    if (!(this.stack.b() instanceof IItemElectric)) continue;
                    IItemElectric elecItem = (IItemElectric)this.stack.b();
                    double joules = elecItem.getJoules(this.stack);
                    if (MuseItemUtils.isSameItem(itemCost, ItemComponent.lvcapacitor)) {
                        elecItem.setJoules(joules + 20000.0, this.stack);
                    }
                    if (MuseItemUtils.isSameItem(itemCost, ItemComponent.mvcapacitor)) {
                        elecItem.setJoules(joules + 100000.0, this.stack);
                    }
                    if (!MuseItemUtils.isSameItem(itemCost, ItemComponent.hvcapacitor)) continue;
                    elecItem.setJoules(joules + 750000.0, this.stack);
                }
                List slotsToUpdate = new ArrayList<Integer>();
                if (!playerEntity.cd.d) {
                    slotsToUpdate = MuseItemUtils.deleteFromInventory(cost, inventory);
                }
                slotsToUpdate.add(this.itemSlot);
                for (Integer slotiter : slotsToUpdate) {
                    MusePacketInventoryRefresh reply = new MusePacketInventoryRefresh(this.player, slotiter, inventory.a(slotiter.intValue()));
                    PacketDispatcher.sendPacketToPlayer((ef)reply.getPacket250(), (Player)this.player);
                }
            }
        }
    }

    @Override
    public void handleClient(ays player) {
    }
}

