/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.powermodule.modules;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.machinemuse.api.IPowerModule;
import net.machinemuse.api.IPropertyModifier;
import net.machinemuse.powersuits.common.Config;
import net.machinemuse.powersuits.powermodule.PowerModule;
import net.machinemuse.powersuits.powermodule.PropertyModifierFlatAdditive;
import net.machinemuse.powersuits.powermodule.PropertyModifierLinearAdditive;

public abstract class PowerModuleBase
implements IPowerModule {
    protected List installCost;
    protected List validItems;
    protected Map propertyModifiers;
    protected static Map units = new HashMap();
    protected bq defaultTag;
    protected boolean isAllowed;

    public PowerModuleBase(String name, List validItems) {
        this.validItems = validItems;
        this.installCost = new ArrayList();
        this.propertyModifiers = new HashMap();
        this.defaultTag = new bq();
        this.defaultTag.a("Active", true);
        this.isAllowed = Config.getConfig().get("Modules", name, true).getBoolean(true);
    }

    public PowerModuleBase(List validItems) {
        this.validItems = validItems;
        this.installCost = new ArrayList();
        this.propertyModifiers = new HashMap();
        this.defaultTag = new bq();
        this.defaultTag.a("Active", true);
        this.isAllowed = Config.getConfig().get("Modules", this.getName(), true).getBoolean(true);
    }

    @Override
    public List getInstallCost() {
        return this.installCost;
    }

    public PowerModuleBase addInstallCost(ur stack) {
        this.installCost.add(stack);
        return this;
    }

    @Override
    public boolean isValidForItem(ur stack, qx player) {
        return this.validItems.contains(stack.b());
    }

    @Override
    public Map getPropertyModifiers() {
        return this.propertyModifiers;
    }

    @Override
    public double applyPropertyModifiers(bq itemTag, String propertyName, double propertyValue) {
        if (this.propertyModifiers.containsKey(propertyName) && itemTag.b(this.getName())) {
            bq moduleTag = itemTag.l(this.getName());
            for (IPropertyModifier modifier : (List)this.propertyModifiers.get(propertyName)) {
                propertyValue = modifier.applyModifier(moduleTag, propertyValue);
            }
        }
        return propertyValue;
    }

    @Override
    public bq getNewTag() {
        return (bq)this.defaultTag.b();
    }

    @Override
    public boolean isAllowed() {
        return this.isAllowed;
    }

    public PowerModuleBase addTradeoffProperty(String tradeoffName, String propertyName, double multiplier) {
        double propFromConfig = Config.getConfig().get("Properties", this.getName() + "." + propertyName + "." + tradeoffName + ".multiplier", multiplier).getDouble(multiplier);
        return this.addPropertyModifier(propertyName, new PropertyModifierLinearAdditive(tradeoffName, propFromConfig));
    }

    public PowerModuleBase addTradeoffProperty(String tradeoffName, String propertyName, double multiplier, String unit) {
        double propFromConfig = Config.getConfig().get("Properties", this.getName() + "." + propertyName + "." + tradeoffName + ".multiplier", multiplier).getDouble(multiplier);
        units.put(propertyName, unit);
        return this.addPropertyModifier(propertyName, new PropertyModifierLinearAdditive(tradeoffName, propFromConfig));
    }

    public PowerModuleBase addPropertyModifier(String propertyName, IPropertyModifier modifier) {
        List<IPropertyModifier> modifiers;
        if (this.propertyModifiers.containsKey(propertyName)) {
            modifiers = (List)this.propertyModifiers.get(propertyName);
        } else {
            modifiers = new LinkedList();
            this.propertyModifiers.put(propertyName, modifiers);
        }
        modifiers.add(modifier);
        return this;
    }

    public PowerModuleBase addSimpleTradeoff(IPowerModule module, String tradeoffName, String firstPropertyName, String firstUnits, double firstPropertyBase, double firstPropertyMultiplier, String secondPropertyName, String secondUnits, double secondPropertyBase, double secondPropertyMultiplier) {
        this.addBaseProperty(firstPropertyName, firstPropertyBase, firstUnits);
        this.addTradeoffProperty(tradeoffName, firstPropertyName, firstPropertyMultiplier);
        this.addBaseProperty(secondPropertyName, secondPropertyBase, secondUnits);
        this.addTradeoffProperty(tradeoffName, secondPropertyName, secondPropertyMultiplier);
        return this;
    }

    public PowerModuleBase addBaseProperty(String propertyName, double baseVal) {
        double propFromConfig = Config.getConfig().get("Properties", this.getName() + "." + propertyName + ".base", baseVal).getDouble(baseVal);
        return this.addPropertyModifier(propertyName, new PropertyModifierFlatAdditive(propFromConfig));
    }

    public PowerModuleBase addBaseProperty(String propertyName, double baseVal, String unit) {
        double propFromConfig = Config.getConfig().get("Properties", this.getName() + "." + propertyName + ".base", baseVal).getDouble(baseVal);
        units.put(propertyName, unit);
        return this.addPropertyModifier(propertyName, new PropertyModifierFlatAdditive(propFromConfig));
    }

    public boolean equals(PowerModule other) {
        return other != null && other.getName() == this.getName();
    }
}

