/*
 * Decompiled with CFR 0.152.
 */
package gcewing.lighting;

import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.LanguageRegistry;
import gcewing.lighting.BlockFloodlight;
import gcewing.lighting.BlockFloodlightBeam;
import gcewing.lighting.BlockFloodlightCarbide;
import gcewing.lighting.Floodlight;
import gcewing.lighting.GregsLightingBase;
import gcewing.lighting.OrderedProperties;
import gcewing.lighting.TEFloodlightBeam;
import gcewing.lighting.TEFloodlightCarbide;
import gcewing.lighting.TexturedItem;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.Map;
import net.minecraftforge.oredict.ShapedOreRecipe;

@Mod(modid="GregsLighting", name="Greg's Lighting", version="1.7.1")
@NetworkMod(clientSideRequired=true, serverSideRequired=true, versionBounds="[1.7,1.8)")
public class GregsLighting {
    public static final String modName = "GregsLighting";
    public static final String textureDir = "/gcewing/lighting/resources/";
    public static final String textureFile = "/gcewing/lighting/resources/textures.png";
    public static final int guiFloodlightCarbide = 1;
    public static BlockFloodlightCarbide floodlightCarbide;
    public static BlockFloodlight floodlight;
    public static BlockFloodlightBeam floodlightBeam;
    public static up calciumCarbide;
    public static up bonemealAndCharcoal;
    public static up gaslightMantle;
    public static up gasNozzle;
    public static up glowingIngot;
    public static up ic2Filament;
    public static up ic2Bulb;
    static String configName;
    static File cfgfile;
    static OrderedProperties config;
    static Map idToName;
    static int nextBlockID;
    static int nextItemID;
    static boolean autoAssign;
    public static boolean isServer;
    public static GregsLighting mod;
    public static tj itemTab;
    @SidedProxy(clientSide="gcewing.lighting.GregsLightingClient", serverSide="gcewing.lighting.GregsLightingServer")
    public static GregsLightingBase proxy;

    public GregsLighting() {
        mod = this;
    }

    @Mod.Init
    public void init(FMLInitializationEvent fMLInitializationEvent) {
        File file = proxy.getMinecraftDirectory();
        this.load(file);
        proxy.load();
    }

    public void load(File file) {
        NetworkRegistry.instance().registerGuiHandler((Object)this, (IGuiHandler)proxy);
        this.loadConfig(file);
        this.registerBlocks();
        this.registerTileEntities();
        this.registerItems();
        this.addRecipes();
        this.registerIC2();
        this.saveConfig();
    }

    void loadConfig(File file) {
        File file2 = new File(file, "/config/");
        cfgfile = new File(file2, configName);
        config = new OrderedProperties();
        try {
            config.load(new FileInputStream(cfgfile));
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.printf("%s: No existing config file\n", modName);
        }
        catch (IOException iOException) {
            System.out.printf("%s: Failed to read %s\n%s\n", modName, cfgfile.getPath(), iOException);
        }
        GregsLighting.config.extended = false;
        Floodlight.init(config);
    }

    void saveConfig() {
        try {
            if (GregsLighting.config.extended) {
                System.out.printf("%s: Writing config file\n", modName);
                config.store(new FileOutputStream(cfgfile), "GregsLighting Configuration File");
            }
        }
        catch (IOException iOException) {
            System.out.printf("%s: Failed to %s\n%s\n", modName, cfgfile.getPath(), iOException);
        }
    }

    void registerBlocks() {
        floodlightCarbide = new BlockFloodlightCarbide(GregsLighting.getBlockID(1032, "carbideFloodlight"));
        floodlightCarbide.c(1.5f).a(tj.f);
        GregsLighting.addBlock("Carbide Floodlight", (amq)floodlightCarbide);
        floodlightBeam = new BlockFloodlightBeam(GregsLighting.getBlockID(1031, "floodlightBeam"));
        GregsLighting.addBlock("Floodlight Beam", (amq)floodlightBeam);
        floodlight = new BlockFloodlight(GregsLighting.getBlockID(1030, "floodlight"));
        floodlight.c(1.5f).a(tj.f);
        GregsLighting.addBlock("Floodlight", (amq)floodlight);
    }

    void registerTileEntities() {
        GameRegistry.registerTileEntity(TEFloodlightCarbide.class, (String)"gcewing.CarbideFloodlight");
        GameRegistry.registerTileEntity(TEFloodlightBeam.class, (String)"gcewing.FloodlightBeam");
    }

    void registerItems() {
        calciumCarbide = GregsLighting.addItem("Calcium Carbide", GregsLighting.newItemI(10300, "calciumCarbide", 32));
        bonemealAndCharcoal = GregsLighting.addItem("Bonemeal-Charcoal Mixture", GregsLighting.newItemI(10301, "bonemealAndCharcoal", 33));
        gaslightMantle = GregsLighting.addItem("Gaslight Mantle", GregsLighting.newItemI(10302, "gaslightMantle", 34));
        ic2Bulb = GregsLighting.addItem("IC2 Floodlight Bulb", GregsLighting.newItemI(10303, "glowstoneBulb", 35));
        gasNozzle = GregsLighting.addItem("Gas Nozzle", GregsLighting.newItemI(10304, "gasNozzle", 37));
        glowingIngot = GregsLighting.addItem("Glowing Alloy Ingot", GregsLighting.newItemI(10305, "glowingIngot", 39));
        ic2Filament = GregsLighting.addItem("IC2 Filament Assembly", GregsLighting.newItemI(10306, "ic2FilamentAssembly", 40));
    }

    void addRecipes() {
        GregsLighting.addShapelessRecipe(bonemealAndCharcoal, 1, new ur(up.aW, 1, 15), new ur(up.m, 1, 1));
        if (config.getBoolean("enableSimpleFloodlight", true)) {
            GregsLighting.addRecipe((amq)floodlight, 1, "IrI", "IgI", "GGG", Character.valueOf('I'), up.o, Character.valueOf('r'), up.aC, Character.valueOf('g'), glowingIngot, Character.valueOf('G'), amq.P);
            GregsLighting.addRecipe(glowingIngot, 1, "GGG", "GgG", "GGG", Character.valueOf('G'), amq.bg, Character.valueOf('g'), up.bq);
        }
        GregsLighting.addSmeltingRecipe(calciumCarbide, 1, bonemealAndCharcoal);
        GregsLighting.addRecipe(gasNozzle, 4, "I", "I", Character.valueOf('I'), up.o);
        GregsLighting.addRecipe((amq)floodlightCarbide, 1, "CrC", "CnC", "GGG", Character.valueOf('C'), amq.z, Character.valueOf('r'), up.aC, Character.valueOf('n'), gasNozzle, Character.valueOf('G'), amq.P);
    }

    void registerIC2() {
        if (Loader.isModLoaded((String)"IC2")) {
            System.out.printf("GregsLighting: Linking to IC2\n", new Object[0]);
            try {
                Class<?> clazz = Class.forName("gcewing.lighting.ic2.GregsLightingIC2");
                Method method = clazz.getMethod("init", new Class[0]);
                method.invoke(null, new Object[0]);
            }
            catch (Exception exception) {
                System.out.printf("GregsLighting: %s\n", exception);
            }
        }
    }

    public static void addRecipe(up up2, int n, Object ... objectArray) {
        GameRegistry.addRecipe((ur)new ur(up2, n), (Object[])objectArray);
    }

    public static void addRecipe(amq amq2, int n, Object ... objectArray) {
        GameRegistry.addRecipe((ur)new ur(amq2, n), (Object[])objectArray);
    }

    public static void addOreRecipe(up up2, int n, Object ... objectArray) {
        ShapedOreRecipe shapedOreRecipe = new ShapedOreRecipe(new ur(up2, n), objectArray);
        wn.a().b().add(shapedOreRecipe);
    }

    public static void addShapelessRecipe(up up2, int n, Object ... objectArray) {
        GameRegistry.addShapelessRecipe((ur)new ur(up2, n), (Object[])objectArray);
    }

    public static void addSmeltingRecipe(up up2, int n, up up3) {
        GameRegistry.addSmelting((int)up3.cj, (ur)new ur(up2, n), (float)0.0f);
    }

    public static void addSmeltingRecipe(up up2, int n, amq amq2) {
        GameRegistry.addSmelting((int)amq2.cm, (ur)new ur(up2, n), (float)0.0f);
    }

    public static int getBlockID(int n, String string) {
        if (autoAssign) {
            n = GregsLighting.nextUnusedBlockID();
        }
        return GregsLighting.getBlockOrItemID(n, "block." + string, 0);
    }

    public static int getItemID(int n, String string) {
        if (autoAssign) {
            n = GregsLighting.nextUnusedItemID();
        }
        return GregsLighting.getBlockOrItemID(n, "item." + string, 256);
    }

    public static int getBlockOrItemID(int n, String string, int n2) {
        int n3;
        String string2 = string + ".id";
        if (config.containsKey(string2)) {
            String string3 = (String)config.get(string2);
            n3 = Integer.parseInt(string3);
        } else {
            config.put(string2, Integer.toString(n));
            n3 = n;
        }
        idToName.put(n2 + n3, string);
        return n3;
    }

    public static up newItem(int n, String string) {
        return GregsLighting.customItem(GregsLighting.getItemID(n, string));
    }

    public static up newItemI(int n, String string, int n2) {
        return GregsLighting.customItem(GregsLighting.getItemID(n, string)).c(n2);
    }

    public static up newItemSI(int n, String string, int n2, int n3) {
        return GregsLighting.customItem(GregsLighting.getItemID(n, string)).d(n2).c(n3);
    }

    public static up customItem(int n) {
        return new TexturedItem(n);
    }

    public static amq addBlock(String string, amq amq2) {
        amq2.b("gcewing." + (String)idToName.get(amq2.cm));
        GameRegistry.registerBlock((amq)amq2);
        LanguageRegistry.addName((Object)amq2, (String)string);
        return amq2;
    }

    public static up addItem(String string, up up2) {
        up2.b("gcewing." + (String)idToName.get(up2.cj));
        LanguageRegistry.addName((Object)up2, (String)string);
        up2.a(itemTab);
        return up2;
    }

    public boolean shiftKeyDown() {
        return false;
    }

    static int nextUnusedBlockID() {
        while (nextBlockID < 4096) {
            if (amq.p[nextBlockID] == null) {
                return nextBlockID;
            }
            ++nextBlockID;
        }
        throw new RuntimeException("GregsLighting: Out of block IDs");
    }

    static int nextUnusedItemID() {
        while (nextItemID < 32768) {
            if (up.e[nextItemID + 256] == null) {
                return nextItemID;
            }
            ++nextItemID;
        }
        throw new RuntimeException("GregsLighting: Out of item IDs");
    }

    public static void openGuiFloodlightCarbide(yc yc2, int n, int n2, int n3, qx qx2) {
        qx2.openGui((Object)mod, 1, yc2, n, n2, n3);
    }

    public static boolean explodeMachineAt(yc yc2, int n, int n2, int n3) {
        try {
            Class<?> clazz = Class.forName("ic2.common.IC2");
            clazz.getMethod("explodeMachineAt", yc.class, Integer.TYPE, Integer.TYPE, Integer.TYPE).invoke(null, yc2, n, n2, n3);
            return true;
        }
        catch (Exception exception) {
            System.out.printf("GregsLighting.explodeMachineAt: %s\n", exception);
            return false;
        }
    }

    static {
        configName = "GregsLighting.cfg";
        idToName = new Hashtable();
        nextBlockID = 1;
        nextItemID = 1;
        autoAssign = true;
        itemTab = tj.f;
    }
}

