/*
 * Decompiled with CFR 0.152.
 */
package gcewing.lighting;

import gcewing.lighting.Matrix3;
import gcewing.lighting.Vector3;

public class Trans3 {
    public static Trans3 ident = new Trans3(Vector3.zero, Matrix3.ident, 1.0);
    public Vector3 offset;
    public Matrix3 rotation;
    public double scaling;

    Trans3(Vector3 vector3, Matrix3 matrix3, double d) {
        this.offset = vector3;
        this.rotation = matrix3;
        this.scaling = d;
    }

    Trans3(double d, double d2, double d3) {
        this(new Vector3(d, d2, d3), Matrix3.ident, 1.0);
    }

    public Trans3 translate(double d, double d2, double d3) {
        return new Trans3(this.offset.add(this.rotation.mul(d * this.scaling, d2 * this.scaling, d3 * this.scaling)), this.rotation, this.scaling);
    }

    public Trans3 rotate(Matrix3 matrix3) {
        return new Trans3(this.offset, this.rotation.mul(matrix3), this.scaling);
    }

    public Trans3 scale(double d) {
        return new Trans3(this.offset, this.rotation, this.scaling * d);
    }

    public Trans3 side(int n) {
        return this.rotate(Matrix3.sideRotations[n]);
    }

    public Trans3 turn(int n) {
        return this.rotate(Matrix3.turnRotations[n]);
    }

    public Trans3 t(Trans3 trans3) {
        return new Trans3(this.offset.add(this.rotation.mul(trans3.offset).mul(this.scaling)), this.rotation.mul(trans3.rotation), this.scaling * trans3.scaling);
    }

    public Vector3 p(double d, double d2, double d3) {
        return this.p(new Vector3(d, d2, d3));
    }

    public Vector3 p(Vector3 vector3) {
        return this.offset.add(this.rotation.mul(vector3.mul(this.scaling)));
    }

    public Vector3 ip(double d, double d2, double d3) {
        return this.ip(new Vector3(d, d2, d3));
    }

    public Vector3 ip(Vector3 vector3) {
        return this.rotation.imul(vector3.sub(this.offset)).mul(1.0 / this.scaling);
    }

    public Vector3 v(double d, double d2, double d3) {
        return this.v(new Vector3(d, d2, d3));
    }

    public Vector3 v(Vector3 vector3) {
        return this.rotation.mul(vector3.mul(this.scaling));
    }

    public Vector3 iv(Vector3 vector3) {
        return this.rotation.imul(vector3).mul(1.0 / this.scaling);
    }
}

