/*
 * Decompiled with CFR 0.152.
 */
package agaricus.mods.oredupefix;

import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.registry.GameData;
import cpw.mods.fml.common.registry.ItemData;
import cpw.mods.fml.relauncher.ReflectionHelper;
import ic2.api.Ic2Recipes;
import ic2.core.AdvRecipe;
import ic2.core.AdvShapelessRecipe;
import ic2.core.item.ItemScrapbox;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import net.minecraftforge.common.ChestGenHooks;
import net.minecraftforge.common.ConfigCategory;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.Property;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

@Mod(modid="OreDupeFix", name="OreDupeFix", version="2.0-1.4.7")
@NetworkMod(clientSideRequired=false, serverSideRequired=false)
public class OreDupeFix {
    public static HashMap<String, String> oreName2PreferredMod;
    public static HashMap<String, ur> oreName2PreferredItem;
    private static boolean shouldDumpOreDict;
    private static boolean verbose;
    private static boolean replaceCrafting;
    private static boolean replaceFurnace;
    private static boolean replaceFurnaceInsensitive;
    private static boolean replaceDungeonLoot;
    private static boolean replaceIC2Compressor;
    private static boolean replaceIC2Extractor;
    private static boolean replaceIC2Macerator;
    private static boolean replaceIC2Scrapbox;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Mod.PreInit
    public static void preInit(FMLPreInitializationEvent event) {
        oreName2PreferredMod = new HashMap();
        Configuration cfg = new Configuration(event.getSuggestedConfigurationFile());
        FMLLog.log((Level)Level.FINE, (String)"OreDupeFix loading config", (Object[])new Object[0]);
        try {
            cfg.load();
            if (cfg.categories.size() == 0) {
                OreDupeFix.loadDefaults(cfg);
            }
            ConfigCategory category = cfg.getCategory("PreferredOres");
            for (Map.Entry entry : category.entrySet()) {
                String name = (String)entry.getKey();
                Property property = (Property)entry.getValue();
                if (property.value.length() == 0) continue;
                oreName2PreferredMod.put(name, property.value);
            }
            shouldDumpOreDict = cfg.get("general", "dumpOreDict", true).getBoolean(true);
            verbose = cfg.get("general", "verbose", true).getBoolean(true);
            replaceCrafting = cfg.get("general", "replaceCrafting", true).getBoolean(true);
            replaceFurnace = cfg.get("general", "replaceFurnace", true).getBoolean(true);
            replaceFurnaceInsensitive = cfg.get("general", "replaceFurnaceInsensitive", true).getBoolean(true);
            replaceDungeonLoot = cfg.get("general", "replaceDungeonLoot", true).getBoolean(true);
            replaceIC2Compressor = cfg.get("general", "replaceIC2Compressor", true).getBoolean(true);
            replaceIC2Extractor = cfg.get("general", "replaceIC2Extractor", true).getBoolean(true);
            replaceIC2Macerator = cfg.get("general", "replaceIC2Macerator", true).getBoolean(true);
            replaceIC2Scrapbox = cfg.get("general", "replaceIC2Scrapbox", true).getBoolean(true);
        }
        catch (Exception e) {
            FMLLog.log((Level)Level.SEVERE, (Throwable)e, (String)"OreDupeFix had a problem loading it's configuration", (Object[])new Object[0]);
        }
        finally {
            cfg.save();
        }
    }

    @Mod.PostInit
    public static void postInit(FMLPostInitializationEvent event) {
        OreDupeFix.log("Loading OreDupeFix...");
        if (shouldDumpOreDict) {
            OreDupeFix.dumpOreDict();
        }
        OreDupeFix.loadPreferredOres();
        if (replaceCrafting) {
            OreDupeFix.replaceCraftingRecipes();
        }
        if (replaceFurnace) {
            OreDupeFix.replaceFurnaceRecipes();
        }
        if (replaceFurnaceInsensitive) {
            OreDupeFix.replaceFurnaceRecipesInsensitive();
        }
        if (replaceDungeonLoot) {
            OreDupeFix.replaceDungeonLoot();
        }
        try {
            if (replaceIC2Compressor) {
                OreDupeFix.replaceIC2MachineRecipes(Ic2Recipes.getCompressorRecipes());
            }
            if (replaceIC2Extractor) {
                OreDupeFix.replaceIC2MachineRecipes(Ic2Recipes.getExtractorRecipes());
            }
            if (replaceIC2Macerator) {
                OreDupeFix.replaceIC2MachineRecipes(Ic2Recipes.getMaceratorRecipes());
            }
            if (replaceIC2Scrapbox) {
                OreDupeFix.replaceIC2ScrapboxDrops();
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            FMLLog.log((Level)Level.WARNING, (String)("Failed to replace IC2 machine recipes: " + t.getLocalizedMessage() + ", fix this (update?) or turn off replaceIC2* in config"), (Object[])new Object[0]);
        }
    }

    public static void log(String message) {
        if (verbose) {
            System.out.println(message);
        }
    }

    public static void loadDefaults(Configuration cfg) {
        ConfigCategory category = cfg.getCategory("PreferredOres");
        FMLLog.log((Level)Level.FINE, (String)"OreDupeFix initializing defaults", (Object[])new Object[0]);
        HashMap<String, String> m = new HashMap<String, String>();
        Map idMap = (Map)ReflectionHelper.getPrivateValue(GameData.class, null, (String[])new String[]{"idMap"});
        List<String> oreNames = Arrays.asList(OreDictionary.getOreNames());
        Collections.sort(oreNames);
        for (String string : oreNames) {
            m.put(string, "");
        }
        m.put("ingotCopper", "RedPowerBase");
        m.put("ingotTin", "RedPowerBase");
        m.put("ingotBronze", "IC2");
        m.put("ingotSilver", "RedPowerBase");
        m.put("ingotLead", "ThermalExpansion");
        m.put("dustBronze", "ThermalExpansion");
        m.put("dustIron", "ThermalExpansion");
        m.put("dustTin", "ThermalExpansion");
        m.put("dustSilver", "ThermalExpansion");
        m.put("dustCopper", "ThermalExpansion");
        m.put("dustGold", "ThermalExpansion");
        m.put("dustObsidian", "ThermalExpansion");
        m.put("nuggetTin", "ThermalExpansion");
        m.put("nuggetCopper", "Thaumcraft");
        m.put("nuggetIron", "Thaumcraft");
        m.put("nuggetSilver", "Thaumcraft");
        m.put("nuggetTin", "Thaumcraft");
        m.put("oreCopper", "IC2");
        m.put("oreSilver", "ThermalExpansion");
        m.put("oreTin", "IC2");
        for (Map.Entry entry : m.entrySet()) {
            String oreName = (String)entry.getKey();
            String modID = (String)entry.getValue();
            category.put(oreName, new Property(oreName, modID, Property.Type.STRING));
        }
    }

    public static void loadPreferredOres() {
        oreName2PreferredItem = new HashMap();
        Map idMap = (Map)ReflectionHelper.getPrivateValue(GameData.class, null, (String[])new String[]{"idMap"});
        for (Map.Entry<String, String> entry : oreName2PreferredMod.entrySet()) {
            String oreName = entry.getKey();
            String preferredModID = entry.getValue();
            ArrayList oreItems = OreDictionary.getOres((String)oreName);
            boolean found = false;
            for (ur oreItem : oreItems) {
                ItemData itemData = (ItemData)idMap.get(oreItem.c);
                String modID = itemData.getModId();
                if (!preferredModID.equals(modID)) continue;
                oreName2PreferredItem.put(oreName, oreItem);
                found = true;
                break;
            }
            if (found) continue;
            OreDupeFix.log("No mod '" + preferredModID + "' found for ore '" + oreName + "'! Skipping");
        }
        for (String oreName : oreName2PreferredMod.keySet()) {
            String modID = oreName2PreferredMod.get(oreName);
            ur itemStack = oreName2PreferredItem.get(oreName);
            if (itemStack == null) continue;
            System.out.println("Preferring ore name " + oreName + " from mod " + modID + " = " + itemStack.c + ":" + itemStack.j());
        }
    }

    public static void dumpOreDict() {
        Map idMap = (Map)ReflectionHelper.getPrivateValue(GameData.class, null, (String[])new String[]{"idMap"});
        List<String> oreNames = Arrays.asList(OreDictionary.getOreNames());
        Collections.sort(oreNames);
        for (String oreName : oreNames) {
            System.out.print("ore: " + oreName + ": ");
            ArrayList oreItems = OreDictionary.getOres((String)oreName);
            for (ur oreItem : oreItems) {
                ItemData itemData = (ItemData)idMap.get(oreItem.c);
                String modID = itemData.getModId();
                System.out.print(oreItem.c + ":" + oreItem.j() + "=" + modID + ", ");
            }
            System.out.println("");
        }
    }

    public static ur getPreferredOre(ur output) {
        int oreID = OreDictionary.getOreID((ur)output);
        if (oreID == -1) {
            return null;
        }
        String oreName = OreDictionary.getOreName((int)oreID);
        ur newOutputType = oreName2PreferredItem.get(oreName);
        if (newOutputType == null) {
            return null;
        }
        ur newOutput = new ur(newOutputType.c, output.a, newOutputType.j());
        return newOutput;
    }

    public static void replaceCraftingRecipes() {
        List recipeList = wn.a().b();
        for (Object recipe : recipeList) {
            ur newOutput;
            wp iRecipe;
            ur output;
            if (!(recipe instanceof wp) || (output = (iRecipe = (wp)recipe).b()) == null || (newOutput = OreDupeFix.getPreferredOre(output)) == null) continue;
            OreDupeFix.log("Modifying recipe " + iRecipe + " replacing " + output.c + ":" + output.j() + " -> " + newOutput.c + ":" + newOutput.j());
            OreDupeFix.setCraftingRecipeOutput(iRecipe, newOutput);
        }
    }

    public static void setCraftingRecipeOutput(wp iRecipe, ur output) {
        if (iRecipe instanceof wq) {
            ReflectionHelper.setPrivateValue(wq.class, (Object)((wq)iRecipe), (Object)output, (String[])new String[]{"e"});
        } else if (iRecipe instanceof wr) {
            ReflectionHelper.setPrivateValue(wr.class, (Object)((wr)iRecipe), (Object)output, (String[])new String[]{"a"});
        } else if (iRecipe instanceof ShapelessOreRecipe) {
            ReflectionHelper.setPrivateValue(ShapelessOreRecipe.class, (Object)((ShapelessOreRecipe)iRecipe), (Object)output, (String[])new String[]{"output"});
        } else if (iRecipe instanceof ShapedOreRecipe) {
            ReflectionHelper.setPrivateValue(ShapedOreRecipe.class, (Object)((ShapedOreRecipe)iRecipe), (Object)output, (String[])new String[]{"output"});
        } else if (iRecipe instanceof AdvRecipe) {
            ((AdvRecipe)iRecipe).output = output;
        } else if (iRecipe instanceof AdvShapelessRecipe) {
            ((AdvShapelessRecipe)iRecipe).output = output;
        }
    }

    public static void replaceFurnaceRecipes() {
        Map metaSmeltingList = wj.a().getMetaSmeltingList();
        for (Map.Entry entry : metaSmeltingList.entrySet()) {
            List inputItemPlusData = (List)entry.getKey();
            ur output = (ur)entry.getValue();
            ur newOutput = OreDupeFix.getPreferredOre(output);
            if (newOutput == null) continue;
            entry.setValue(newOutput);
        }
    }

    public static void replaceFurnaceRecipesInsensitive() {
        Map smeltingList = wj.a().b();
        for (Map.Entry entry : smeltingList.entrySet()) {
            int itemID = (Integer)entry.getKey();
            ur output = (ur)entry.getValue();
            ur newOutput = OreDupeFix.getPreferredOre(output);
            if (newOutput == null) continue;
            entry.setValue(newOutput);
        }
    }

    public static void replaceDungeonLoot() {
        try {
            HashMap chestInfo = (HashMap)ReflectionHelper.getPrivateValue(ChestGenHooks.class, null, (String[])new String[]{"chestInfo"});
            for (Map.Entry entry : chestInfo.entrySet()) {
                ChestGenHooks chestGenHooks = (ChestGenHooks)entry.getValue();
                ArrayList contents = (ArrayList)ReflectionHelper.getPrivateValue(ChestGenHooks.class, (Object)chestGenHooks, (String[])new String[]{"contents"});
                for (kw weightedRandomChestContent : contents) {
                    ur output = weightedRandomChestContent.b;
                    ur newOutput = OreDupeFix.getPreferredOre(output);
                    if (newOutput == null) continue;
                    OreDupeFix.log("Modifying dungeon loot in " + (String)entry.getKey() + ", replacing " + output.c + ":" + output.j() + " -> " + newOutput.c + ":" + newOutput.j());
                    weightedRandomChestContent.b = newOutput;
                }
            }
        }
        catch (Throwable t) {
            System.out.println("Failed to replace dungeon loot: " + t);
        }
    }

    public static void replaceIC2MachineRecipes(List<Map.Entry<ur, ur>> machineRecipes) {
        for (int i = 0; i < machineRecipes.size(); ++i) {
            Map.Entry<ur, ur> entry = machineRecipes.get(i);
            ur input = entry.getKey();
            ur output = entry.getValue();
            ur newOutput = OreDupeFix.getPreferredOre(output);
            if (newOutput == null) continue;
            entry.setValue(newOutput);
        }
    }

    public static void replaceIC2ScrapboxDrops() {
        try {
            List dropList = ItemScrapbox.dropList;
            Class<?> dropClass = ItemScrapbox.class.getDeclaredClasses()[0];
            for (int i = 0; i < dropList.size(); ++i) {
                Object drop = dropList.get(i);
                ur output = (ur)ReflectionHelper.getPrivateValue(dropClass, drop, (int)0);
                ur newOutput = OreDupeFix.getPreferredOre(output);
                if (newOutput == null) continue;
                OreDupeFix.log("Modifying IC2 scrapbox drop, replacing " + output.c + ":" + output.j() + " -> " + newOutput.c + ":" + newOutput.j());
                ReflectionHelper.setPrivateValue(dropClass, drop, (Object)newOutput, (int)0);
            }
        }
        catch (Throwable t) {
            System.out.println("Failed to replace IC2 scrapbox drops: " + t);
        }
    }
}

