/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.core;

import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import cpw.mods.fml.common.DummyModContainer;
import cpw.mods.fml.common.IScheduledTickHandler;
import cpw.mods.fml.common.LoadController;
import cpw.mods.fml.common.ModMetadata;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.registry.TickRegistry;
import cpw.mods.fml.relauncher.Side;
import java.io.File;
import java.util.Arrays;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.Property;
import net.minecraftforge.event.ForgeSubscribe;
import net.minecraftforge.oredict.OreDictionary;
import powercrystals.core.oredict.OreDictTracker;
import powercrystals.core.updater.IUpdateableMod;
import powercrystals.core.updater.UpdateManager;

public class CoreCore
extends DummyModContainer
implements IUpdateableMod {
    public static final String version = "1.4.6R1.0.3";
    public static final String modId = "PowerCrystalsCore";
    public static final String modName = "PowerCrystals Core";
    public static Property doUpdateCheck;
    public static CoreCore instance;

    public CoreCore() {
        super(new ModMetadata());
        ModMetadata md = super.getMetadata();
        md.modId = modId;
        md.name = modName;
        md.version = version.substring(version.indexOf(82) + 1);
        md.authorList = Arrays.asList("PowerCrystals");
        md.url = "http://www.minecraftforum.net/topic/1629898-";
        md.description = "Core functionality for Power Crystals' mods.";
    }

    public boolean registerBus(EventBus bus, LoadController controller) {
        bus.register((Object)this);
        return true;
    }

    @Subscribe
    public void preInit(FMLPreInitializationEvent evt) {
        this.loadConfig(evt.getSuggestedConfigurationFile());
    }

    @Subscribe
    public void init(FMLInitializationEvent evt) {
        for (String s : OreDictionary.getOreNames()) {
            for (ur stack : OreDictionary.getOres((String)s)) {
                OreDictTracker.registerOreDictEntry(stack, s);
            }
        }
        instance = this;
        MinecraftForge.EVENT_BUS.register((Object)instance);
    }

    @ForgeSubscribe
    public void registerOreEvent(OreDictionary.OreRegisterEvent event) {
        OreDictTracker.registerOreDictEntry(event.Ore, event.Name);
    }

    @Subscribe
    public void load(FMLInitializationEvent evt) {
        TickRegistry.registerScheduledTickHandler((IScheduledTickHandler)new UpdateManager(this), (Side)Side.CLIENT);
    }

    private void loadConfig(File f) {
        Configuration c = new Configuration(f);
        c.load();
        doUpdateCheck = c.get("general", "EnableUpdateCheck", true);
        CoreCore.doUpdateCheck.comment = "Set to false to disable update checks for all Power Crystals' mods.";
        c.save();
    }

    @Override
    public String getModId() {
        return modId;
    }

    @Override
    public String getModName() {
        return modName;
    }

    @Override
    public String getModFolder() {
        return modId;
    }

    @Override
    public String getModVersion() {
        return version;
    }
}

