/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.core.position;

import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.common.ForgeDirection;
import powercrystals.core.position.IRotateableTile;

public class BlockPosition {
    public int x;
    public int y;
    public int z;
    public ForgeDirection orientation;

    public BlockPosition(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.orientation = ForgeDirection.UNKNOWN;
    }

    public BlockPosition(int x, int y, int z, ForgeDirection corientation) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.orientation = corientation;
    }

    public BlockPosition(BlockPosition p) {
        this.x = p.x;
        this.y = p.y;
        this.z = p.z;
        this.orientation = p.orientation;
    }

    public BlockPosition(bq nbttagcompound) {
        this.x = nbttagcompound.e("i");
        this.y = nbttagcompound.e("j");
        this.z = nbttagcompound.e("k");
        this.orientation = ForgeDirection.UNKNOWN;
    }

    public BlockPosition(any tile) {
        this.x = tile.l;
        this.y = tile.m;
        this.z = tile.n;
        this.orientation = ForgeDirection.UNKNOWN;
    }

    public static BlockPosition fromFactoryTile(IRotateableTile te) {
        BlockPosition bp = new BlockPosition((any)te);
        bp.orientation = te.getDirectionFacing();
        return bp;
    }

    public BlockPosition copy() {
        return new BlockPosition(this.x, this.y, this.z, this.orientation);
    }

    public void moveRight(int step) {
        switch (this.orientation) {
            case SOUTH: {
                this.x -= step;
                break;
            }
            case NORTH: {
                this.x += step;
                break;
            }
            case EAST: {
                this.z += step;
                break;
            }
            case WEST: {
                this.z -= step;
                break;
            }
        }
    }

    public void moveLeft(int step) {
        this.moveRight(-step);
    }

    public void moveForwards(int step) {
        switch (this.orientation) {
            case UP: {
                this.y += step;
                break;
            }
            case DOWN: {
                this.y -= step;
                break;
            }
            case SOUTH: {
                this.z += step;
                break;
            }
            case NORTH: {
                this.z -= step;
                break;
            }
            case EAST: {
                this.x += step;
                break;
            }
            case WEST: {
                this.x -= step;
                break;
            }
        }
    }

    public void moveBackwards(int step) {
        this.moveForwards(-step);
    }

    public void moveUp(int step) {
        switch (this.orientation) {
            case SOUTH: 
            case NORTH: 
            case EAST: 
            case WEST: {
                this.y += step;
                break;
            }
        }
    }

    public void moveDown(int step) {
        this.moveUp(-step);
    }

    public void writeToNBT(bq nbttagcompound) {
        nbttagcompound.a("i", (double)this.x);
        nbttagcompound.a("j", (double)this.y);
        nbttagcompound.a("k", (double)this.z);
    }

    public String toString() {
        if (this.orientation == null) {
            return "{" + this.x + ", " + this.y + ", " + this.z + "}";
        }
        return "{" + this.x + ", " + this.y + ", " + this.z + ";" + this.orientation.toString() + "}";
    }

    public BlockPosition min(BlockPosition p) {
        return new BlockPosition(p.x > this.x ? this.x : p.x, p.y > this.y ? this.y : p.y, p.z > this.z ? this.z : p.z);
    }

    public BlockPosition max(BlockPosition p) {
        return new BlockPosition(p.x < this.x ? this.x : p.x, p.y < this.y ? this.y : p.y, p.z < this.z ? this.z : p.z);
    }

    public List getAdjacent(boolean includeVertical) {
        ArrayList<BlockPosition> a = new ArrayList<BlockPosition>();
        a.add(new BlockPosition(this.x + 1, this.y, this.z, ForgeDirection.EAST));
        a.add(new BlockPosition(this.x - 1, this.y, this.z, ForgeDirection.WEST));
        a.add(new BlockPosition(this.x, this.y, this.z + 1, ForgeDirection.SOUTH));
        a.add(new BlockPosition(this.x, this.y, this.z - 1, ForgeDirection.NORTH));
        if (includeVertical) {
            a.add(new BlockPosition(this.x, this.y + 1, this.z, ForgeDirection.UP));
            a.add(new BlockPosition(this.x, this.y - 1, this.z, ForgeDirection.DOWN));
        }
        return a;
    }

    public static any getAdjacentTileEntity(any start, ForgeDirection direction) {
        BlockPosition p = new BlockPosition(start);
        p.orientation = direction;
        p.moveForwards(1);
        return start.k.q(p.x, p.y, p.z);
    }
}

