/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.core.render;

import cpw.mods.fml.client.FMLTextureFX;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class TextureLiquidStillFX
extends FMLTextureFX {
    protected float[] red;
    protected float[] green;
    protected float[] blue;
    protected float[] alpha;
    private int rMin;
    private int rMax;
    private int gMin;
    private int gMax;
    private int bMin;
    private int bMax;
    private String _texture;

    public TextureLiquidStillFX(int textureIndex, String texture, int rMin, int rMax, int gMin, int gMax, int bMin, int bMax) {
        super(textureIndex);
        this._texture = texture;
        this.rMin = rMin;
        this.rMax = rMax;
        this.gMin = gMin;
        this.gMax = gMax;
        this.bMin = bMin;
        this.bMax = bMax;
    }

    public void setup() {
        this.red = new float[this.tileSizeSquare];
        this.green = new float[this.tileSizeSquare];
        this.blue = new float[this.tileSizeSquare];
        this.alpha = new float[this.tileSizeSquare];
        super.setup();
    }

    public void a(bba renderengine) {
        GL11.glBindTexture((int)3553, (int)renderengine.b(this._texture));
    }

    public void a() {
        for (int x = 0; x < this.tileSizeBase; ++x) {
            for (int y = 0; y < this.tileSizeBase; ++y) {
                float f = 0.0f;
                for (int j1 = x - 1; j1 <= 2; ++j1) {
                    int k1 = j1 & this.tileSizeMask;
                    int i2 = y & this.tileSizeMask;
                    f += this.red[k1 + i2 * this.tileSizeBase];
                }
                this.green[x + y * this.tileSizeBase] = f / 3.3f + this.blue[x + y * this.tileSizeBase] * 0.8f;
            }
        }
        for (int j = 0; j < this.tileSizeBase; ++j) {
            for (int l = 0; l < this.tileSizeBase; ++l) {
                int n = j + l * this.tileSizeBase;
                this.blue[n] = this.blue[n] + this.alpha[j + l * this.tileSizeBase] * 0.05f;
                if (this.blue[j + l * this.tileSizeBase] < 0.0f) {
                    this.blue[j + l * this.tileSizeBase] = 0.0f;
                }
                int n2 = j + l * this.tileSizeBase;
                this.alpha[n2] = this.alpha[n2] - 0.1f;
                if (!(Math.random() < 0.05)) continue;
                this.alpha[j + l * this.tileSizeBase] = 0.5f;
            }
        }
        float[] af = this.green;
        this.green = this.red;
        this.red = af;
        for (int i1 = 0; i1 < this.tileSizeSquare; ++i1) {
            float f1 = this.red[i1];
            if (f1 > 1.0f) {
                f1 = 1.0f;
            }
            if (f1 < 0.0f) {
                f1 = 0.0f;
            }
            float f2 = f1 * f1;
            int r = (int)((float)this.rMin + f2 * (float)(this.rMax - this.rMin));
            int g = (int)((float)this.gMin + f2 * (float)(this.gMax - this.rMin));
            int b = (int)((float)this.bMin + f2 * (float)(this.bMax - this.rMin));
            if (this.f) {
                int i3 = (r * 30 + g * 59 + b * 11) / 100;
                int j3 = (r * 30 + g * 70) / 100;
                int k3 = (r * 30 + b * 70) / 100;
                r = i3;
                g = j3;
                b = k3;
            }
            this.d[i1 * 4 + 0] = (byte)r;
            this.d[i1 * 4 + 1] = (byte)g;
            this.d[i1 * 4 + 2] = (byte)b;
            this.d[i1 * 4 + 3] = -1;
        }
    }
}

