/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.core.util;

import buildcraft.api.transport.IPipeEntry;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.ISidedInventory;
import powercrystals.core.position.BlockPosition;

public class UtilInventory {
    public static int addToInventory(la targetInventory, ForgeDirection toSide, ur stackToAdd) {
        int slotIndex;
        int amountLeftToAdd = stackToAdd.a;
        int stackSizeLimit = Math.min(targetInventory.c(), stackToAdd.d());
        while (amountLeftToAdd > 0 && (slotIndex = UtilInventory.getAvailableSlot(targetInventory, toSide, stackToAdd)) >= 0) {
            ur targetStack = targetInventory.a(slotIndex);
            if (targetStack == null) {
                if (stackToAdd.a <= stackSizeLimit) {
                    ur s = stackToAdd.l();
                    s.a = amountLeftToAdd;
                    targetInventory.a(slotIndex, s);
                    amountLeftToAdd = 0;
                    break;
                }
                ur s = stackToAdd.l();
                s.a = stackSizeLimit;
                targetInventory.a(slotIndex, stackToAdd.l());
                amountLeftToAdd -= s.a;
                continue;
            }
            int amountToAdd = Math.min(amountLeftToAdd, stackSizeLimit - targetStack.a);
            targetStack.a += amountToAdd;
            amountLeftToAdd -= amountToAdd;
        }
        return amountLeftToAdd;
    }

    private static int getAvailableSlot(la inventory, ForgeDirection toSide, ur stack) {
        int stackSizeLimit = Math.min(inventory.c(), stack.d());
        int invStart = 0;
        int invEnd = inventory.k_();
        if (toSide != ForgeDirection.UNKNOWN && inventory instanceof ISidedInventory) {
            invStart = ((ISidedInventory)inventory).getStartInventorySide(toSide.getOpposite());
            invEnd = invStart + ((ISidedInventory)inventory).getSizeInventorySide(toSide.getOpposite());
        }
        for (int i = invStart; i < invEnd; ++i) {
            ur targetStack = inventory.a(i);
            if (targetStack == null) {
                return i;
            }
            if (targetStack.c != stack.c || targetStack.j() != stack.j() || targetStack.a >= stackSizeLimit) continue;
            return i;
        }
        return -1;
    }

    public static List findPipes(yc world, int x, int y, int z) {
        LinkedList<ForgeDirection> pipes = new LinkedList<ForgeDirection>();
        BlockPosition ourpos = new BlockPosition(x, y, z);
        for (ForgeDirection o : ForgeDirection.values()) {
            BlockPosition bp = new BlockPosition(ourpos);
            bp.orientation = o;
            bp.moveForwards(1);
            any te = world.q(bp.x, bp.y, bp.z);
            if (!(te instanceof IPipeEntry)) continue;
            pipes.add(o);
        }
        return pipes;
    }

    public static Map findChests(yc world, int x, int y, int z) {
        HashMap<ForgeDirection, la> chests = new HashMap<ForgeDirection, la>();
        for (ForgeDirection d : ForgeDirection.values()) {
            if (d == ForgeDirection.UNKNOWN) continue;
            BlockPosition bp = new BlockPosition(x, y, z);
            bp.orientation = d;
            bp.moveForwards(1);
            any te = world.q(bp.x, bp.y, bp.z);
            if (te == null || !(te instanceof la)) continue;
            chests.put(d, UtilInventory.checkForDoubleChest(world, te, bp));
        }
        return chests;
    }

    private static la checkForDoubleChest(yc world, any te, BlockPosition chestloc) {
        if (world.a(chestloc.x, chestloc.y, chestloc.z) == amq.ax.cm) {
            for (BlockPosition bp : chestloc.getAdjacent(false)) {
                if (world.a(bp.x, bp.y, bp.z) != amq.ax.cm) continue;
                return new kz("Large Chest", (la)te, (la)world.q(bp.x, bp.y, bp.z));
            }
        }
        return (la)te;
    }

    public static int findFirstStack(la inv, int itemId, int itemDamage) {
        for (int i = 0; i < inv.k_(); ++i) {
            ur s = inv.a(i);
            if (s == null || s.c != itemId || s.j() != itemDamage) continue;
            return i;
        }
        return -1;
    }
}

