/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.forge;

import codechicken.nei.forge.DefaultSlotClickHandler;
import codechicken.nei.forge.IContainerDrawHandler;
import codechicken.nei.forge.IContainerInputHandler;
import codechicken.nei.forge.IContainerObjectHandler;
import codechicken.nei.forge.IContainerSlotClickHandler;
import codechicken.nei.forge.IContainerTooltipHandler;
import java.awt.Point;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.Minecraft;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class GuiContainerManager {
    public avf window;
    public static bce drawItems = new bce();
    public static final LinkedList tooltipHandlers = new LinkedList();
    public static final LinkedList inputHandlers = new LinkedList();
    public static final LinkedList drawHandlers = new LinkedList();
    public static final LinkedList objectHandlers = new LinkedList();
    public static final LinkedList slotClickHandlers = new LinkedList();

    static {
        GuiContainerManager.addSlotClickHandler(new DefaultSlotClickHandler());
    }

    public GuiContainerManager(avf screen) {
        this.window = screen;
    }

    public static void addTooltipHandler(IContainerTooltipHandler handler) {
        tooltipHandlers.add(handler);
    }

    public static void addInputHandler(IContainerInputHandler handler) {
        inputHandlers.add(handler);
    }

    public static void addDrawHandler(IContainerDrawHandler handler) {
        drawHandlers.add(handler);
    }

    public static void addObjectHandler(IContainerObjectHandler handler) {
        objectHandlers.add(handler);
    }

    public static void addSlotClickHandler(IContainerSlotClickHandler handler) {
        slotClickHandlers.addFirst(handler);
    }

    public Point getMousePosition() {
        Minecraft mc = this.window.f;
        aum scaledresolution = new aum(mc.y, mc.c, mc.d);
        int w = scaledresolution.a();
        int h = scaledresolution.b();
        return new Point(Mouse.getX() * w / mc.c, h - Mouse.getY() * h / mc.d - 1);
    }

    public ur getStackMouseOver() {
        sr slot;
        Point mousePos = this.getMousePosition();
        ur item = null;
        for (IContainerObjectHandler objectHandler : objectHandlers) {
            item = objectHandler.getStackUnderMouse(this.window, mousePos.x, mousePos.y);
            if (item == null) continue;
            return item;
        }
        if (!this.objectUnderMouse(mousePos.x, mousePos.y) && (slot = this.window.c(mousePos.x, mousePos.y)) != null) {
            item = slot.c();
        }
        return item;
    }

    public int getStringWidth(String s) {
        if (s == null || s.equals("")) {
            return 0;
        }
        return GuiContainerManager.getStringWidthNoColours(this.window.l, s);
    }

    public static int getStringWidthNoColours(atq fontRenderer, String s) {
        int pos;
        while ((pos = s.indexOf(167)) != -1) {
            s = String.valueOf(s.substring(0, pos)) + s.substring(pos + 2);
        }
        return fontRenderer.a(s);
    }

    public static List itemDisplayNameMultiline(ur itemstack, avf gui, boolean includeHandlers) {
        List<String> namelist = null;
        try {
            namelist = itemstack.a((qx)Minecraft.x().g, includeHandlers && Minecraft.x().y.x);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (namelist == null) {
            namelist = new ArrayList<String>();
        }
        if (namelist.size() == 0) {
            namelist.add("Unnamed");
        }
        if (namelist.get(0) == null || ((String)namelist.get(0)).equals("")) {
            namelist.set(0, "Unnamed");
        }
        if (includeHandlers) {
            for (IContainerTooltipHandler handler : tooltipHandlers) {
                namelist = handler.handleItemTooltip(gui, itemstack, namelist);
            }
        }
        namelist.set(0, "\u00a7" + Integer.toHexString(itemstack.u().e) + (String)namelist.get(0));
        int i = 1;
        while (i < namelist.size()) {
            namelist.set(i, "\u00a77" + (String)namelist.get(i));
            ++i;
        }
        return namelist;
    }

    public static String itemDisplayNameShort(ur itemstack) {
        List list = GuiContainerManager.itemDisplayNameMultiline(itemstack, null, false);
        return (String)list.get(0);
    }

    public static String concatenatedDisplayName(ur itemstack, boolean includeHandlers) {
        int pos;
        List list = GuiContainerManager.itemDisplayNameMultiline(itemstack, null, includeHandlers);
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String name : list) {
            if (first) {
                first = false;
            } else {
                sb.append("#");
            }
            sb.append(name);
        }
        String s = sb.toString();
        while ((pos = s.indexOf(167)) != -1) {
            s = String.valueOf(s.substring(0, pos)) + s.substring(pos + 2);
        }
        return s;
    }

    public void drawRect(int x, int y, int w, int h, int colour) {
        this.window.a(x, y, x + w, y + h, colour, colour);
    }

    public void drawGradientRect(int x, int y, int w, int h, int colour1, int colour2) {
        this.window.a(x, y, x + w, y + h, colour1, colour2);
    }

    public void drawTexturedModalRect(int x, int y, int tx, int ty, int w, int h) {
        this.window.b(x, y, tx, ty, w, h);
    }

    public void drawText(int x, int y, String text, int colour, boolean shadow) {
        if (shadow) {
            this.window.l.a(text, x, y, colour);
        } else {
            this.window.l.b(text, x, y, colour);
        }
    }

    public void drawTextCentered(int x, int y, int w, int h, String text, int colour, boolean shadow) {
        this.drawText(x + (w - this.getStringWidth(text)) / 2, y + (h - 8) / 2, text, colour, shadow);
    }

    public void drawTextCentered(String text, int x, int y, int colour, boolean shadow) {
        this.drawText(x - this.getStringWidth(text) / 2, y, text, colour, shadow);
    }

    public void drawText(int x, int y, String text, boolean shadow) {
        this.drawText(x, y, text, -1, shadow);
    }

    public void drawText(int x, int y, String text, int colour) {
        this.drawText(x, y, text, colour, true);
    }

    public void drawTextCentered(int x, int y, int w, int h, String text, int colour) {
        this.drawText(x + (w - this.getStringWidth(text)) / 2, y + (h - 8) / 2, text, colour);
    }

    public void drawTextCentered(String text, int x, int y, int colour) {
        this.drawText(x - this.getStringWidth(text) / 2, y, text, colour);
    }

    public void drawText(int x, int y, String text) {
        this.drawText(x, y, text, -1);
    }

    public void drawTip(int x, int y, String text) {
        ArrayList<String> temp = new ArrayList<String>();
        temp.add(text);
        this.drawMultilineTip(x, y, temp);
    }

    public void drawMultilineTip(int x, int y, List list) {
        GL11.glDisable((int)32826);
        arw.a();
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2929);
        if (list.size() > 0) {
            int maxwidth = 0;
            int line = 0;
            while (line < list.size()) {
                int swidth = GuiContainerManager.getStringWidthNoColours(this.window.l, (String)list.get(line));
                if (swidth > maxwidth) {
                    maxwidth = swidth;
                }
                ++line;
            }
            if (x + maxwidth > this.window.g - 16) {
                x = this.window.g - maxwidth - 16;
            }
            if (y < 16) {
                y = 16;
            }
            int drawx = x - this.window.n + 12;
            int drawy = y - this.window.o - 12;
            int w = maxwidth;
            int h = 8;
            if (list.size() > 1) {
                h += 2 + (list.size() - 1) * 10;
            }
            this.window.j = 300.0f;
            avf.a.f = 300.0f;
            int i4 = -267386864;
            this.drawGradientRect(drawx - 3, drawy - 4, w + 6, 1, i4, i4);
            this.drawGradientRect(drawx - 3, drawy + h + 3, w + 6, 1, i4, i4);
            this.drawGradientRect(drawx - 3, drawy - 3, w + 6, h + 6, i4, i4);
            this.drawGradientRect(drawx - 4, drawy - 3, 1, h + 6, i4, i4);
            this.drawGradientRect(drawx + w + 3, drawy - 3, 1, h + 6, i4, i4);
            int colour1 = 0x505000FF;
            int colour2 = (colour1 & 0xFEFEFE) >> 1 | colour1 & 0xFF000000;
            this.drawGradientRect(drawx - 3, drawy - 2, 1, h + 4, colour1, colour2);
            this.drawGradientRect(drawx + w + 2, drawy - 2, 1, h + 4, colour1, colour2);
            this.drawGradientRect(drawx - 3, drawy - 3, w + 6, 1, colour1, colour1);
            this.drawGradientRect(drawx - 3, drawy + h + 2, w + 6, 1, colour2, colour2);
            int i = 0;
            while (i < list.size()) {
                String s = (String)list.get(i);
                this.window.l.a(s, drawx, drawy, -1);
                if (i == 0) {
                    drawy += 2;
                }
                drawy += 10;
                ++i;
            }
            this.window.j = 0.0f;
            avf.a.f = 0.0f;
        }
    }

    public void drawItem(int i, int j, ur itemstack) {
        GuiContainerManager.drawItem(i, j, itemstack, this.window.l, this.window.f.o);
    }

    public static void drawItem(int i, int j, ur itemstack, atq fontRenderer, bba renderEngine) {
        GuiContainerManager.enable3DRender();
        GuiContainerManager.drawItems.f += 100.0f;
        try {
            drawItems.b(fontRenderer, renderEngine, itemstack, i, j);
            drawItems.c(fontRenderer, renderEngine, itemstack, i, j);
        }
        catch (RuntimeException e) {
            System.err.println("Error while rendering: " + itemstack);
            e.printStackTrace();
            if (baz.a.z) {
                baz.a.a();
            }
            drawItems.a(fontRenderer, renderEngine, new ur(51, 1, 0), i, j);
        }
        GuiContainerManager.drawItems.f -= 100.0f;
        GuiContainerManager.enable2DRender();
        if (baz.a.z) {
            baz.a.a();
        }
    }

    public void setColouredItemRender(boolean enable) {
        GuiContainerManager.drawItems.a = !enable;
    }

    public static void enable3DRender() {
        GL11.glEnable((int)2896);
        GL11.glEnable((int)2929);
    }

    public static void enable2DRender() {
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2929);
    }

    public int getTexture(String s) {
        return this.window.f.o.b(s);
    }

    public void bindTexture(int texture) {
        this.window.f.o.b(texture);
    }

    public void bindTextureByName(String s) {
        this.bindTexture(this.getTexture(s));
    }

    public void load() {
        for (IContainerObjectHandler objectHandler : objectHandlers) {
            objectHandler.load(this.window);
        }
    }

    public void refresh() {
        for (IContainerObjectHandler objectHandler : objectHandlers) {
            objectHandler.guiTick(this.window);
        }
    }

    public void guiTick() {
        for (IContainerObjectHandler objectHandler : objectHandlers) {
            objectHandler.guiTick(this.window);
        }
    }

    public boolean lastKeyTyped(int keyID, char keyChar) {
        for (IContainerInputHandler inputhander : inputHandlers) {
            if (!inputhander.lastKeyTyped(this.window, keyChar, keyID)) continue;
            return true;
        }
        return false;
    }

    public boolean firstKeyTyped(int keyID, char keyChar) {
        for (IContainerInputHandler inputhander : inputHandlers) {
            inputhander.onKeyTyped(this.window, keyChar, keyID);
        }
        for (IContainerInputHandler inputhander : inputHandlers) {
            if (!inputhander.keyTyped(this.window, keyChar, keyID)) continue;
            return true;
        }
        return false;
    }

    public boolean mouseClicked(int mousex, int mousey, int button) {
        for (IContainerInputHandler inputhander : inputHandlers) {
            inputhander.onMouseClicked(this.window, mousex, mousey, button);
        }
        for (IContainerInputHandler inputhander : inputHandlers) {
            if (!inputhander.mouseClicked(this.window, mousex, mousey, button)) continue;
            return true;
        }
        return false;
    }

    public void mouseWheel(int scrolled) {
        Point mousepos = this.getMousePosition();
        for (IContainerInputHandler inputHandler : inputHandlers) {
            inputHandler.onMouseScrolled(this.window, mousepos.x, mousepos.y, scrolled);
        }
        for (IContainerInputHandler inputHandler : inputHandlers) {
            if (!inputHandler.mouseScrolled(this.window, mousepos.x, mousepos.y, scrolled)) continue;
            return;
        }
    }

    public void mouseUp(int mousex, int mousey, int button) {
        for (IContainerInputHandler inputhander : inputHandlers) {
            inputhander.onMouseUp(this.window, mousex, mousey, button);
        }
    }

    public void mouseDragged(int mousex, int mousey, int button, long heldTime) {
        for (IContainerInputHandler inputhander : inputHandlers) {
            inputhander.onMouseDragged(this.window, mousex, mousey, button, heldTime);
        }
    }

    public void preDraw() {
        for (IContainerDrawHandler drawHandler : drawHandlers) {
            drawHandler.onPreDraw(this.window);
        }
    }

    public void renderObjects(int mousex, int mousey) {
        for (IContainerDrawHandler drawHandler : drawHandlers) {
            drawHandler.renderObjects(this.window, mousex, mousey);
        }
        for (IContainerDrawHandler drawHandler : drawHandlers) {
            drawHandler.postRenderObjects(this.window, mousex, mousey);
        }
    }

    public void renderToolTips(int mousex, int mousey) {
        List tooltip = this.window.handleTooltip(mousex, mousey, new LinkedList());
        for (IContainerTooltipHandler handler : tooltipHandlers) {
            tooltip = handler.handleTooltipFirst(this.window, mousex, mousey, tooltip);
        }
        if (tooltip.isEmpty() && this.shouldShowTooltip()) {
            ur stack = this.getStackMouseOver();
            if (stack != null) {
                tooltip = GuiContainerManager.itemDisplayNameMultiline(stack, this.window, true);
            }
            tooltip = this.window.handleItemTooltip(stack, mousex, mousey, tooltip);
        }
        this.drawMultilineTip(mousex, mousey, tooltip);
    }

    public boolean shouldShowTooltip() {
        for (IContainerObjectHandler handler : objectHandlers) {
            if (handler.shouldShowTooltip(this.window)) continue;
            return false;
        }
        return this.window.f.g.bJ.n() == null;
    }

    public void renderSlotUnderlay(sr slot) {
        for (IContainerDrawHandler drawHandler : drawHandlers) {
            drawHandler.renderSlotUnderlay(this.window, slot);
        }
    }

    public void renderSlotOverlay(sr slot) {
        for (IContainerDrawHandler drawHandler : drawHandlers) {
            drawHandler.renderSlotOverlay(this.window, slot);
        }
    }

    public boolean objectUnderMouse(int mousex, int mousey) {
        for (IContainerObjectHandler objectHandler : objectHandlers) {
            if (!objectHandler.objectUnderMouse(this.window, mousex, mousey)) continue;
            return true;
        }
        return false;
    }

    public void handleMouseClick(sr slot, int slotIndex, int button, int modifier) {
        for (IContainerSlotClickHandler handler : slotClickHandlers) {
            handler.beforeSlotClick(this.window, slotIndex, button, slot, modifier);
        }
        boolean eventHandled = false;
        for (IContainerSlotClickHandler handler : slotClickHandlers) {
            eventHandled = handler.handleSlotClick(this.window, slotIndex, button, slot, modifier, eventHandled);
        }
        for (IContainerSlotClickHandler handler : slotClickHandlers) {
            handler.afterSlotClick(this.window, slotIndex, button, slot, modifier);
        }
    }
}

