/*
 * Decompiled with CFR 0.152.
 */
package buildcraft;

import buildcraft.BuildCraftCore;
import buildcraft.api.fuels.IronEngineCoolant;
import buildcraft.api.fuels.IronEngineFuel;
import buildcraft.api.gates.Trigger;
import buildcraft.api.recipes.RefineryRecipe;
import buildcraft.core.DefaultProps;
import buildcraft.core.ItemBuildCraft;
import buildcraft.core.network.PacketHandler;
import buildcraft.core.proxy.CoreProxy;
import buildcraft.energy.BlockEngine;
import buildcraft.energy.BlockOilFlowing;
import buildcraft.energy.BlockOilStill;
import buildcraft.energy.BptBlockEngine;
import buildcraft.energy.EnergyProxy;
import buildcraft.energy.Engine;
import buildcraft.energy.GuiHandler;
import buildcraft.energy.ItemBucketOil;
import buildcraft.energy.ItemEngine;
import buildcraft.energy.OilBucketHandler;
import buildcraft.energy.OilPopulate;
import buildcraft.energy.TriggerEngineHeat;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.LanguageRegistry;
import java.util.TreeMap;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.Property;
import net.minecraftforge.liquids.LiquidContainerData;
import net.minecraftforge.liquids.LiquidContainerRegistry;
import net.minecraftforge.liquids.LiquidDictionary;
import net.minecraftforge.liquids.LiquidStack;

@Mod(name="BuildCraft Energy", version="3.4.3", useMetadata=false, modid="BuildCraft|Energy", dependencies="required-after:BuildCraft|Core@3.4.3")
@NetworkMod(channels={"BC"}, packetHandler=PacketHandler.class, clientSideRequired=true, serverSideRequired=true)
public class BuildCraftEnergy {
    public static final int ENERGY_REMOVE_BLOCK = 25;
    public static final int ENERGY_EXTRACT_ITEM = 2;
    public static BlockEngine engineBlock;
    public static amq oilMoving;
    public static amq oilStill;
    public static up bucketOil;
    public static up bucketFuel;
    public static up fuel;
    public static LiquidStack oilLiquid;
    public static LiquidStack fuelLiquid;
    public static TreeMap saturationStored;
    public static Trigger triggerBlueEngineHeat;
    public static Trigger triggerGreenEngineHeat;
    public static Trigger triggerYellowEngineHeat;
    public static Trigger triggerRedEngineHeat;
    @Mod.Instance(value="BuildCraft|Energy")
    public static BuildCraftEnergy instance;

    @Mod.Init
    public static void load(FMLInitializationEvent evt) {
        NetworkRegistry.instance().registerGuiHandler((Object)instance, (IGuiHandler)new GuiHandler());
        if (BuildCraftCore.modifyWorld) {
            MinecraftForge.EVENT_BUS.register((Object)new OilPopulate());
        }
        new BptBlockEngine(BuildCraftEnergy.engineBlock.cm);
        if (BuildCraftCore.loadDefaultRecipes) {
            BuildCraftEnergy.loadRecipes();
        }
        EnergyProxy.proxy.registerBlockRenderers();
        EnergyProxy.proxy.registerTileEntities();
        EnergyProxy.proxy.registerTextureFX();
    }

    @Mod.PreInit
    public void initialize(FMLPreInitializationEvent evt) {
        Property engineId = BuildCraftCore.mainConfiguration.getBlock("engine.id", DefaultProps.ENGINE_ID);
        Property oilStillId = BuildCraftCore.mainConfiguration.getBlock("oilStill.id", DefaultProps.OIL_STILL_ID);
        Property oilMovingId = BuildCraftCore.mainConfiguration.getBlock("oilMoving.id", DefaultProps.OIL_MOVING_ID);
        Property bucketOilId = BuildCraftCore.mainConfiguration.get("item", "bucketOil.id", DefaultProps.BUCKET_OIL_ID);
        Property bucketFuelId = BuildCraftCore.mainConfiguration.get("item", "bucketFuel.id", DefaultProps.BUCKET_FUEL_ID);
        Property itemFuelId = BuildCraftCore.mainConfiguration.get("item", "fuel.id", DefaultProps.FUEL_ID);
        BuildCraftCore.mainConfiguration.save();
        engineBlock = new BlockEngine(engineId.getInt(DefaultProps.ENGINE_ID));
        GameRegistry.registerBlock((amq)engineBlock, ItemEngine.class);
        LanguageRegistry.addName((Object)new ur((amq)engineBlock, 1, 0), (String)"Redstone Engine");
        LanguageRegistry.addName((Object)new ur((amq)engineBlock, 1, 1), (String)"Steam Engine");
        LanguageRegistry.addName((Object)new ur((amq)engineBlock, 1, 2), (String)"Combustion Engine");
        oilStill = new BlockOilStill(oilStillId.getInt(DefaultProps.OIL_STILL_ID), agi.h).b("oil");
        CoreProxy.proxy.addName(oilStill.b("oilStill"), "Oil");
        CoreProxy.proxy.registerBlock(oilStill);
        oilMoving = new BlockOilFlowing(oilMovingId.getInt(DefaultProps.OIL_MOVING_ID), agi.h).b("oil");
        CoreProxy.proxy.addName(oilMoving.b("oilMoving"), "Oil");
        CoreProxy.proxy.registerBlock(oilMoving);
        if (BuildCraftEnergy.oilMoving.cm + 1 != BuildCraftEnergy.oilStill.cm) {
            throw new RuntimeException("Oil Still id must be Oil Moving id + 1");
        }
        fuel = new ItemBuildCraft(itemFuelId.getInt(DefaultProps.FUEL_ID)).b("fuel");
        LanguageRegistry.addName((Object)fuel, (String)"Fuel");
        MinecraftForge.EVENT_BUS.register((Object)new OilBucketHandler());
        bucketOil = new ItemBucketOil(bucketOilId.getInt(DefaultProps.BUCKET_OIL_ID)).b("bucketOil").a(up.aw);
        LanguageRegistry.addName((Object)bucketOil, (String)"Oil Bucket");
        bucketFuel = new ItemBuildCraft(Integer.parseInt(bucketFuelId.value)).b("bucketFuel").a(up.aw);
        bucketFuel.c(3).d(1);
        LanguageRegistry.addName((Object)bucketFuel, (String)"Fuel Bucket");
        oilLiquid = LiquidDictionary.getOrCreateLiquid((String)"Oil", (LiquidStack)new LiquidStack(oilStill, 1));
        fuelLiquid = LiquidDictionary.getOrCreateLiquid((String)"Fuel", (LiquidStack)new LiquidStack(fuel, 1));
        RefineryRecipe.registerRefineryRecipe(new RefineryRecipe(LiquidDictionary.getLiquid((String)"Oil", (int)1), null, LiquidDictionary.getLiquid((String)"Fuel", (int)1), 12, 1));
        IronEngineFuel.fuels.add(new IronEngineFuel(amq.G.cm, 1.0f, 20000));
        IronEngineFuel.fuels.add(new IronEngineFuel(LiquidDictionary.getLiquid((String)"Oil", (int)1000), 3.0f, 20000));
        IronEngineFuel.fuels.add(new IronEngineFuel(LiquidDictionary.getLiquid((String)"Fuel", (int)1000), 6.0f, 100000));
        IronEngineCoolant.coolants.add(new IronEngineCoolant(new LiquidStack(amq.E, 1000), 1.0f));
        LiquidContainerRegistry.registerLiquid((LiquidContainerData)new LiquidContainerData(LiquidDictionary.getLiquid((String)"Oil", (int)1000), new ur(bucketOil), new ur(up.aw)));
        LiquidContainerRegistry.registerLiquid((LiquidContainerData)new LiquidContainerData(LiquidDictionary.getLiquid((String)"Fuel", (int)1000), new ur(bucketFuel), new ur(up.aw)));
    }

    public static void loadRecipes() {
        CoreProxy.proxy.addCraftingRecipe(new ur((amq)engineBlock, 1, 0), new Object[]{"www", " g ", "GpG", Character.valueOf('w'), "plankWood", Character.valueOf('g'), amq.P, Character.valueOf('G'), BuildCraftCore.woodenGearItem, Character.valueOf('p'), amq.ac});
        CoreProxy.proxy.addCraftingRecipe(new ur((amq)engineBlock, 1, 1), new Object[]{"www", " g ", "GpG", Character.valueOf('w'), amq.z, Character.valueOf('g'), amq.P, Character.valueOf('G'), BuildCraftCore.stoneGearItem, Character.valueOf('p'), amq.ac});
        CoreProxy.proxy.addCraftingRecipe(new ur((amq)engineBlock, 1, 2), new Object[]{"www", " g ", "GpG", Character.valueOf('w'), up.o, Character.valueOf('g'), amq.P, Character.valueOf('G'), BuildCraftCore.ironGearItem, Character.valueOf('p'), amq.ac});
    }

    static {
        saturationStored = new TreeMap();
        triggerBlueEngineHeat = new TriggerEngineHeat(DefaultProps.TRIGGER_BLUE_ENGINE_HEAT, Engine.EnergyStage.Blue);
        triggerGreenEngineHeat = new TriggerEngineHeat(DefaultProps.TRIGGER_GREEN_ENGINE_HEAT, Engine.EnergyStage.Green);
        triggerYellowEngineHeat = new TriggerEngineHeat(DefaultProps.TRIGGER_YELLOW_ENGINE_HEAT, Engine.EnergyStage.Yellow);
        triggerRedEngineHeat = new TriggerEngineHeat(DefaultProps.TRIGGER_RED_ENGINE_HEAT, Engine.EnergyStage.Red);
    }
}

