/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.builders;

import buildcraft.BuildCraftBuilders;
import buildcraft.api.blueprints.BptBlock;
import buildcraft.api.blueprints.BptBlockUtils;
import buildcraft.api.blueprints.BptSlotInfo;
import buildcraft.api.blueprints.IBptContext;
import buildcraft.api.core.LaserKind;
import buildcraft.api.core.Position;
import buildcraft.builders.TileFiller;
import buildcraft.core.Box;
import java.util.LinkedList;

public class BptBlockFiller
extends BptBlock {
    public BptBlockFiller(int blockId) {
        super(blockId);
    }

    @Override
    public void addRequirements(BptSlotInfo slot, IBptContext context, LinkedList requirements) {
        ur[] recipeStack = BptBlockUtils.getItemStacks(slot, context);
        for (int i = 0; i < recipeStack.length; ++i) {
            if (recipeStack[i] == null) continue;
            requirements.add(recipeStack[i]);
        }
        requirements.add(new ur((amq)BuildCraftBuilders.fillerBlock));
    }

    @Override
    public void rotateLeft(BptSlotInfo slot, IBptContext context) {
        super.rotateLeft(slot, context);
        Box box = new Box();
        box.initialize(slot.cpt.l("box"));
        Position pMin = context.rotatePositionLeft(box.pMin());
        Position pMax = context.rotatePositionLeft(box.pMax());
        box.xMin = (int)pMin.x;
        box.yMin = (int)pMin.y;
        box.zMin = (int)pMin.z;
        box.xMax = (int)pMax.x;
        box.yMax = (int)pMax.y;
        box.zMax = (int)pMax.z;
        box.reorder();
        bq cpt = new bq();
        box.writeToNBT(cpt);
        slot.cpt.a("box", (cd)cpt);
    }

    @Override
    public void buildBlock(BptSlotInfo slot, IBptContext context) {
        context.world().e(slot.x, slot.y, slot.z, slot.blockId);
        TileFiller filler = (TileFiller)context.world().q(slot.x, slot.y, slot.z);
        Box box = new Box();
        box.initialize(slot.cpt.l("box"));
        box.xMin = (int)((double)box.xMin + context.surroundingBox().pMin().x);
        box.yMin = (int)((double)box.yMin + context.surroundingBox().pMin().y);
        box.zMin = (int)((double)box.zMin + context.surroundingBox().pMin().z);
        box.xMax = (int)((double)box.xMax + context.surroundingBox().pMin().x);
        box.yMax = (int)((double)box.yMax + context.surroundingBox().pMin().y);
        box.zMax = (int)((double)box.zMax + context.surroundingBox().pMin().z);
        box.reorder();
        filler.box.deleteLasers();
        filler.box = box;
        filler.box.createLasers(context.world(), LaserKind.Stripes);
        ur[] recipeStack = BptBlockUtils.getItemStacks(slot, context);
        for (int i = 0; i < recipeStack.length; ++i) {
            filler.a(i, recipeStack[i]);
        }
    }

    @Override
    public void initializeFromWorld(BptSlotInfo slot, IBptContext context, int x, int y2, int z) {
        TileFiller filler = (TileFiller)context.world().q(x, y2, z);
        bq cpt = new bq();
        Box fillerBox = new Box();
        fillerBox.initialize(filler.box);
        fillerBox.xMin = (int)((double)fillerBox.xMin - context.surroundingBox().pMin().x);
        fillerBox.yMin = (int)((double)fillerBox.yMin - context.surroundingBox().pMin().y);
        fillerBox.zMin = (int)((double)fillerBox.zMin - context.surroundingBox().pMin().z);
        fillerBox.xMax = (int)((double)fillerBox.xMax - context.surroundingBox().pMin().x);
        fillerBox.yMax = (int)((double)fillerBox.yMax - context.surroundingBox().pMin().y);
        fillerBox.zMax = (int)((double)fillerBox.zMax - context.surroundingBox().pMin().z);
        fillerBox.reorder();
        fillerBox.writeToNBT(cpt);
        slot.cpt.a("box", (cd)cpt);
        ur[] recipeStack = new ur[9];
        for (int i = 0; i < 9; ++i) {
            recipeStack[i] = filler.a(i);
        }
        BptBlockUtils.setItemStacks(slot, context, recipeStack);
    }
}

