/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core;

import buildcraft.api.core.SafeTimeTracker;

public class TileBuffer {
    private int blockID = 0;
    private any tile;
    private SafeTimeTracker tracker = new SafeTimeTracker();
    private yc world;
    int x;
    int y;
    int z;

    public void initialize(yc world, int x, int y2, int z) {
        this.world = world;
        this.x = x;
        this.y = y2;
        this.z = z;
        this.refresh();
    }

    public void refresh() {
        this.tile = null;
        this.blockID = this.world.a(this.x, this.y, this.z);
        amq block = amq.p[this.blockID];
        if (block != null && block.hasTileEntity(this.world.h(this.x, this.y, this.z))) {
            this.tile = this.world.q(this.x, this.y, this.z);
        }
    }

    public void set(int blockID, any tile) {
        this.blockID = blockID;
        this.tile = tile;
        this.tracker.markTime(this.world);
    }

    public int getBlockID() {
        if (this.tile != null && !this.tile.r()) {
            return this.blockID;
        }
        if (this.tracker.markTimeIfDelay(this.world, 20L)) {
            this.refresh();
            if (this.tile != null && !this.tile.r()) {
                return this.blockID;
            }
        }
        return 0;
    }

    public any getTile() {
        if (this.tile != null && !this.tile.r()) {
            return this.tile;
        }
        if (this.tracker.markTimeIfDelay(this.world, 20L)) {
            this.refresh();
            if (this.tile != null && !this.tile.r()) {
                return this.tile;
            }
        }
        return null;
    }
}

