/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.blueprints;

import buildcraft.BuildCraftCore;
import buildcraft.core.Box;
import buildcraft.core.blueprints.BptBlueprint;
import buildcraft.core.blueprints.BptContext;
import buildcraft.core.blueprints.BptError;
import buildcraft.core.blueprints.BptSlot;
import buildcraft.core.blueprints.BptTemplate;
import buildcraft.core.proxy.CoreProxy;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;

public abstract class BptBase {
    BptSlot[][][] contents;
    public int position;
    public int anchorX;
    public int anchorY;
    public int anchorZ;
    public int sizeX;
    public int sizeY;
    public int sizeZ;
    protected String name;
    public String author;
    public File file;
    protected String version = "";

    public BptBase() {
    }

    public BptBase(int sizeX, int sizeY, int sizeZ) {
        this.contents = new BptSlot[sizeX][sizeY][sizeZ];
        this.sizeX = sizeX;
        this.sizeY = sizeY;
        this.sizeZ = sizeZ;
        this.anchorX = 0;
        this.anchorY = 0;
        this.anchorZ = 0;
    }

    public void setBlockId(int x, int y2, int z, int blockId) {
        if (this.contents[x][y2][z] == null) {
            this.contents[x][y2][z] = new BptSlot();
            this.contents[x][y2][z].x = x;
            this.contents[x][y2][z].y = y2;
            this.contents[x][y2][z].z = z;
        }
        this.contents[x][y2][z].blockId = blockId;
    }

    public void rotateLeft(BptContext context) {
        BptSlot[][][] newContents = new BptSlot[this.sizeZ][this.sizeY][this.sizeX];
        for (int x = 0; x < this.sizeZ; ++x) {
            for (int y2 = 0; y2 < this.sizeY; ++y2) {
                for (int z = 0; z < this.sizeX; ++z) {
                    newContents[x][y2][z] = this.contents[z][y2][this.sizeZ - 1 - x];
                    if (newContents[x][y2][z] == null) continue;
                    try {
                        newContents[x][y2][z].rotateLeft(context);
                        continue;
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                        BuildCraftCore.bcLog.throwing("BptBase", "rotateLeft", t);
                    }
                }
            }
        }
        int newAnchorX = this.sizeZ - 1 - this.anchorZ;
        int newAnchorY = this.anchorY;
        int newAnchorZ = this.anchorX;
        this.contents = newContents;
        int tmp = this.sizeX;
        this.sizeX = this.sizeZ;
        this.sizeZ = tmp;
        this.anchorX = newAnchorX;
        this.anchorY = newAnchorY;
        this.anchorZ = newAnchorZ;
        context.rotateLeft();
    }

    public File save() {
        try {
            File baseDir = CoreProxy.proxy.getBuildCraftBase();
            baseDir.mkdir();
            if (!this.file.exists()) {
                this.file.createNewFile();
            }
            FileOutputStream output = new FileOutputStream(this.file);
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)output, "8859_1"));
            writer.write("version:3.4.3");
            writer.newLine();
            if (this instanceof BptTemplate) {
                writer.write("kind:template");
            } else {
                writer.write("kind:blueprint");
            }
            writer.newLine();
            writer.write("sizeX:" + this.sizeX);
            writer.newLine();
            writer.write("sizeY:" + this.sizeY);
            writer.newLine();
            writer.write("sizeZ:" + this.sizeZ);
            writer.newLine();
            writer.write("anchorX:" + this.anchorX);
            writer.newLine();
            writer.write("anchorY:" + this.anchorY);
            writer.newLine();
            writer.write("anchorZ:" + this.anchorZ);
            writer.newLine();
            writer.write("name:" + this.name);
            writer.newLine();
            if (this.author != null) {
                writer.write("author:" + this.author);
                writer.newLine();
            }
            this.saveAttributes(writer);
            writer.newLine();
            writer.flush();
            output.close();
            return this.file;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public boolean equals(Object o) {
        if (o == null || o.getClass() == this.getClass()) {
            return false;
        }
        BptBase bpt = (BptBase)o;
        if (this.sizeX != bpt.sizeX || this.sizeY != bpt.sizeY || this.sizeZ != bpt.sizeZ || this.anchorX != bpt.anchorX || this.anchorY != bpt.anchorY || this.anchorZ != bpt.anchorZ) {
            return false;
        }
        for (int x = 0; x < this.contents.length; ++x) {
            for (int y2 = 0; y2 < this.contents[0].length; ++y2) {
                for (int z = 0; z < this.contents[0][0].length; ++z) {
                    if (this.contents[x][y2][z] != null && bpt.contents[x][y2][z] == null) {
                        return false;
                    }
                    if (this.contents[x][y2][z] == null && bpt.contents[x][y2][z] != null) {
                        return false;
                    }
                    if (this.contents[x][y2][z] == null && bpt.contents[x][y2][z] == null || this.contents[x][y2][z].blockId == bpt.contents[x][y2][z].blockId) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public static BptBase loadBluePrint(File file, int position) {
        BptBase result = null;
        String version = null;
        try {
            String line;
            FileInputStream input = new FileInputStream(file);
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)input, "8859_1"));
            while ((line = reader.readLine()) != null) {
                String[] cpts = line.split(":");
                String attr = cpts[0];
                if (attr.equals("kind")) {
                    if (cpts[1].equals("template")) {
                        result = new BptTemplate();
                    } else if (cpts[1].equals("blueprint")) {
                        result = new BptBlueprint();
                    }
                    result.position = position;
                    result.version = version;
                    result.file = file;
                    continue;
                }
                if (attr.equals("sizeX")) {
                    result.sizeX = Integer.parseInt(cpts[1]);
                    continue;
                }
                if (attr.equals("sizeY")) {
                    result.sizeY = Integer.parseInt(cpts[1]);
                    continue;
                }
                if (attr.equals("sizeZ")) {
                    result.sizeZ = Integer.parseInt(cpts[1]);
                    continue;
                }
                if (attr.equals("anchorX")) {
                    result.anchorX = Integer.parseInt(cpts[1]);
                    continue;
                }
                if (attr.equals("anchorY")) {
                    result.anchorY = Integer.parseInt(cpts[1]);
                    continue;
                }
                if (attr.equals("anchorZ")) {
                    result.anchorZ = Integer.parseInt(cpts[1]);
                    continue;
                }
                if (attr.equals("name")) {
                    result.name = cpts[1];
                    continue;
                }
                if (attr.equals("version")) {
                    if (result != null) {
                        result.version = version;
                        continue;
                    }
                    version = cpts[1];
                    continue;
                }
                if (attr.equals("author")) {
                    result.author = cpts[1];
                    continue;
                }
                if (result == null) continue;
                if (cpts.length >= 2) {
                    result.loadAttribute(reader, attr, cpts[1]);
                    continue;
                }
                result.loadAttribute(reader, attr, "");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return result;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        if (this.name == null) {
            return "#" + this.position;
        }
        return this.name;
    }

    public final BptBase clone() {
        BptBase res = null;
        try {
            res = (BptBase)this.getClass().newInstance();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
            return null;
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return null;
        }
        res.anchorX = this.anchorX;
        res.anchorY = this.anchorY;
        res.anchorZ = this.anchorZ;
        res.sizeX = this.sizeX;
        res.sizeY = this.sizeY;
        res.sizeZ = this.sizeZ;
        res.position = this.position;
        res.name = this.name;
        res.author = this.author;
        res.contents = new BptSlot[this.sizeX][this.sizeY][this.sizeZ];
        for (int x = 0; x < this.sizeX; ++x) {
            for (int y2 = 0; y2 < this.sizeY; ++y2) {
                for (int z = 0; z < this.sizeZ; ++z) {
                    if (this.contents[x][y2][z] == null) continue;
                    res.contents[x][y2][z] = this.contents[x][y2][z].clone();
                }
            }
        }
        this.copyTo(res);
        return res;
    }

    protected void copyTo(BptBase base) {
    }

    public Box getBoxForPos(int x, int y2, int z) {
        int xMin = x - this.anchorX;
        int yMin = y2 - this.anchorY;
        int zMin = z - this.anchorZ;
        int xMax = x + this.sizeX - this.anchorX - 1;
        int yMax = y2 + this.sizeY - this.anchorY - 1;
        int zMax = z + this.sizeZ - this.anchorZ - 1;
        Box res = new Box();
        res.initialize(xMin, yMin, zMin, xMax, yMax, zMax);
        res.reorder();
        return res;
    }

    public abstract void loadAttribute(BufferedReader var1, String var2, String var3) throws IOException, BptError;

    public abstract void saveAttributes(BufferedWriter var1) throws IOException;
}

