/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.blueprints;

import buildcraft.BuildCraftCore;
import buildcraft.api.blueprints.BlockSignature;
import buildcraft.api.blueprints.BlueprintManager;
import buildcraft.api.blueprints.BptBlock;
import buildcraft.api.blueprints.IBptContext;
import buildcraft.api.blueprints.ItemSignature;
import buildcraft.core.IBptContributor;
import buildcraft.core.blueprints.BptBase;
import buildcraft.core.blueprints.BptDataStream;
import buildcraft.core.blueprints.BptError;
import buildcraft.core.blueprints.BptSlot;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.StringReader;
import java.util.TreeSet;

public class BptBlueprint
extends BptBase {
    private int[] idMapping = new int[up.e.length];
    TreeSet idsToMap = new TreeSet();

    public BptBlueprint() {
        for (int i = 0; i < this.idMapping.length; ++i) {
            this.idMapping[i] = i;
        }
    }

    public BptBlueprint(int sizeX, int sizeY, int sizeZ) {
        super(sizeX, sizeY, sizeZ);
        for (int i = 0; i < this.idMapping.length; ++i) {
            this.idMapping[i] = i;
        }
    }

    public void readFromWorld(IBptContext context, any anchorTile, int x, int y2, int z) {
        any tile;
        BptSlot slot = new BptSlot();
        slot.x = (int)((double)x - context.surroundingBox().pMin().x);
        slot.y = (int)((double)y2 - context.surroundingBox().pMin().y);
        slot.z = (int)((double)z - context.surroundingBox().pMin().z);
        slot.blockId = anchorTile.k.a(x, y2, z);
        slot.meta = anchorTile.k.h(x, y2, z);
        if (amq.p[slot.blockId] instanceof akb && (tile = anchorTile.k.q(x, y2, z)) != null && tile instanceof IBptContributor) {
            IBptContributor contributor = (IBptContributor)tile;
            contributor.saveToBluePrint(anchorTile, this, slot);
        }
        try {
            slot.initializeFromWorld(context, x, y2, z);
            this.contents[slot.x][slot.y][slot.z] = slot;
        }
        catch (Throwable t) {
            t.printStackTrace();
            BuildCraftCore.bcLog.throwing("BptBlueprint", "readFromWorld", t);
        }
    }

    @Override
    public void saveAttributes(BufferedWriter writer) throws IOException {
        int x;
        BptSlot slot;
        int z;
        writer.write("sizeX:" + this.sizeX);
        writer.newLine();
        writer.write("sizeY:" + this.sizeY);
        writer.newLine();
        writer.write("sizeZ:" + this.sizeZ);
        writer.newLine();
        writer.write("anchorX:" + this.anchorX);
        writer.newLine();
        writer.write("anchorY:" + this.anchorY);
        writer.newLine();
        writer.write("anchorZ:" + this.anchorZ);
        writer.newLine();
        boolean[] idsUsed = new boolean[up.e.length];
        for (int i = 1; i < idsUsed.length; ++i) {
            idsUsed[i] = false;
        }
        for (int x2 = 0; x2 < this.sizeX; ++x2) {
            for (int y2 = 0; y2 < this.sizeY; ++y2) {
                for (z = 0; z < this.sizeZ; ++z) {
                    slot = this.contents[x2][y2][z];
                    this.storeId(slot.blockId);
                    for (ur stack : slot.storedRequirements) {
                        this.storeId(stack.c);
                    }
                }
            }
        }
        writer.write("idMap:");
        writer.newLine();
        for (Integer id : this.idsToMap) {
            if (id < amq.p.length && amq.p[id] != null) {
                writer.write(BlueprintManager.getBlockSignature(amq.p[id]) + "=" + id);
            } else {
                writer.write(BlueprintManager.getItemSignature(up.e[id]) + "=" + id);
            }
            writer.newLine();
        }
        writer.write(":idMap");
        writer.newLine();
        writer.write("contents:");
        writer.newLine();
        for (x = 0; x < this.sizeX; ++x) {
            for (int y3 = 0; y3 < this.sizeY; ++y3) {
                for (z = 0; z < this.sizeZ; ++z) {
                    slot = this.contents[x][y3][z];
                    if (slot != null && slot.blockId != 0) {
                        slot.cpt.a("bId", slot.blockId);
                        if (slot.meta != 0) {
                            slot.cpt.a("meta", slot.meta);
                        }
                        cd.a((cd)slot.cpt, (DataOutput)new BptDataStream(writer));
                        writer.newLine();
                        continue;
                    }
                    writer.newLine();
                }
            }
        }
        writer.write(":contents");
        writer.newLine();
        writer.write("requirements:");
        writer.newLine();
        for (x = 0; x < this.sizeX; ++x) {
            for (int y4 = 0; y4 < this.sizeY; ++y4) {
                for (z = 0; z < this.sizeZ; ++z) {
                    slot = this.contents[x][y4][z];
                    if (slot != null && slot.blockId != 0 && slot.storedRequirements.size() > 0) {
                        by list = new by();
                        for (ur stack : slot.storedRequirements) {
                            bq sub = new bq();
                            stack.b(sub);
                            list.a((cd)sub);
                        }
                        cd.a((cd)list, (DataOutput)new BptDataStream(writer));
                        writer.newLine();
                        continue;
                    }
                    writer.newLine();
                }
            }
        }
        writer.write(":requirements");
        writer.newLine();
    }

    @Override
    public void loadAttribute(BufferedReader reader, String attr, String val) throws IOException, BptError {
        block19: {
            block20: {
                block18: {
                    String mapStr;
                    if ("3.1.0".equals(this.version)) {
                        throw new BptError("Blueprint format 3.1.0 is not supported anymore, can't load " + this.file);
                    }
                    if (!attr.equals("blockMap") && !attr.equals("idMap")) break block18;
                    while ((mapStr = reader.readLine()) != null) {
                        if ((mapStr = mapStr.replaceAll("\n", "")).equals(":blockMap") || mapStr.equals(":idMap")) {
                            return;
                        }
                        String[] parts = mapStr.split("=");
                        int blockId = Integer.parseInt(parts[1]);
                        if (parts[0].startsWith("#I")) {
                            ItemSignature sig = new ItemSignature(parts[0]);
                            int itemId = Integer.parseInt(parts[1]);
                            if (this.itemMatch(sig, up.e[itemId])) continue;
                            boolean found = false;
                            for (int i = 256; i < up.e.length; ++i) {
                                if (i < amq.p.length && amq.p[i] != null || !this.itemMatch(sig, up.e[i])) continue;
                                found = true;
                                this.idMapping[itemId] = i;
                                break;
                            }
                            if (found) continue;
                            throw new BptError("BLUEPRINT ERROR: can't find item of signature " + sig + " for " + this.name);
                        }
                        BlockSignature bptSignature = new BlockSignature(parts[0]);
                        BptBlock defaultBlock = BlueprintManager.blockBptProps[0];
                        BptBlock handlingBlock = BlueprintManager.blockBptProps[blockId];
                        if (handlingBlock == null) {
                            handlingBlock = defaultBlock;
                        }
                        if (handlingBlock.match(amq.p[blockId], bptSignature)) continue;
                        boolean found = false;
                        for (int i = 0; i < amq.p.length; ++i) {
                            if (amq.p[i] == null) continue;
                            handlingBlock = BlueprintManager.blockBptProps[i];
                            if (handlingBlock == null) {
                                handlingBlock = defaultBlock;
                            }
                            if (!handlingBlock.match(amq.p[i], bptSignature)) continue;
                            this.idMapping[blockId] = i;
                            found = true;
                        }
                        if (found) continue;
                        throw new BptError("BLUEPRINT ERROR: can't find block of signature " + bptSignature + " for " + this.name);
                    }
                    break block19;
                }
                if (!attr.equals("contents")) break block20;
                this.contents = new BptSlot[this.sizeX][this.sizeY][this.sizeZ];
                for (int x = 0; x < this.sizeX; ++x) {
                    for (int y2 = 0; y2 < this.sizeY; ++y2) {
                        for (int z = 0; z < this.sizeZ; ++z) {
                            String slotStr = reader.readLine().replaceAll("\n", "");
                            if (slotStr.equals(":contents")) {
                                return;
                            }
                            if (slotStr.equals("")) continue;
                            BptSlot slot = new BptSlot();
                            slot.x = x;
                            slot.y = y2;
                            slot.z = z;
                            slot.cpt = (bq)cd.b((DataInput)new BptDataStream(new StringReader(slotStr)));
                            slot.blockId = this.mapWorldId(slot.cpt.e("bId"));
                            if (slot.cpt.b("meta")) {
                                slot.meta = slot.cpt.e("meta");
                            }
                            this.contents[x][y2][z] = slot;
                        }
                    }
                }
                break block19;
            }
            if (!attr.equals("requirements")) break block19;
            for (int x = 0; x < this.sizeX; ++x) {
                for (int y3 = 0; y3 < this.sizeY; ++y3) {
                    for (int z = 0; z < this.sizeZ; ++z) {
                        String reqStr = reader.readLine().replaceAll("\n", "");
                        if (reqStr.equals(":requirements")) {
                            return;
                        }
                        if (reqStr.equals("")) continue;
                        by list = (by)cd.b((DataInput)new BptDataStream(new StringReader(reqStr)));
                        for (int i = 0; i < list.c(); ++i) {
                            ur stk = this.mapItemStack(ur.a((bq)((bq)list.b(i))));
                            this.contents[x][y3][z].storedRequirements.add(stk);
                        }
                    }
                }
            }
        }
    }

    @Override
    public String getName() {
        if (this.name == null) {
            return "Blueprint #" + this.position;
        }
        return this.name;
    }

    public ur mapItemStack(ur bptItemStack) {
        ur newStack = bptItemStack.l();
        newStack.c = this.idMapping[newStack.c];
        return newStack;
    }

    public int mapWorldId(int bptWorldId) {
        return this.idMapping[bptWorldId];
    }

    public void storeId(int worldId) {
        if (worldId != 0) {
            this.idsToMap.add(worldId);
        }
    }

    private boolean itemMatch(ItemSignature sig, up item) {
        if (item == null) {
            return false;
        }
        if (!"*".equals(sig.itemClassName) && !item.getClass().getSimpleName().equals(sig.itemClassName)) {
            return false;
        }
        return "*".equals(sig.itemName) || item.d(new ur(item)).equals(sig.itemName);
    }

    @Override
    public void setBlockId(int x, int y2, int z, int blockId) {
        super.setBlockId(x, y2, z, blockId);
    }

    @Override
    protected void copyTo(BptBase bpt) {
        ((BptBlueprint)bpt).idMapping = (int[])this.idMapping.clone();
    }
}

