/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.triggers;

import buildcraft.api.gates.ITriggerDirectional;
import buildcraft.api.gates.ITriggerParameter;
import buildcraft.api.gates.Trigger;
import buildcraft.core.DefaultProps;
import buildcraft.core.utils.SidedInventoryAdapter;
import buildcraft.core.utils.Utils;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.ISidedInventory;

public class TriggerInventory
extends Trigger
implements ITriggerDirectional {
    public State state;

    public TriggerInventory(int id, State state) {
        super(id);
        this.state = state;
    }

    @Override
    public int getIndexInTexture() {
        switch (this.state) {
            case Empty: {
                return 36;
            }
            case Contains: {
                return 37;
            }
            case Space: {
                return 38;
            }
        }
        return 39;
    }

    @Override
    public boolean hasParameter() {
        return this.state == State.Contains || this.state == State.Space;
    }

    @Override
    public String getDescription() {
        switch (this.state) {
            case Empty: {
                return "Inventory Empty";
            }
            case Contains: {
                return "Items in Inventory";
            }
            case Space: {
                return "Space in Inventory";
            }
        }
        return "Inventory Full";
    }

    @Override
    public boolean isTriggerActive(ForgeDirection side, any tile, ITriggerParameter parameter) {
        ur searchedStack = null;
        if (parameter != null) {
            searchedStack = parameter.getItem();
        }
        if (tile instanceof la) {
            int invSize;
            la inv = Utils.getInventory((la)tile);
            if (side != ForgeDirection.UNKNOWN && inv instanceof ISidedInventory) {
                inv = new SidedInventoryAdapter((ISidedInventory)inv, side);
            }
            if ((invSize = inv.k_()) <= 0) {
                return false;
            }
            boolean foundItems = false;
            boolean foundSpace = false;
            for (int i = 0; i < invSize; ++i) {
                boolean slotEmpty;
                ur stack = inv.a(i);
                boolean bl = slotEmpty = stack == null || stack.a == 0;
                if (searchedStack == null) {
                    foundItems |= !slotEmpty;
                } else if (!slotEmpty) {
                    foundItems |= stack.a(searchedStack);
                }
                if (slotEmpty) {
                    foundSpace = true;
                    continue;
                }
                if (searchedStack == null || stack.a >= stack.d() || !stack.a(searchedStack)) continue;
                foundSpace = true;
            }
            switch (this.state) {
                case Empty: {
                    return !foundItems;
                }
                case Contains: {
                    return foundItems;
                }
                case Space: {
                    return foundSpace;
                }
            }
            return !foundSpace;
        }
        return false;
    }

    @Override
    public boolean isTriggerActive(any tile, ITriggerParameter parameter) {
        return this.isTriggerActive(ForgeDirection.UNKNOWN, tile, parameter);
    }

    @Override
    public String getTextureFile() {
        return DefaultProps.TEXTURE_TRIGGERS;
    }

    public static enum State {
        Empty,
        Contains,
        Space,
        Full;

    }
}

