/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.energy;

import buildcraft.core.network.TileNetworkData;
import buildcraft.core.proxy.CoreProxy;
import buildcraft.energy.TileEngine;
import buildcraft.energy.gui.ContainerEngine;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.ILiquidTank;
import net.minecraftforge.liquids.LiquidStack;
import net.minecraftforge.liquids.LiquidTank;

public abstract class Engine {
    public int maxEnergy;
    protected float currentOutput = 0.0f;
    @TileNetworkData
    public float progress;
    @TileNetworkData
    public ForgeDirection orientation;
    public float energy;
    @TileNetworkData
    public EnergyStage energyStage = EnergyStage.Blue;
    public int maxEnergyExtracted = 1;
    protected TileEngine tile;

    public Engine(TileEngine tile) {
        this.tile = tile;
    }

    protected void computeEnergyStage() {
        this.energyStage = (double)this.energy / (double)this.maxEnergy * 100.0 <= 25.0 ? EnergyStage.Blue : ((double)this.energy / (double)this.maxEnergy * 100.0 <= 50.0 ? EnergyStage.Green : ((double)this.energy / (double)this.maxEnergy * 100.0 <= 75.0 ? EnergyStage.Yellow : ((double)this.energy / (double)this.maxEnergy * 100.0 <= 100.0 ? EnergyStage.Red : EnergyStage.Explosion)));
    }

    public final EnergyStage getEnergyStage() {
        if (!CoreProxy.proxy.isRenderWorld(this.tile.k)) {
            this.computeEnergyStage();
        }
        return this.energyStage;
    }

    public void update() {
        if (!this.tile.isRedstonePowered) {
            if (this.energy >= 1.0f) {
                this.energy -= 1.0f;
            } else if (this.energy < 1.0f) {
                this.energy = 0.0f;
            }
        }
    }

    public abstract String getTextureFile();

    public abstract int explosionRange();

    public int minEnergyReceived() {
        return 2;
    }

    public abstract int maxEnergyReceived();

    public abstract float getPistonSpeed();

    public abstract boolean isBurning();

    public abstract void delete();

    public int fill(ForgeDirection from, LiquidStack resource, boolean doFill) {
        return 0;
    }

    public void addEnergy(float addition) {
        this.energy += addition;
        if (this.getEnergyStage() == EnergyStage.Explosion) {
            this.tile.k.a(null, (double)this.tile.l, (double)this.tile.m, (double)this.tile.n, (float)this.explosionRange(), true);
        }
        if (this.energy > (float)this.maxEnergy) {
            this.energy = this.maxEnergy;
        }
    }

    public float extractEnergy(int min, int max, boolean doExtract) {
        float extracted;
        if (this.energy < (float)min) {
            return 0.0f;
        }
        int actualMax = max > this.maxEnergyExtracted ? this.maxEnergyExtracted : max;
        if (actualMax < min) {
            return 0.0f;
        }
        if (this.energy >= (float)actualMax) {
            extracted = actualMax;
            if (doExtract) {
                this.energy -= (float)actualMax;
            }
        } else {
            extracted = this.energy;
            if (doExtract) {
                this.energy = 0.0f;
            }
        }
        return extracted;
    }

    public abstract int getScaledBurnTime(int var1);

    public abstract void burn();

    public void readFromNBT(bq nbttagcompound) {
    }

    public void writeToNBT(bq nbttagcompound) {
    }

    public void getGUINetworkData(int i, int j) {
    }

    public void sendGUINetworkData(ContainerEngine containerEngine, rw iCrafting) {
    }

    public boolean isActive() {
        return true;
    }

    public int getHeat() {
        return 0;
    }

    public float getEnergyStored() {
        return this.energy;
    }

    public float getCurrentOutput() {
        return this.currentOutput;
    }

    public LiquidTank[] getLiquidSlots() {
        return new LiquidTank[0];
    }

    public int getSizeInventory() {
        return 0;
    }

    public ur getStackInSlot(int i) {
        return null;
    }

    public ur decrStackSize(int i, int j) {
        return null;
    }

    public ur getStackInSlotOnClosing(int i) {
        return this.getStackInSlot(i);
    }

    public void setInventorySlotContents(int i, ur itemstack) {
    }

    public abstract ILiquidTank getTank(ForgeDirection var1, LiquidStack var2);

    public static enum EnergyStage {
        Blue,
        Green,
        Yellow,
        Red,
        Explosion;

    }
}

