/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.energy;

import buildcraft.core.DefaultProps;
import buildcraft.core.utils.Utils;
import buildcraft.energy.Engine;
import buildcraft.energy.TileEngine;
import buildcraft.energy.gui.ContainerEngine;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.ILiquidTank;
import net.minecraftforge.liquids.LiquidStack;

public class EngineStone
extends Engine {
    int burnTime = 0;
    int totalBurnTime = 0;
    private ur itemInInventory;

    public EngineStone(TileEngine engine) {
        super(engine);
        this.maxEnergy = 10000;
        this.maxEnergyExtracted = 100;
    }

    @Override
    public String getTextureFile() {
        return DefaultProps.TEXTURE_PATH_BLOCKS + "/base_stone.png";
    }

    @Override
    public int explosionRange() {
        return 4;
    }

    @Override
    public int maxEnergyReceived() {
        return 200;
    }

    @Override
    public float getPistonSpeed() {
        switch (this.getEnergyStage()) {
            case Blue: {
                return 0.02f;
            }
            case Green: {
                return 0.04f;
            }
            case Yellow: {
                return 0.08f;
            }
            case Red: {
                return 0.16f;
            }
        }
        return 0.0f;
    }

    @Override
    public boolean isBurning() {
        return this.burnTime > 0;
    }

    @Override
    public void burn() {
        this.currentOutput = 0.0f;
        if (this.burnTime > 0) {
            --this.burnTime;
            this.currentOutput = 1.0f;
            this.addEnergy(1.0f);
        }
        if (this.burnTime == 0 && this.tile.isRedstonePowered) {
            this.burnTime = this.totalBurnTime = this.getItemBurnTime(this.tile.a(0));
            if (this.burnTime > 0) {
                this.tile.a(0, Utils.consumeItem(this.tile.a(0)));
            }
        }
    }

    @Override
    public int getScaledBurnTime(int i) {
        return (int)((float)this.burnTime / (float)this.totalBurnTime * (float)i);
    }

    private int getItemBurnTime(ur itemstack) {
        if (itemstack == null) {
            return 0;
        }
        return anr.a((ur)itemstack);
    }

    @Override
    public void readFromNBT(bq nbttagcompound) {
        this.burnTime = nbttagcompound.e("burnTime");
        this.totalBurnTime = nbttagcompound.e("totalBurnTime");
        if (nbttagcompound.b("itemInInventory")) {
            bq cpt = nbttagcompound.l("itemInInventory");
            this.itemInInventory = ur.a((bq)cpt);
        }
    }

    @Override
    public void writeToNBT(bq nbttagcompound) {
        nbttagcompound.a("burnTime", this.burnTime);
        nbttagcompound.a("totalBurnTime", this.totalBurnTime);
        if (this.itemInInventory != null) {
            bq cpt = new bq();
            this.itemInInventory.b(cpt);
            nbttagcompound.a("itemInInventory", (cd)cpt);
        }
    }

    @Override
    public void delete() {
        ur stack = this.tile.a(0);
        if (stack != null) {
            Utils.dropItems(this.tile.k, stack, this.tile.l, this.tile.m, this.tile.n);
        }
    }

    @Override
    public void getGUINetworkData(int i, int j) {
        switch (i) {
            case 0: {
                this.energy = j;
                break;
            }
            case 1: {
                this.currentOutput = j;
                break;
            }
            case 2: {
                this.burnTime = j;
                break;
            }
            case 3: {
                this.totalBurnTime = j;
            }
        }
    }

    @Override
    public void sendGUINetworkData(ContainerEngine containerEngine, rw iCrafting) {
        iCrafting.a((rq)containerEngine, 0, Math.round(this.energy));
        iCrafting.a((rq)containerEngine, 1, Math.round(this.currentOutput));
        iCrafting.a((rq)containerEngine, 2, this.burnTime);
        iCrafting.a((rq)containerEngine, 3, this.totalBurnTime);
    }

    @Override
    public int getHeat() {
        return Math.round(this.energy);
    }

    @Override
    public int getSizeInventory() {
        return 1;
    }

    @Override
    public ur getStackInSlot(int i) {
        return this.itemInInventory;
    }

    @Override
    public void setInventorySlotContents(int i, ur itemstack) {
        this.itemInInventory = itemstack;
    }

    @Override
    public ur decrStackSize(int slot, int amount) {
        if (this.itemInInventory != null) {
            if (this.itemInInventory.a <= 0) {
                this.itemInInventory = null;
                return null;
            }
            ur newStack = this.itemInInventory;
            if (amount >= newStack.a) {
                this.itemInInventory = null;
            } else {
                newStack = this.itemInInventory.a(amount);
            }
            return newStack;
        }
        return null;
    }

    @Override
    public ur getStackInSlotOnClosing(int var1) {
        if (this.itemInInventory == null) {
            return null;
        }
        ur toReturn = this.itemInInventory;
        this.itemInInventory = null;
        return toReturn;
    }

    @Override
    public ILiquidTank getTank(ForgeDirection direction, LiquidStack type) {
        return null;
    }
}

