/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.factory;

import buildcraft.BuildCraftCore;
import buildcraft.api.core.SafeTimeTracker;
import buildcraft.api.power.IPowerProvider;
import buildcraft.api.power.IPowerReceptor;
import buildcraft.api.power.PowerFramework;
import buildcraft.api.recipes.RefineryRecipe;
import buildcraft.core.IMachine;
import buildcraft.core.network.PacketPayload;
import buildcraft.core.network.PacketUpdate;
import buildcraft.core.proxy.CoreProxy;
import buildcraft.factory.TileMachine;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.ILiquidTank;
import net.minecraftforge.liquids.ITankContainer;
import net.minecraftforge.liquids.LiquidStack;
import net.minecraftforge.liquids.LiquidTank;

public class TileRefinery
extends TileMachine
implements ITankContainer,
IPowerReceptor,
la,
IMachine {
    private int[] filters = new int[2];
    private int[] filtersMeta = new int[2];
    public static int LIQUID_PER_SLOT = 4000;
    public LiquidTank ingredient1 = new LiquidTank(LIQUID_PER_SLOT);
    public LiquidTank ingredient2 = new LiquidTank(LIQUID_PER_SLOT);
    public LiquidTank result = new LiquidTank(LIQUID_PER_SLOT);
    public float animationSpeed = 1.0f;
    private int animationStage = 0;
    SafeTimeTracker time = new SafeTimeTracker();
    SafeTimeTracker updateNetworkTime = new SafeTimeTracker();
    IPowerProvider powerProvider = PowerFramework.currentFramework.createPowerProvider();
    private boolean isActive;

    public TileRefinery() {
        this.powerProvider.configure(20, 25, 100, 25, 1000);
        this.filters[0] = 0;
        this.filters[1] = 0;
        this.filtersMeta[0] = 0;
        this.filtersMeta[1] = 0;
    }

    public int k_() {
        return 0;
    }

    public ur a(int i) {
        return null;
    }

    public ur a(int i, int j) {
        return null;
    }

    public void a(int i, ur itemstack) {
    }

    public String b() {
        return null;
    }

    public int c() {
        return 0;
    }

    public boolean a_(qx entityplayer) {
        return this.k.q(this.l, this.m, this.n) == this;
    }

    public ur a_(int var1) {
        return null;
    }

    @Override
    public void setPowerProvider(IPowerProvider provider) {
        this.powerProvider = provider;
    }

    @Override
    public IPowerProvider getPowerProvider() {
        return this.powerProvider;
    }

    @Override
    public void doWork() {
    }

    @Override
    public void g() {
        if (CoreProxy.proxy.isRenderWorld(this.k)) {
            this.simpleAnimationIterate();
            return;
        }
        if (CoreProxy.proxy.isSimulating(this.k) && this.updateNetworkTime.markTimeIfDelay(this.k, 2 * BuildCraftCore.updateFactor)) {
            this.sendNetworkUpdate();
        }
        this.isActive = false;
        RefineryRecipe currentRecipe = null;
        currentRecipe = RefineryRecipe.findRefineryRecipe(this.ingredient1.getLiquid(), this.ingredient2.getLiquid());
        if (currentRecipe == null) {
            this.decreaseAnimation();
            return;
        }
        if (this.result.getLiquid() != null && this.result.getLiquid().amount != 0 && !this.result.getLiquid().isLiquidEqual(currentRecipe.result)) {
            this.decreaseAnimation();
            return;
        }
        if (this.result.fill(currentRecipe.result, false) != currentRecipe.result.amount) {
            this.decreaseAnimation();
            return;
        }
        if (!this.containsInput(currentRecipe.ingredient1) || !this.containsInput(currentRecipe.ingredient2)) {
            this.decreaseAnimation();
            return;
        }
        this.isActive = true;
        if (this.powerProvider.getEnergyStored() >= (float)currentRecipe.energy) {
            this.increaseAnimation();
        } else {
            this.decreaseAnimation();
        }
        if (!this.time.markTimeIfDelay(this.k, currentRecipe.delay)) {
            return;
        }
        float energyUsed = this.powerProvider.useEnergy(currentRecipe.energy, currentRecipe.energy, true);
        if (energyUsed != 0.0f && this.consumeInput(currentRecipe.ingredient1) && this.consumeInput(currentRecipe.ingredient2)) {
            this.result.fill(currentRecipe.result, true);
        }
    }

    private boolean containsInput(LiquidStack liquid) {
        if (liquid == null) {
            return true;
        }
        return this.ingredient1.getLiquid() != null && this.ingredient1.getLiquid().containsLiquid(liquid) || this.ingredient2.getLiquid() != null && this.ingredient2.getLiquid().containsLiquid(liquid);
    }

    private boolean consumeInput(LiquidStack liquid) {
        if (liquid == null) {
            return true;
        }
        if (this.ingredient1.getLiquid() != null && this.ingredient1.getLiquid().containsLiquid(liquid)) {
            this.ingredient1.drain(liquid.amount, true);
            return true;
        }
        if (this.ingredient2.getLiquid() != null && this.ingredient2.getLiquid().containsLiquid(liquid)) {
            this.ingredient2.drain(liquid.amount, true);
            return true;
        }
        return false;
    }

    @Override
    public boolean isActive() {
        return this.isActive;
    }

    @Override
    public boolean manageLiquids() {
        return true;
    }

    @Override
    public boolean manageSolids() {
        return true;
    }

    private LiquidStack readSlotNBT(bq nbttagcompound) {
        int liquidId = nbttagcompound.e("liquidId");
        int quantity = 0;
        int liquidMeta = 0;
        if (liquidId != 0) {
            quantity = nbttagcompound.e("quantity");
            liquidMeta = nbttagcompound.e("liquidMeta");
        } else {
            quantity = 0;
        }
        if (quantity > 0) {
            return new LiquidStack(liquidId, quantity, liquidMeta);
        }
        return null;
    }

    public void a(bq nbttagcompound) {
        super.a(nbttagcompound);
        if (nbttagcompound.b("slot1")) {
            this.ingredient1.setLiquid(this.readSlotNBT(nbttagcompound.l("slot1")));
            this.ingredient2.setLiquid(this.readSlotNBT(nbttagcompound.l("slot2")));
            this.result.setLiquid(this.readSlotNBT(nbttagcompound.l("result")));
        } else {
            if (nbttagcompound.b("ingredient1")) {
                this.ingredient1.setLiquid(LiquidStack.loadLiquidStackFromNBT((bq)nbttagcompound.l("ingredient1")));
            }
            if (nbttagcompound.b("ingredient2")) {
                this.ingredient2.setLiquid(LiquidStack.loadLiquidStackFromNBT((bq)nbttagcompound.l("ingredient2")));
            }
            if (nbttagcompound.b("result")) {
                this.result.setLiquid(LiquidStack.loadLiquidStackFromNBT((bq)nbttagcompound.l("result")));
            }
        }
        this.animationStage = nbttagcompound.e("animationStage");
        this.animationSpeed = nbttagcompound.g("animationSpeed");
        PowerFramework.currentFramework.loadPowerProvider(this, nbttagcompound);
        this.powerProvider.configure(20, 25, 100, 25, 1000);
        this.filters[0] = nbttagcompound.e("filters_0");
        this.filters[1] = nbttagcompound.e("filters_1");
        this.filtersMeta[0] = nbttagcompound.e("filtersMeta_0");
        this.filtersMeta[1] = nbttagcompound.e("filtersMeta_1");
    }

    public void b(bq nbttagcompound) {
        super.b(nbttagcompound);
        if (this.ingredient1.getLiquid() != null) {
            nbttagcompound.a("ingredient1", (cd)this.ingredient1.getLiquid().writeToNBT(new bq()));
        }
        if (this.ingredient2.getLiquid() != null) {
            nbttagcompound.a("ingredient2", (cd)this.ingredient2.getLiquid().writeToNBT(new bq()));
        }
        if (this.result.getLiquid() != null) {
            nbttagcompound.a("result", (cd)this.result.getLiquid().writeToNBT(new bq()));
        }
        nbttagcompound.a("animationStage", this.animationStage);
        nbttagcompound.a("animationSpeed", this.animationSpeed);
        PowerFramework.currentFramework.savePowerProvider(this, nbttagcompound);
        nbttagcompound.a("filters_0", this.filters[0]);
        nbttagcompound.a("filters_1", this.filters[1]);
        nbttagcompound.a("filtersMeta_0", this.filtersMeta[0]);
        nbttagcompound.a("filtersMeta_1", this.filtersMeta[1]);
    }

    public int getAnimationStage() {
        return this.animationStage;
    }

    public void simpleAnimationIterate() {
        if (this.animationSpeed > 1.0f) {
            this.animationStage = (int)((float)this.animationStage + this.animationSpeed);
            if (this.animationStage > 300) {
                this.animationStage = 100;
            }
        } else if (this.animationStage > 0) {
            --this.animationStage;
        }
    }

    public void increaseAnimation() {
        if (this.animationSpeed < 2.0f) {
            this.animationSpeed = 2.0f;
        } else if (this.animationSpeed <= 5.0f) {
            this.animationSpeed = (float)((double)this.animationSpeed + 0.1);
        }
        this.animationStage = (int)((float)this.animationStage + this.animationSpeed);
        if (this.animationStage > 300) {
            this.animationStage = 100;
        }
    }

    public void decreaseAnimation() {
        if (this.animationSpeed >= 1.0f) {
            this.animationSpeed = (float)((double)this.animationSpeed - 0.1);
            this.animationStage = (int)((float)this.animationStage + this.animationSpeed);
            if (this.animationStage > 300) {
                this.animationStage = 100;
            }
        } else if (this.animationStage > 0) {
            --this.animationStage;
        }
    }

    public void l_() {
    }

    public void f() {
    }

    public void setFilter(int number, int liquidId, int liquidMeta) {
        this.filters[number] = liquidId;
        this.filtersMeta[number] = liquidMeta;
    }

    public int getFilter(int number) {
        return this.filters[number];
    }

    public int getFilterMeta(int number) {
        return this.filtersMeta[number];
    }

    @Override
    public boolean allowActions() {
        return false;
    }

    public void getGUINetworkData(int i, int j) {
        switch (i) {
            case 0: {
                this.filters[0] = j;
                break;
            }
            case 1: {
                this.filters[1] = j;
                break;
            }
            case 2: {
                this.filtersMeta[0] = j;
                break;
            }
            case 3: {
                this.filtersMeta[1] = j;
            }
        }
    }

    public void sendGUINetworkData(rq container, rw iCrafting) {
        iCrafting.a(container, 0, this.filters[0]);
        iCrafting.a(container, 1, this.filters[1]);
        iCrafting.a(container, 2, this.filtersMeta[0]);
        iCrafting.a(container, 3, this.filtersMeta[1]);
    }

    public int fill(ForgeDirection from, LiquidStack resource, boolean doFill) {
        int used = 0;
        LiquidStack resourceUsing = resource.copy();
        if (this.filters[0] != 0 || this.filters[1] != 0) {
            if (this.filters[0] == resource.itemID && this.filtersMeta[0] == resource.itemMeta) {
                used += this.ingredient1.fill(resourceUsing, doFill);
            }
            resourceUsing.amount -= used;
            if (this.filters[1] == resource.itemID && this.filtersMeta[1] == resource.itemMeta) {
                used += this.ingredient2.fill(resourceUsing, doFill);
            }
        } else {
            resourceUsing.amount -= (used += this.ingredient1.fill(resourceUsing, doFill));
            used += this.ingredient2.fill(resourceUsing, doFill);
        }
        if (doFill && used > 0) {
            this.updateNetworkTime.markTime(this.k);
            this.sendNetworkUpdate();
        }
        return used;
    }

    public int fill(int tankIndex, LiquidStack resource, boolean doFill) {
        if (tankIndex == 0 && resource.itemID == this.filters[0] && resource.itemMeta == this.filtersMeta[0]) {
            return this.ingredient1.fill(resource, doFill);
        }
        if (tankIndex == 1 && resource.itemID == this.filters[1] && resource.itemMeta == this.filtersMeta[1]) {
            return this.ingredient2.fill(resource, doFill);
        }
        return 0;
    }

    public LiquidStack drain(ForgeDirection from, int maxEmpty, boolean doDrain) {
        return this.drain(2, maxEmpty, doDrain);
    }

    public LiquidStack drain(int tankIndex, int maxEmpty, boolean doDrain) {
        if (tankIndex == 2) {
            return this.result.drain(maxEmpty, doDrain);
        }
        return null;
    }

    public ILiquidTank[] getTanks(ForgeDirection direction) {
        return new ILiquidTank[]{this.ingredient1, this.ingredient2, this.result};
    }

    public ILiquidTank getTank(ForgeDirection direction, LiquidStack type) {
        ForgeDirection dir = ForgeDirection.getOrientation((int)this.k.h(this.l, this.m, this.n));
        switch (direction) {
            case NORTH: {
                switch (dir) {
                    case WEST: {
                        return this.ingredient2;
                    }
                    case EAST: {
                        return this.ingredient1;
                    }
                }
                return null;
            }
            case SOUTH: {
                switch (dir) {
                    case WEST: {
                        return this.ingredient1;
                    }
                    case EAST: {
                        return this.ingredient2;
                    }
                }
                return null;
            }
            case EAST: {
                switch (dir) {
                    case NORTH: {
                        return this.ingredient2;
                    }
                    case SOUTH: {
                        return this.ingredient1;
                    }
                }
                return null;
            }
            case WEST: {
                switch (dir) {
                    case NORTH: {
                        return this.ingredient1;
                    }
                    case SOUTH: {
                        return this.ingredient2;
                    }
                }
                return null;
            }
            case DOWN: {
                return this.result;
            }
        }
        return null;
    }

    @Override
    public PacketPayload getPacketPayload() {
        PacketPayload payload = new PacketPayload(9, 1, 0);
        if (this.ingredient1.getLiquid() != null) {
            payload.intPayload[0] = this.ingredient1.getLiquid().itemID;
            payload.intPayload[1] = this.ingredient1.getLiquid().itemMeta;
            payload.intPayload[2] = this.ingredient1.getLiquid().amount;
        } else {
            payload.intPayload[0] = 0;
            payload.intPayload[1] = 0;
            payload.intPayload[2] = 0;
        }
        if (this.ingredient2.getLiquid() != null) {
            payload.intPayload[3] = this.ingredient2.getLiquid().itemID;
            payload.intPayload[4] = this.ingredient2.getLiquid().itemMeta;
            payload.intPayload[5] = this.ingredient2.getLiquid().amount;
        } else {
            payload.intPayload[3] = 0;
            payload.intPayload[4] = 0;
            payload.intPayload[5] = 0;
        }
        if (this.result.getLiquid() != null) {
            payload.intPayload[6] = this.result.getLiquid().itemID;
            payload.intPayload[7] = this.result.getLiquid().itemMeta;
            payload.intPayload[8] = this.result.getLiquid().amount;
        } else {
            payload.intPayload[6] = 0;
            payload.intPayload[7] = 0;
            payload.intPayload[8] = 0;
        }
        payload.floatPayload[0] = this.animationSpeed;
        return payload;
    }

    @Override
    public void handleUpdatePacket(PacketUpdate packet) {
        if (packet.payload.intPayload[0] > 0) {
            this.ingredient1.setLiquid(new LiquidStack(packet.payload.intPayload[0], packet.payload.intPayload[2], packet.payload.intPayload[1]));
        } else {
            this.ingredient1.setLiquid(null);
        }
        if (packet.payload.intPayload[3] > 0) {
            this.ingredient2.setLiquid(new LiquidStack(packet.payload.intPayload[3], packet.payload.intPayload[5], packet.payload.intPayload[4]));
        } else {
            this.ingredient2.setLiquid(null);
        }
        if (packet.payload.intPayload[6] > 0) {
            this.result.setLiquid(new LiquidStack(packet.payload.intPayload[6], packet.payload.intPayload[8], packet.payload.intPayload[7]));
        } else {
            this.result.setLiquid(null);
        }
        this.animationSpeed = packet.payload.floatPayload[0];
    }
}

