/*
 * Decompiled with CFR 0.152.
 */
package railcraft.client.render.carts;

import org.lwjgl.opengl.GL11;
import railcraft.client.render.carts.CartModelManager;
import railcraft.client.render.carts.CartModelRenderer;
import railcraft.client.render.carts.RenderCart;
import railcraft.common.carts.EntityLocomotive;
import railcraft.common.util.misc.EnumColor;

public class LocomotiveRenderer
extends CartModelRenderer {
    @Override
    public void render(RenderCart renderer, py cart, float light) {
        EntityLocomotive loco = (EntityLocomotive)cart;
        String[] textures = loco.getLocomotiveTextures();
        axa model = CartModelManager.getModel(cart.getClass());
        for (int pass = 0; pass < 3; ++pass) {
            renderer.bindTexture(textures[pass]);
            int color = 0xFFFFFF;
            switch (pass) {
                case 0: {
                    color = EnumColor.fromId(loco.getPrimaryColor()).getHexColor();
                    break;
                }
                case 1: {
                    color = EnumColor.fromId(loco.getSecondaryColor()).getHexColor();
                }
            }
            float dim = light;
            float c1 = (float)(color >> 16 & 0xFF) / 255.0f;
            float c2 = (float)(color >> 8 & 0xFF) / 255.0f;
            float c3 = (float)(color & 0xFF) / 255.0f;
            GL11.glColor4f((float)(c1 * dim), (float)(c2 * dim), (float)(c3 * dim), (float)1.0f);
            model.a((lq)cart, 0.0f, 0.0f, -0.1f, 0.0f, 0.0f, 0.0625f);
        }
    }
}

