/*
 * Decompiled with CFR 0.152.
 */
package railcraft.client.render.carts;

import org.lwjgl.opengl.GL11;
import railcraft.client.render.RenderFakeBlock;
import railcraft.client.render.carts.RenderCart;
import railcraft.client.render.carts.SubRenderCart;
import railcraft.common.carts.MaintanceCartBase;
import railcraft.common.util.misc.FakeBlockRenderInfo;

public class SubRenderCartMaintance
extends SubRenderCart {
    private static final int LIGHT_ON_TEXTURE = 209;
    private static final int LIGHT_OFF_TEXTURE = 210;
    private static final int LIGHT_BASE_TEXTURE = 211;
    private final FakeBlockRenderInfo fakeBlock = new FakeBlockRenderInfo();
    private final FakeBlockRenderInfo lightBlock = new FakeBlockRenderInfo(0.375f, 0.375f, 0.375f, 0.625f, 0.625f, 0.625f);
    private final FakeBlockRenderInfo lightBaseBlock = new FakeBlockRenderInfo(0.3125f, 0.0f, 0.3125f, 0.6875f, 0.0625f, 0.6875f);
    private final RenderCart renderCart;

    public SubRenderCartMaintance(RenderCart render) {
        this.renderCart = render;
        this.lightBaseBlock.texture[0] = 211;
    }

    @Override
    public void render(py cart, float light, float time) {
        MaintanceCartBase maintCart = (MaintanceCartBase)cart;
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.0f, (float)0.3125f, (float)0.0f);
        GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glDisable((int)2896);
        this.renderCart.bindTexture("/railcraft/client/textures/railcraft.png");
        int x = (int)Math.floor(cart.t);
        int y = (int)Math.floor(cart.u);
        int z = (int)Math.floor(cart.v);
        this.fakeBlock.texture = maintCart.getTextureArray();
        RenderFakeBlock.renderBlockForEntity(this.fakeBlock, (ym)cart.p, x, y, z, true, true);
        RenderFakeBlock.renderBlock(this.lightBaseBlock, (ym)cart.p, -0.5, 0.5, -0.5, x, y + 1, z, true, true);
        if (maintCart.isBlinking()) {
            this.lightBlock.texture[0] = 209;
            this.lightBlock.light = 1.0f;
            this.lightBlock.brightness = 200;
        } else {
            this.lightBlock.texture[0] = 210;
            this.lightBlock.light = 1.0f;
            this.lightBlock.brightness = -1;
        }
        RenderFakeBlock.renderBlock(this.lightBlock, (ym)cart.p, -0.5, 0.125, -0.5, x, y + 1, z, this.lightBlock.brightness > 0, true);
        GL11.glEnable((int)2896);
        GL11.glPopMatrix();
    }
}

