/*
 * Decompiled with CFR 0.152.
 */
package railcraft.client.util.effects;

import cpw.mods.fml.client.FMLClientHandler;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Set;
import net.minecraft.client.Minecraft;
import railcraft.client.core.AuraKeyHandler;
import railcraft.client.particles.EntityChunkLoaderFX;
import railcraft.client.particles.EntitySteamFX;
import railcraft.client.particles.EntityTuningFX;
import railcraft.common.api.signals.SignalTools;
import railcraft.common.items.ItemGoggles;
import railcraft.common.util.effects.CommonProxy;
import railcraft.common.util.effects.EffectManager;
import railcraft.common.util.misc.Game;
import railcraft.common.util.network.PacketEffect;

public class ClientProxy
extends CommonProxy {
    public static final short TELEPORT_PARTICLES = 64;

    public ClientProxy() {
        SignalTools.effectManager = this;
    }

    private void doTeleport(DataInputStream data) throws IOException {
        double startX = data.readDouble();
        double startY = data.readDouble();
        double startZ = data.readDouble();
        double destX = data.readDouble();
        double destY = data.readDouble();
        double destZ = data.readDouble();
        for (int i = 0; i < 64; ++i) {
            double travel = (double)i / 63.0;
            float vX = (rand.nextFloat() - 0.5f) * 0.2f;
            float vY = (rand.nextFloat() - 0.5f) * 0.2f;
            float vZ = (rand.nextFloat() - 0.5f) * 0.2f;
            double pX = startX + (destX - startX) * travel + (rand.nextDouble() - 0.5) * 2.0;
            double pY = startY + (destY - startY) * travel + (rand.nextDouble() - 0.5) * 2.0;
            double pZ = startZ + (destZ - startZ) * travel + (rand.nextDouble() - 0.5) * 2.0;
            Game.getWorld().a("portal", pX, pY, pZ, (double)vX, (double)vY, (double)vZ);
        }
    }

    @Override
    public boolean isAnchorAuraActive() {
        if (ItemGoggles.areEnabled()) {
            ur goggles = ItemGoggles.getGoggles((qx)Minecraft.x().g);
            return ItemGoggles.getCurrentAura(goggles) == ItemGoggles.Aura.ANCHOR;
        }
        return AuraKeyHandler.isAnchorAuraEnabled();
    }

    @Override
    public boolean isTuningAuraActive() {
        if (ItemGoggles.areEnabled()) {
            ur goggles = ItemGoggles.getGoggles((qx)Minecraft.x().g);
            return ItemGoggles.getCurrentAura(goggles) == ItemGoggles.Aura.TUNING;
        }
        return AuraKeyHandler.isTuningAuraEnabled();
    }

    @Override
    public void tuningEffect(any start, any dest) {
        if (rand.nextInt(2) == 0) {
            double px2 = (double)start.l + 0.5 + rand.nextGaussian() * 0.1;
            double py2 = (double)start.m + 0.5 + rand.nextGaussian() * 0.1;
            double pz = (double)start.n + 0.5 + rand.nextGaussian() * 0.1;
            EntityTuningFX particle = new EntityTuningFX(start.k, px2, py2, pz, EffectManager.getEffectSource(dest));
            this.spawnParticle(particle);
        }
    }

    @Override
    public void handleEffectPacket(DataInputStream data) throws IOException {
        byte effectId = data.readByte();
        if (effectId < 0) {
            return;
        }
        PacketEffect.Effect effect = PacketEffect.Effect.values()[effectId];
        switch (effect) {
            case TELEPORT: {
                this.doTeleport(data);
            }
        }
    }

    @Override
    public void chunkLoaderEffect(yc world, Object source, Set chunks) {
        if (!this.isAnchorAuraActive()) {
            return;
        }
        EffectManager.IEffectSource es = EffectManager.getEffectSource(source);
        if (FMLClientHandler.instance().getClient().g.e(es.getX(), es.getY(), es.getZ()) > 25600.0) {
            return;
        }
        for (xv chunk : chunks) {
            int xCorner = chunk.a * 16;
            int zCorner = chunk.b * 16;
            double yCorner = es.getY() - 8.0;
            if (rand.nextInt(3) != 0) continue;
            double xParticle = (float)xCorner + rand.nextFloat() * 16.0f;
            double yParticle = yCorner + (double)(rand.nextFloat() * 16.0f);
            double zParticle = (float)zCorner + rand.nextFloat() * 16.0f;
            EntityChunkLoaderFX particle = new EntityChunkLoaderFX(world, xParticle, yParticle, zParticle, es);
            this.spawnParticle(particle);
        }
    }

    @Override
    public void steamEffect(yc world, Object source, double yOffset) {
        EffectManager.IEffectSource es = EffectManager.getEffectSource(source);
        double vx = rand.nextGaussian() * 0.1;
        double vy = rand.nextDouble() * 0.01;
        double vz = rand.nextGaussian() * 0.1;
        this.spawnParticle(new EntitySteamFX(world, es.getX(), es.getY() + yOffset, es.getZ(), vx, vy, vz));
    }

    @Override
    protected void spawnParticle(azq particle) {
        Minecraft mc = FMLClientHandler.instance().getClient();
        mc.i.a(particle);
    }
}

