/*
 * Decompiled with CFR 0.152.
 */
package railcraft.common.blocks.detector;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.List;
import railcraft.common.api.carts.CartTools;
import railcraft.common.blocks.detector.TileDetector;
import railcraft.common.gui.EnumGui;
import railcraft.common.gui.GuiHandler;
import railcraft.common.util.network.IGuiReturnHandler;

public class TileDetectorAnimal
extends TileDetector
implements IGuiReturnHandler {
    public boolean chicken = true;
    public boolean cow = true;
    public boolean pig = true;
    public boolean sheep = true;
    public boolean mooshroom = true;
    public boolean wolf = true;
    public boolean other = true;

    @Override
    public boolean testForCarts() {
        List carts = CartTools.getMinecartsOnAllSides(this.k, this.l, this.m, this.n, 0.2f);
        for (py cart : carts) {
            if (!(cart.n instanceof oy ? this.chicken : (cart.n instanceof oz ? this.cow : (cart.n instanceof pd ? this.pig : (cart.n instanceof pe ? this.sheep : (cart.n instanceof pb ? this.mooshroom : (cart.n instanceof pk ? this.wolf : cart.n instanceof ox && this.other))))))) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean blockActivated(qx player) {
        GuiHandler.openGui(EnumGui.DETECTOR_ANIMAL, player, this.k, this.l, this.m, this.n);
        return true;
    }

    @Override
    public void b(bq data) {
        super.b(data);
        data.a("chicken", this.chicken);
        data.a("cow", this.cow);
        data.a("pig", this.pig);
        data.a("sheep", this.sheep);
        data.a("mooshroom", this.mooshroom);
        data.a("wolf", this.wolf);
        data.a("other", this.other);
    }

    @Override
    public void a(bq data) {
        super.a(data);
        this.chicken = data.n("chicken");
        this.cow = data.n("cow");
        this.pig = data.n("pig");
        this.sheep = data.n("sheep");
        this.mooshroom = data.n("mooshroom");
        this.wolf = data.n("wolf");
        this.other = data.n("other");
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        this.writeGuiData(data);
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        this.readGuiData(data);
    }

    @Override
    public void writeGuiData(DataOutputStream data) throws IOException {
        byte bits = 0;
        bits = (byte)(bits | (this.chicken ? 1 : 0));
        bits = (byte)(bits | (this.cow ? 2 : 0));
        bits = (byte)(bits | (this.pig ? 4 : 0));
        bits = (byte)(bits | (this.sheep ? 8 : 0));
        bits = (byte)(bits | (this.mooshroom ? 16 : 0));
        bits = (byte)(bits | (this.wolf ? 32 : 0));
        bits = (byte)(bits | (this.other ? 64 : 0));
        data.writeByte(bits);
    }

    @Override
    public void readGuiData(DataInputStream data) throws IOException {
        byte bits = data.readByte();
        this.chicken = (bits & 1) != 0;
        this.cow = (bits & 2) != 0;
        this.pig = (bits & 4) != 0;
        this.sheep = (bits & 8) != 0;
        this.mooshroom = (bits & 0x10) != 0;
        this.wolf = (bits & 0x20) != 0;
        this.other = (bits & 0x40) != 0;
    }
}

