/*
 * Decompiled with CFR 0.152.
 */
package railcraft.common.blocks.machine.alpha;

import buildcraft.api.inventory.ISpecialInventory;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.ISidedInventory;
import net.minecraftforge.liquids.ILiquidTank;
import net.minecraftforge.liquids.ITankContainer;
import net.minecraftforge.liquids.LiquidStack;
import railcraft.common.api.crafting.ICokeOvenRecipe;
import railcraft.common.api.crafting.RailcraftCraftingManager;
import railcraft.common.blocks.machine.IEnumMachine;
import railcraft.common.blocks.machine.MultiBlockPattern;
import railcraft.common.blocks.machine.TileMultiBlock;
import railcraft.common.blocks.machine.TileMultiBlockOven;
import railcraft.common.blocks.machine.alpha.EnumMachineAlpha;
import railcraft.common.gui.EnumGui;
import railcraft.common.gui.GuiHandler;
import railcraft.common.liquids.LiquidManager;
import railcraft.common.liquids.TankManager;
import railcraft.common.liquids.tanks.FakeTank;
import railcraft.common.liquids.tanks.StandardTank;
import railcraft.common.plugins.buildcraft.triggers.INeedsFuel;
import railcraft.common.util.inventory.InvTools;
import railcraft.common.util.inventory.InventoryCopy;
import railcraft.common.util.inventory.InventoryMapper;
import railcraft.common.util.misc.Game;

public class TileCokeOven
extends TileMultiBlockOven
implements ITankContainer,
ISpecialInventory,
ISidedInventory,
INeedsFuel {
    private static final int COOK_STEP_LENGTH = 50;
    private static final int SLOT_INPUT = 0;
    private static final int SLOT_OUTPUT = 1;
    private static final int SLOT_LIQUID_OUTPUT = 2;
    private static final int SLOT_LIQUID_INPUT = 3;
    private static final int TANK_CAPACITY = 64000;
    private static final List patterns = new ArrayList();
    private int finishedAt;
    private int cookTimeTotal = 3600;
    private final TankManager tankManager = new TankManager();
    private final StandardTank tank;
    private la invInput = new InventoryMapper(this, 0, 1);
    private la invOutput = new InventoryMapper(this, 1, 2);

    public TileCokeOven() {
        super("gui.coke.oven", 4, patterns);
        this.tank = new StandardTank(64000, this);
        this.tankManager.addTank(this.tank);
    }

    @Override
    public IEnumMachine getMachineType() {
        return EnumMachineAlpha.COKE_OVEN;
    }

    public TankManager getTankManager() {
        TileCokeOven mBlock = (TileCokeOven)this.getMasterBlock();
        if (mBlock != null) {
            return mBlock.tankManager;
        }
        return null;
    }

    @Override
    public int getBlockTexture(int side) {
        if (this.getPatternMarker() == 'W' && this.isStructureValid()) {
            if (this.isBurning()) {
                return this.getMachineType().getTexture(7);
            }
            return this.getMachineType().getTexture(6);
        }
        return this.getMachineType().getTexture(0);
    }

    @Override
    public boolean blockActivated(qx player, int side) {
        if (this.isStructureValid() && LiquidManager.getInstance().handleRightClick(this, 0, player, false, true)) {
            return true;
        }
        if (LiquidManager.getInstance().isContainer(player.bJ.g())) {
            return true;
        }
        return super.blockActivated(player, side);
    }

    @Override
    public int getTotalCookTime() {
        TileCokeOven mBlock = (TileCokeOven)this.getMasterBlock();
        if (mBlock != null) {
            return mBlock.cookTimeTotal;
        }
        return 3600;
    }

    @Override
    public int getBurnProgressScaled(int i) {
        return (this.getTotalCookTime() - this.getCookTime()) * i / this.getTotalCookTime();
    }

    @Override
    public boolean needsFuel() {
        ur fuel = this.a(0);
        return fuel == null || fuel.a < 8;
    }

    @Override
    public void g() {
        super.g();
        if (Game.isHost(this.getWorld()) && this.isMaster()) {
            ur bottomSlot;
            ur topSlot;
            ur input;
            if (this.update > this.finishedAt + 50 + 5 && this.cookTime <= 0) {
                this.setCooking(false);
            }
            if ((input = this.a(0)) != null && input.a > 0 && !InvTools.isSynthetic(input)) {
                if (this.update % 50 == 0) {
                    ur output = this.a(1);
                    ICokeOvenRecipe recipe = RailcraftCraftingManager.cokeOven.getRecipe(input);
                    if (recipe != null) {
                        if ((output == null || output.a(recipe.getOutput()) && output.a + recipe.getOutput().a <= output.d()) && this.tank.fill(recipe.getLiquidOutput(), false) >= recipe.getLiquidOutput().amount) {
                            this.cookTimeTotal = recipe.getCookTime();
                            this.cookTime += 50;
                            this.setCooking(true);
                            if (this.cookTime >= recipe.getCookTime()) {
                                this.cookTime = 0;
                                this.finishedAt = this.update;
                                this.a(0, 1);
                                if (output == null) {
                                    this.a(1, recipe.getOutput());
                                } else {
                                    output.a += recipe.getOutput().a;
                                }
                                this.tank.fill(recipe.getLiquidOutput(), true);
                                this.sendUpdateToClient();
                            }
                        } else {
                            this.cookTime = 0;
                            this.setCooking(false);
                        }
                    } else {
                        this.cookTime = 0;
                        this.setCooking(false);
                        this.a(0, null);
                        this.dropItem(input);
                    }
                }
            } else {
                this.cookTime = 0;
                this.setCooking(false);
            }
            if ((topSlot = this.a(3)) != null && !LiquidManager.getInstance().isContainer(topSlot)) {
                this.a(3, null);
                this.dropItem(topSlot);
            }
            if ((bottomSlot = this.a(2)) != null && !LiquidManager.getInstance().isContainer(bottomSlot)) {
                this.a(2, null);
                this.dropItem(bottomSlot);
            }
            if (this.update % 8 == 0) {
                LiquidManager.getInstance().processContainers(this.tank, this, 3, 2, false, true);
            }
        }
    }

    public int getStartInventorySide(ForgeDirection side) {
        switch (side) {
            case UP: {
                return 0;
            }
            case DOWN: {
                return 3;
            }
        }
        return 1;
    }

    public int getSizeInventorySide(ForgeDirection side) {
        switch (side) {
            case UP: {
                return 1;
            }
            case DOWN: {
                return 1;
            }
        }
        return 2;
    }

    @Override
    public boolean openGui(qx player) {
        TileMultiBlock masterBlock = this.getMasterBlock();
        if (masterBlock != null && this.isStructureValid()) {
            GuiHandler.openGui(EnumGui.COKE_OVEN, player, this.k, masterBlock.l, masterBlock.m, masterBlock.n);
            return true;
        }
        return false;
    }

    @Override
    public void a(bq data) {
        super.a(data);
        if (data.b("tank")) {
            LiquidStack liquid = new LiquidStack(0, 0, 0);
            liquid.readFromNBT(data.l("tank"));
            this.tank.setLiquid(liquid);
        } else {
            this.tankManager.readTanksFromNBT(data);
        }
    }

    @Override
    public void b(bq data) {
        super.b(data);
        this.tankManager.writeTanksToNBT(data);
    }

    public int fill(ForgeDirection from, LiquidStack resource, boolean doFill) {
        return this.fill(0, resource, doFill);
    }

    public int fill(int tankIndex, LiquidStack resource, boolean doFill) {
        return 0;
    }

    public LiquidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.drain(0, maxDrain, doDrain);
    }

    public LiquidStack drain(int tankIndex, int maxDrain, boolean doDrain) {
        if (tankIndex != 0) {
            return null;
        }
        TankManager tMan = this.getTankManager();
        if (tMan != null) {
            return tMan.drain(tankIndex, maxDrain, doDrain);
        }
        return null;
    }

    public ILiquidTank[] getTanks(ForgeDirection dir) {
        TankManager tMan = this.getTankManager();
        if (tMan != null) {
            return tMan.getTanks();
        }
        return FakeTank.ARRAY;
    }

    @Override
    public int addItem(ur stack, boolean doAdd, ForgeDirection from) {
        TileCokeOven mBlock = (TileCokeOven)this.getMasterBlock();
        if (mBlock != null) {
            if (stack == null) {
                return 0;
            }
            if (LiquidManager.getInstance().isEmptyContainer(stack)) {
                ur ret;
                Object slot = new InventoryMapper(mBlock, 3, 1);
                if (!doAdd) {
                    slot = new InventoryCopy((la)slot);
                }
                if ((ret = InvTools.moveItemStack(stack.l(), slot)) != null && stack.a != ret.a) {
                    return stack.a - ret.a;
                }
                if (ret == null) {
                    return stack.a;
                }
            }
            if (InvTools.isSynthetic(stack)) {
                return 0;
            }
            if (RailcraftCraftingManager.cokeOven.getRecipe(stack) != null) {
                ur remainder;
                la inv = mBlock.invInput;
                if (!doAdd) {
                    inv = new InventoryCopy(inv);
                }
                if ((remainder = InvTools.moveItemStack(stack, inv)) == null) {
                    return stack.a;
                }
                return stack.a - remainder.a;
            }
            return 0;
        }
        return 0;
    }

    @Override
    public ur[] extractItem(boolean doRemove, ForgeDirection from, int maxItemCount) {
        TileCokeOven mBlock = (TileCokeOven)this.getMasterBlock();
        if (mBlock != null) {
            la inv = mBlock.invOutput;
            if (!doRemove) {
                inv = new InventoryCopy(inv);
            }
            return InvTools.removeItems(inv, maxItemCount);
        }
        return new ur[0];
    }

    public ILiquidTank getTank(ForgeDirection direction, LiquidStack type) {
        TankManager tMan = this.getTankManager();
        if (tMan != null) {
            return tMan.getTank(0);
        }
        return FakeTank.INSTANCE;
    }

    static {
        char[][][] map = new char[][][]{new char[][]{{'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O'}}, new char[][]{{'O', 'O', 'O', 'O', 'O'}, {'O', 'B', 'B', 'B', 'O'}, {'O', 'B', 'B', 'B', 'O'}, {'O', 'B', 'B', 'B', 'O'}, {'O', 'O', 'O', 'O', 'O'}}, new char[][]{{'O', 'O', 'O', 'O', 'O'}, {'O', 'B', 'W', 'B', 'O'}, {'O', 'W', 'A', 'W', 'O'}, {'O', 'B', 'W', 'B', 'O'}, {'O', 'O', 'O', 'O', 'O'}}, new char[][]{{'O', 'O', 'O', 'O', 'O'}, {'O', 'B', 'B', 'B', 'O'}, {'O', 'B', 'B', 'B', 'O'}, {'O', 'B', 'B', 'B', 'O'}, {'O', 'O', 'O', 'O', 'O'}}, new char[][]{{'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O'}}};
        patterns.add(new MultiBlockPattern(map));
    }
}

