/*
 * Decompiled with CFR 0.152.
 */
package railcraft.common.blocks.machine.beta;

import buildcraft.api.inventory.ISpecialInventory;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.ILiquidTank;
import net.minecraftforge.liquids.ITankContainer;
import net.minecraftforge.liquids.LiquidStack;
import railcraft.common.blocks.machine.MultiBlockPattern;
import railcraft.common.blocks.machine.beta.ISteamUser;
import railcraft.common.blocks.machine.beta.TileBoiler;
import railcraft.common.gui.indicator.IIndicatorController;
import railcraft.common.gui.util.ToolTip;
import railcraft.common.liquids.LiquidItems;
import railcraft.common.liquids.LiquidManager;
import railcraft.common.liquids.TankManager;
import railcraft.common.liquids.TankWrapper;
import railcraft.common.liquids.tanks.FakeTank;
import railcraft.common.plugins.buildcraft.triggers.ITemperature;
import railcraft.common.util.inventory.InvTools;
import railcraft.common.util.inventory.InventoryMapper;
import railcraft.common.util.inventory.StandaloneInventory;
import railcraft.common.util.misc.Game;
import railcraft.common.util.misc.MiscTools;

public abstract class TileBoilerFirebox
extends TileBoiler
implements la,
ISpecialInventory,
ITemperature {
    public static final int SLOT_LIQUID_INPUT = 0;
    public static final int SLOT_LIQUID_OUTPUT = 1;
    public float heat = 20.0f;
    private byte burnCycle;
    public float burnTime;
    private boolean burning = false;
    public float currentItemBurnTime;
    private boolean wasLit;
    private byte prevPattern;
    protected final StandaloneInventory inventory;
    protected la invWaterInput = new InventoryMapper(this, 0, 1);
    protected la invWaterOutput = new InventoryMapper(this, 1, 1);
    private IIndicatorController heatIndicator = new HeatIndicator();

    public IIndicatorController getHeatIndicator() {
        return this.heatIndicator;
    }

    protected TileBoilerFirebox(int invSize) {
        this.inventory = new StandaloneInventory(invSize, this);
    }

    @Override
    public int getBlockTexture(int side) {
        int texture = this.getMachineType().getTexture(side);
        if (side != 0 && side != 1 && this.isBurning()) {
            ++texture;
        }
        return texture;
    }

    @Override
    protected void onPatternLock(MultiBlockPattern pattern) {
        int capacity = this.getNumTanks() * 1000;
        this.tankManager.setCapacity(1, capacity * this.getSteamCapacityPerTank());
        this.tankManager.setCapacity(0, capacity * 4);
        byte newPattern = this.getPatternIndex();
        if (newPattern != this.prevPattern) {
            this.heat = 0.0f;
        }
        this.prevPattern = newPattern;
    }

    public int getBurnProgressScaled(int i) {
        if (!this.isBurning()) {
            return 0;
        }
        int scale = (int)(this.burnTime / this.currentItemBurnTime * (float)i);
        scale = Math.max(0, scale);
        scale = Math.min(i, scale);
        return scale;
    }

    public boolean isBurning() {
        TileBoilerFirebox mBlock = (TileBoilerFirebox)this.getMasterBlock();
        if (mBlock == null) {
            return false;
        }
        return mBlock.burning;
    }

    protected void updateLighting() {
        boolean b = this.isBurning();
        if (this.wasLit != b) {
            this.wasLit = b;
            this.k.c(yo.b, this.l, this.m, this.n);
            this.markBlockForUpdate();
        }
    }

    @Override
    public int getLightValue() {
        if (this.isStructureValid() && this.isBurning()) {
            return 13;
        }
        return 0;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void randomDisplayTick(Random random) {
        if (this.isStructureValid()) {
            this.updateLighting();
            if (this.isBurning() && random.nextInt(100) < 20) {
                float f = (float)this.l + 0.5f;
                float f1 = (float)this.m + 0.4375f + random.nextFloat() * 3.0f / 16.0f;
                float f2 = (float)this.n + 0.5f;
                float f3 = 0.52f;
                float f4 = random.nextFloat() * 0.6f - 0.3f;
                this.k.a("flame", (double)(f - f3), (double)f1, (double)(f2 + f4), 0.0, 0.0, 0.0);
                this.k.a("flame", (double)(f + f3), (double)f1, (double)(f2 + f4), 0.0, 0.0, 0.0);
                this.k.a("flame", (double)(f + f4), (double)f1, (double)(f2 - f3), 0.0, 0.0, 0.0);
                this.k.a("flame", (double)(f + f4), (double)f1, (double)(f2 + f3), 0.0, 0.0, 0.0);
            }
        }
    }

    @Override
    public ITankContainer getOutputOnSide(ForgeDirection side) {
        any tile = MiscTools.getBlockTileEntityOnSide(this.k, this.l, this.m, this.n, side);
        if (tile instanceof ISteamUser) {
            return (ITankContainer)tile;
        }
        return null;
    }

    @Override
    public void g() {
        super.g();
        if (Game.isNotHost(this.getWorld())) {
            return;
        }
        if (this.isMaster) {
            this.process();
            int numTanks = this.getNumTanks();
            this.burnCycle = (byte)(this.burnCycle + 1);
            int ticks = this.getTicksPerConversion();
            if (this.burnCycle >= ticks) {
                int waterCost;
                LiquidStack water;
                boolean addedFuel;
                this.burnCycle = 0;
                float fuelNeeded = this.getFuelPerConversion(numTanks) * (float)numTanks;
                while (this.burnTime < fuelNeeded && (addedFuel = this.addFuel())) {
                }
                boolean wasBurning = this.burning;
                if (this.burnTime < fuelNeeded) {
                    this.burning = false;
                } else {
                    this.burnTime -= fuelNeeded;
                    this.burning = true;
                }
                if (this.burning != wasBurning) {
                    this.sendUpdateToClient();
                }
                if (this.heat >= 100.0f && (water = this.tankManager.drain(0, waterCost = numTanks, false)) != null) {
                    waterCost = Math.min(waterCost, water.amount);
                    this.tankManager.drain(0, waterCost, true);
                    LiquidStack steam = LiquidItems.getSteamLiquid(160 * waterCost);
                    this.tankManager.fill(1, steam, true);
                }
            }
            if (this.isBurning()) {
                this.increaseHeat(numTanks);
            } else {
                this.reduceHeat(numTanks);
            }
            if (this.update % 8 == 0) {
                this.processBuckets();
            }
        }
    }

    private boolean addFuel() {
        float fuel = this.getMoreFuel();
        this.burnTime += fuel;
        this.currentItemBurnTime = this.burnTime;
        return fuel > 0.0f;
    }

    protected abstract void process();

    protected abstract float getMoreFuel();

    protected void processBuckets() {
        LiquidManager.getInstance().processContainers(this, 0, this.inventory, 0, 1, true, false);
    }

    public float getFuelPerConversion(int numTanks) {
        float fuel = 6.4f - (float)numTanks * 0.08f;
        fuel += fuel * (8.0f - 8.0f * this.getHeatLevel());
        return fuel;
    }

    public float getHeatLevel() {
        return this.heat / this.getMaxHeat();
    }

    private void increaseHeat(int numTanks) {
        float heatLevel = this.getHeatLevel();
        float change = 0.05f;
        if (heatLevel < 0.25f) {
            change += 0.05f;
        }
        if (heatLevel < 0.5f) {
            change += 0.05f;
        }
        if (heatLevel < 0.75f) {
            change += 0.05f;
        }
        this.heat += (change /= (float)numTanks);
        this.heat = Math.min(this.heat, this.getMaxHeat());
    }

    private void reduceHeat(int numTanks) {
        float heatLevel = this.getHeatLevel();
        float change = 0.05f;
        if (heatLevel > 0.25f) {
            change += 0.05f;
        }
        if (heatLevel > 0.5f) {
            change += 0.05f;
        }
        if (heatLevel > 0.75f) {
            change += 0.05f;
        }
        this.heat -= (change /= (float)numTanks);
        this.heat = Math.max(this.heat, 20.0f);
    }

    @Override
    protected void onMasterReset() {
        super.onMasterReset();
        InvTools.dropInventory(this.inventory, this.k, this.l, this.m, this.n);
        this.tankManager.getTank(1).setLiquid(null);
    }

    @Override
    public void b(bq data) {
        super.b(data);
        this.tankManager.writeTanksToNBT(data);
        this.inventory.writeToNBT("inv", data);
        data.a("heat", this.heat);
        data.a("burnTime", this.burnTime);
        data.a("currentItemBurnTime", this.currentItemBurnTime);
        data.a("prevPattern", this.prevPattern);
    }

    @Override
    public void a(bq data) {
        super.a(data);
        this.tankManager.readTanksFromNBT(data);
        this.inventory.readFromNBT("inv", data);
        this.heat = data.g("heat");
        this.burnTime = data.g("burnTime");
        this.currentItemBurnTime = data.g("currentItemBurnTime");
        this.prevPattern = data.c("prevPattern");
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        this.tankManager.writePacketData(data);
        data.writeBoolean(this.burning);
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        this.tankManager.readPacketData(data);
        this.burning = data.readBoolean();
    }

    public ur a(int i, int j) {
        TileBoilerFirebox mBlock = (TileBoilerFirebox)this.getMasterBlock();
        if (mBlock != null) {
            return mBlock.inventory.a(i, j);
        }
        return null;
    }

    public ur a(int i) {
        TileBoilerFirebox mBlock = (TileBoilerFirebox)this.getMasterBlock();
        if (mBlock != null) {
            return mBlock.inventory.a(i);
        }
        return null;
    }

    public void a(int i, ur itemstack) {
        TileBoilerFirebox mBlock = (TileBoilerFirebox)this.getMasterBlock();
        if (mBlock != null) {
            mBlock.inventory.a(i, itemstack);
        }
    }

    public void l_() {
    }

    public void f() {
    }

    public int c() {
        return 64;
    }

    public int k_() {
        return this.inventory.k_();
    }

    public ur a_(int var1) {
        return null;
    }

    protected boolean handleClick(qx player) {
        return LiquidManager.getInstance().handleRightClick(this, 0, player, true, false);
    }

    @Override
    public int fill(ForgeDirection from, LiquidStack resource, boolean doFill) {
        return this.fill(0, resource, doFill);
    }

    @Override
    public float getTemperature() {
        TileBoilerFirebox mBlock = (TileBoilerFirebox)this.getMasterBlock();
        if (mBlock != null) {
            return mBlock.heat;
        }
        return 20.0f;
    }

    public ILiquidTank getTank(ForgeDirection side, LiquidStack type) {
        TankManager tMan = this.getTankManager();
        if (tMan != null) {
            return new WaterTankWrapper((ILiquidTank)tMan.getTank(0));
        }
        return FakeTank.INSTANCE;
    }

    protected class WaterTankWrapper
    extends TankWrapper {
        public WaterTankWrapper(ILiquidTank tank) {
            super(tank);
        }

        @Override
        public int fill(LiquidStack resource, boolean doFill) {
            LiquidStack water;
            if (resource == null) {
                return 0;
            }
            TileBoilerFirebox mBlock = (TileBoilerFirebox)TileBoilerFirebox.this.getMasterBlock();
            if (mBlock != null && mBlock.heat >= 300.0f && ((water = this.tank.getLiquid()) == null || water.amount <= 0)) {
                TileBoilerFirebox.this.explode();
            }
            return this.tank.fill(resource, doFill);
        }
    }

    private class HeatIndicator
    implements IIndicatorController {
        List tips = new ArrayList();
        ToolTip tip = new ToolTip();

        private HeatIndicator() {
            this.tips.add(this.tip);
        }

        @Override
        public List getToolTip() {
            this.tip.text = String.format("%.0f\u00b0C", Float.valueOf(TileBoilerFirebox.this.heat));
            return this.tips;
        }

        @Override
        public int getScaledLevel(int size) {
            return (int)((TileBoilerFirebox.this.heat - 20.0f) * (float)size / (TileBoilerFirebox.this.getMaxHeat() - 20.0f));
        }
    }
}

