/*
 * Decompiled with CFR 0.152.
 */
package railcraft.common.blocks.machine.beta;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraftforge.liquids.ILiquidTank;
import railcraft.common.blocks.machine.ITankTile;
import railcraft.common.blocks.machine.MultiBlockPattern;
import railcraft.common.blocks.machine.TileMultiBlock;
import railcraft.common.blocks.machine.beta.EnumMachineBeta;
import railcraft.common.core.RailcraftConfig;
import railcraft.common.gui.EnumGui;
import railcraft.common.gui.GuiHandler;
import railcraft.common.gui.slots.SlotLiquidContainer;
import railcraft.common.liquids.LiquidManager;
import railcraft.common.liquids.TankManager;
import railcraft.common.liquids.tanks.StandardTank;
import railcraft.common.util.inventory.StandaloneInventory;
import railcraft.common.util.misc.Game;

public abstract class TileTankIron
extends TileMultiBlock
implements ITankTile {
    private static final int CAPACITY_PER_BLOCK = 16000;
    protected static final int SLOT_INPUT = 0;
    protected static final int SLOT_OUTPUT = 1;
    protected final TankManager tankManager = new TankManager();
    private static final List patterns = TileTankIron.buildPatterns();
    private static final Set tankBlocks = new HashSet();
    private final StandaloneInventory inv = new StandaloneInventory(2, "gui.tank.iron", this);

    protected TileTankIron() {
        super(patterns);
        StandardTank tank = new StandardTank(64000, this);
        this.tankManager.addTank(tank);
    }

    @Override
    public la getInventory() {
        return this.inv;
    }

    @Override
    public sr getInputSlot(la inv, int slotNum, int x, int y) {
        return new SlotLiquidContainer(inv, slotNum, x, y);
    }

    @Override
    public float getResistance(lq exploder) {
        return 15.0f;
    }

    @Override
    protected int getMaxRecursionDepth() {
        return 500;
    }

    @Override
    protected boolean isStructureTile(any tile) {
        return tile instanceof TileTankIron;
    }

    @Override
    public boolean blockActivated(qx player, int side) {
        ur current = player.bS();
        if (Game.isHost(this.k) ? this.isStructureValid() && LiquidManager.getInstance().handleRightClick(this.getTankManager(), 0, player, true, true) : LiquidManager.getInstance().isContainer(current)) {
            return true;
        }
        if (current != null && current.c == up.aE.cj) {
            return true;
        }
        return super.blockActivated(player, side);
    }

    @Override
    public boolean openGui(qx player) {
        TileMultiBlock mBlock = this.getMasterBlock();
        if (mBlock != null) {
            GuiHandler.openGui(EnumGui.TANK, player, this.k, mBlock.l, mBlock.m, mBlock.n);
            return true;
        }
        return false;
    }

    @Override
    public TankManager getTankManager() {
        TileTankIron mBlock = (TileTankIron)this.getMasterBlock();
        if (mBlock != null) {
            return mBlock.tankManager;
        }
        return null;
    }

    @Override
    public ILiquidTank getTank() {
        TileTankIron mBlock = (TileTankIron)this.getMasterBlock();
        if (mBlock != null) {
            return mBlock.tankManager.getTank(0);
        }
        return null;
    }

    @Override
    protected void onPatternLock(MultiBlockPattern pattern) {
        if (this.isMaster) {
            int capacity = (pattern.getPatternWidthX() - 2) * (pattern.getPatternHeight() - pattern.getMasterOffsetY() * 2) * (pattern.getPatternWidthZ() - 2) * 16000;
            this.tankManager.setCapacity(0, capacity);
        } else {
            this.tankManager.getTank(0).setLiquid(null);
        }
    }

    @Override
    protected boolean isMapPositionValid(int x, int y, int z, char mapPos) {
        switch (mapPos) {
            case 'O': {
                int meta;
                int id = this.k.a(x, y, z);
                return id != this.getBlockId() || !tankBlocks.contains(meta = this.k.h(x, y, z));
            }
            case 'W': {
                int id = this.k.a(x, y, z);
                if (id != this.getBlockId()) {
                    return false;
                }
                int meta = this.k.h(x, y, z);
                return tankBlocks.contains(meta);
            }
            case 'B': {
                int id = this.k.a(x, y, z);
                if (id != this.getBlockId()) {
                    return false;
                }
                int meta = this.k.h(x, y, z);
                return meta == EnumMachineBeta.TANK_IRON_WALL.ordinal();
            }
            case 'M': 
            case 'T': {
                int id = this.k.a(x, y, z);
                if (id != this.getBlockId()) {
                    return false;
                }
                int meta = this.k.h(x, y, z);
                if (!tankBlocks.contains(meta)) {
                    return false;
                }
                any tile = this.k.q(x, y, z);
                if (!(tile instanceof TileMultiBlock)) {
                    this.k.r(x, y, z);
                    return true;
                }
                return !((TileMultiBlock)tile).isStructureValid();
            }
            case 'A': {
                return this.k.c(x, y, z);
            }
        }
        return true;
    }

    @Override
    public void g() {
        super.g();
        if (Game.isHost(this.k) && this.isMaster) {
            if (this.update % 8 == 0) {
                LiquidManager.getInstance().processContainers(this.tankManager.getTank(0), this.inv, 0, 1);
            }
            if (this.update % 128 == 0) {
                this.sendUpdateToClient();
            }
        }
    }

    @Override
    public void w_() {
        super.w_();
        this.tankManager.getTank(0).setLiquid(null);
    }

    @Override
    public void b(bq data) {
        super.b(data);
        this.tankManager.writeTanksToNBT(data);
        this.inv.writeToNBT("inv", data);
    }

    @Override
    public void a(bq data) {
        super.a(data);
        this.tankManager.readTanksFromNBT(data);
        this.inv.readFromNBT("inv", data);
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        this.tankManager.writePacketData(data);
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        this.tankManager.readPacketData(data);
    }

    private static List buildPatterns() {
        aoe entityCheck;
        char[][][] map;
        int i;
        ArrayList<MultiBlockPattern> pats = new ArrayList<MultiBlockPattern>();
        boolean client = FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT;
        int xOffset = 2;
        int yOffset = 0;
        int zOffset = 2;
        char[][] bottom = new char[][]{{'O', 'O', 'O', 'O', 'O'}, {'O', 'B', 'B', 'B', 'O'}, {'O', 'B', 'M', 'B', 'O'}, {'O', 'B', 'B', 'B', 'O'}, {'O', 'O', 'O', 'O', 'O'}};
        char[][] middle = new char[][]{{'O', 'O', 'O', 'O', 'O'}, {'O', 'B', 'W', 'B', 'O'}, {'O', 'W', 'A', 'W', 'O'}, {'O', 'B', 'W', 'B', 'O'}, {'O', 'O', 'O', 'O', 'O'}};
        char[][] top = new char[][]{{'O', 'O', 'O', 'O', 'O'}, {'O', 'B', 'B', 'B', 'O'}, {'O', 'B', 'T', 'B', 'O'}, {'O', 'B', 'B', 'B', 'O'}, {'O', 'O', 'O', 'O', 'O'}};
        char[][] border = new char[][]{{'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O'}};
        for (i = 4; i <= 8; ++i) {
            map = TileTankIron.buildMap(i, bottom, middle, top, border);
            entityCheck = aoe.a((double)0.0, (double)1.0, (double)0.0, (double)1.0, (double)(i - 1), (double)1.0);
            pats.add(TileTankIron.buildPattern(map, xOffset, yOffset, zOffset, entityCheck));
        }
        if (client || RailcraftConfig.getMaxTankSize() >= 5) {
            zOffset = 3;
            xOffset = 3;
            bottom = new char[][]{{'O', 'O', 'O', 'O', 'O', 'O', 'O'}, {'O', 'B', 'B', 'B', 'B', 'B', 'O'}, {'O', 'B', 'W', 'W', 'W', 'B', 'O'}, {'O', 'B', 'W', 'M', 'W', 'B', 'O'}, {'O', 'B', 'W', 'W', 'W', 'B', 'O'}, {'O', 'B', 'B', 'B', 'B', 'B', 'O'}, {'O', 'O', 'O', 'O', 'O', 'O', 'O'}};
            middle = new char[][]{{'O', 'O', 'O', 'O', 'O', 'O', 'O'}, {'O', 'B', 'W', 'W', 'W', 'B', 'O'}, {'O', 'W', 'A', 'A', 'A', 'W', 'O'}, {'O', 'W', 'A', 'A', 'A', 'W', 'O'}, {'O', 'W', 'A', 'A', 'A', 'W', 'O'}, {'O', 'B', 'W', 'W', 'W', 'B', 'O'}, {'O', 'O', 'O', 'O', 'O', 'O', 'O'}};
            top = new char[][]{{'O', 'O', 'O', 'O', 'O', 'O', 'O'}, {'O', 'B', 'B', 'B', 'B', 'B', 'O'}, {'O', 'B', 'W', 'W', 'W', 'B', 'O'}, {'O', 'B', 'W', 'T', 'W', 'B', 'O'}, {'O', 'B', 'W', 'W', 'W', 'B', 'O'}, {'O', 'B', 'B', 'B', 'B', 'B', 'O'}, {'O', 'O', 'O', 'O', 'O', 'O', 'O'}};
            border = new char[][]{{'O', 'O', 'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O', 'O', 'O'}};
            for (i = 4; i <= 8; ++i) {
                map = TileTankIron.buildMap(i, bottom, middle, top, border);
                entityCheck = aoe.a((double)-1.0, (double)1.0, (double)-1.0, (double)2.0, (double)(i - 1), (double)2.0);
                pats.add(TileTankIron.buildPattern(map, xOffset, yOffset, zOffset, entityCheck));
            }
        }
        if (client || RailcraftConfig.getMaxTankSize() >= 7) {
            zOffset = 4;
            xOffset = 4;
            bottom = new char[][]{{'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O'}, {'O', 'B', 'B', 'B', 'B', 'B', 'B', 'B', 'O'}, {'O', 'B', 'W', 'W', 'W', 'W', 'W', 'B', 'O'}, {'O', 'B', 'W', 'W', 'W', 'W', 'W', 'B', 'O'}, {'O', 'B', 'W', 'W', 'M', 'W', 'W', 'B', 'O'}, {'O', 'B', 'W', 'W', 'W', 'W', 'W', 'B', 'O'}, {'O', 'B', 'W', 'W', 'W', 'W', 'W', 'B', 'O'}, {'O', 'B', 'B', 'B', 'B', 'B', 'B', 'B', 'O'}, {'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O'}};
            middle = new char[][]{{'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O'}, {'O', 'B', 'W', 'W', 'W', 'W', 'W', 'B', 'O'}, {'O', 'W', 'A', 'A', 'A', 'A', 'A', 'W', 'O'}, {'O', 'W', 'A', 'A', 'A', 'A', 'A', 'W', 'O'}, {'O', 'W', 'A', 'A', 'A', 'A', 'A', 'W', 'O'}, {'O', 'W', 'A', 'A', 'A', 'A', 'A', 'W', 'O'}, {'O', 'W', 'A', 'A', 'A', 'A', 'A', 'W', 'O'}, {'O', 'B', 'W', 'W', 'W', 'W', 'W', 'B', 'O'}, {'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O'}};
            top = new char[][]{{'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O'}, {'O', 'B', 'B', 'B', 'B', 'B', 'B', 'B', 'O'}, {'O', 'B', 'W', 'W', 'W', 'W', 'W', 'B', 'O'}, {'O', 'B', 'W', 'W', 'W', 'W', 'W', 'B', 'O'}, {'O', 'B', 'W', 'W', 'T', 'W', 'W', 'B', 'O'}, {'O', 'B', 'W', 'W', 'W', 'W', 'W', 'B', 'O'}, {'O', 'B', 'W', 'W', 'W', 'W', 'W', 'B', 'O'}, {'O', 'B', 'B', 'B', 'B', 'B', 'B', 'B', 'O'}, {'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O'}};
            border = new char[][]{{'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O'}};
            for (i = 4; i <= 8; ++i) {
                map = TileTankIron.buildMap(i, bottom, middle, top, border);
                entityCheck = aoe.a((double)-2.0, (double)1.0, (double)-2.0, (double)3.0, (double)(i - 1), (double)3.0);
                pats.add(TileTankIron.buildPattern(map, xOffset, yOffset, zOffset, entityCheck));
            }
        }
        if (client || RailcraftConfig.getMaxTankSize() >= 9) {
            zOffset = 5;
            xOffset = 5;
            bottom = new char[][]{{'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O'}, {'O', 'B', 'B', 'B', 'B', 'B', 'B', 'B', 'B', 'B', 'O'}, {'O', 'B', 'W', 'W', 'W', 'W', 'W', 'W', 'W', 'B', 'O'}, {'O', 'B', 'W', 'W', 'W', 'W', 'W', 'W', 'W', 'B', 'O'}, {'O', 'B', 'W', 'W', 'W', 'W', 'W', 'W', 'W', 'B', 'O'}, {'O', 'B', 'W', 'W', 'W', 'M', 'W', 'W', 'W', 'B', 'O'}, {'O', 'B', 'W', 'W', 'W', 'W', 'W', 'W', 'W', 'B', 'O'}, {'O', 'B', 'W', 'W', 'W', 'W', 'W', 'W', 'W', 'B', 'O'}, {'O', 'B', 'W', 'W', 'W', 'W', 'W', 'W', 'W', 'B', 'O'}, {'O', 'B', 'B', 'B', 'B', 'B', 'B', 'B', 'B', 'B', 'O'}, {'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O'}};
            middle = new char[][]{{'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O'}, {'O', 'B', 'W', 'W', 'W', 'W', 'W', 'W', 'W', 'B', 'O'}, {'O', 'W', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'W', 'O'}, {'O', 'W', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'W', 'O'}, {'O', 'W', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'W', 'O'}, {'O', 'W', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'W', 'O'}, {'O', 'W', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'W', 'O'}, {'O', 'W', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'W', 'O'}, {'O', 'W', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'W', 'O'}, {'O', 'B', 'W', 'W', 'W', 'W', 'W', 'W', 'W', 'B', 'O'}, {'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O'}};
            top = new char[][]{{'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O'}, {'O', 'B', 'B', 'B', 'B', 'B', 'B', 'B', 'B', 'B', 'O'}, {'O', 'B', 'W', 'W', 'W', 'W', 'W', 'W', 'W', 'B', 'O'}, {'O', 'B', 'W', 'W', 'W', 'W', 'W', 'W', 'W', 'B', 'O'}, {'O', 'B', 'W', 'W', 'W', 'W', 'W', 'W', 'W', 'B', 'O'}, {'O', 'B', 'W', 'W', 'W', 'T', 'W', 'W', 'W', 'B', 'O'}, {'O', 'B', 'W', 'W', 'W', 'W', 'W', 'W', 'W', 'B', 'O'}, {'O', 'B', 'W', 'W', 'W', 'W', 'W', 'W', 'W', 'B', 'O'}, {'O', 'B', 'W', 'W', 'W', 'W', 'W', 'W', 'W', 'B', 'O'}, {'O', 'B', 'B', 'B', 'B', 'B', 'B', 'B', 'B', 'B', 'O'}, {'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O'}};
            border = new char[][]{{'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O'}};
            for (i = 4; i <= 8; ++i) {
                map = TileTankIron.buildMap(i, bottom, middle, top, border);
                entityCheck = aoe.a((double)-3.0, (double)1.0, (double)-3.0, (double)4.0, (double)(i - 1), (double)4.0);
                pats.add(TileTankIron.buildPattern(map, xOffset, yOffset, zOffset, entityCheck));
            }
        }
        return pats;
    }

    private static MultiBlockPattern buildPattern(char[][][] map, int xOffset, int yOffset, int zOffset, aoe entityCheck) {
        if (!RailcraftConfig.allowTankStacking()) {
            entityCheck.d(0.0, 1.0, 0.0);
            yOffset = 1;
        }
        return new MultiBlockPattern(map, xOffset, yOffset, zOffset, entityCheck);
    }

    private static char[][][] buildMap(int height, char[][] bottom, char[][] mid, char[][] top, char[][] border) {
        char[][][] map;
        if (RailcraftConfig.allowTankStacking()) {
            map = new char[height][][];
            map[0] = bottom;
            map[height - 1] = top;
            for (int i = 1; i < height - 1; ++i) {
                map[i] = mid;
            }
        } else {
            map = new char[height + 2][][];
            map[0] = border;
            map[1] = bottom;
            map[height] = top;
            map[height + 1] = border;
            for (int i = 2; i < height; ++i) {
                map[i] = mid;
            }
        }
        return map;
    }

    static {
        tankBlocks.add(EnumMachineBeta.TANK_IRON_WALL.ordinal());
        tankBlocks.add(EnumMachineBeta.TANK_IRON_VALVE.ordinal());
        tankBlocks.add(EnumMachineBeta.TANK_IRON_GAUGE.ordinal());
    }
}

