/*
 * Decompiled with CFR 0.152.
 */
package railcraft.common.blocks.machine.gamma;

import buildcraft.api.inventory.ISpecialInventory;
import ic2.api.IWrenchable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraftforge.common.ForgeDirection;
import railcraft.common.api.carts.CartTools;
import railcraft.common.blocks.machine.IEnumMachine;
import railcraft.common.blocks.machine.gamma.EnumMachineGamma;
import railcraft.common.blocks.machine.gamma.TileLoaderItemBase;
import railcraft.common.gui.EnumGui;
import railcraft.common.gui.GuiHandler;
import railcraft.common.gui.slots.SlotOutput;
import railcraft.common.util.inventory.InvTools;
import railcraft.common.util.inventory.InventoryCopy;
import railcraft.common.util.inventory.ItemStackMap;
import railcraft.common.util.inventory.ItemStackSet;
import railcraft.common.util.misc.Game;
import railcraft.common.util.misc.MiscTools;

public class TileItemUnloader
extends TileLoaderItemBase
implements IWrenchable,
ISpecialInventory {
    private final la invBuffer;
    private final Map transferedItems = new ItemStackMap();
    private final Set checkedItems = new ItemStackSet();

    public TileItemUnloader() {
        this.setInventorySize(9);
        this.invBuffer = this.getInventory();
    }

    @Override
    public IEnumMachine getMachineType() {
        return EnumMachineGamma.ITEM_UNLOADER;
    }

    @Override
    public sr getBufferSlot(int id, int x, int y) {
        return new SlotOutput(this, id, x, y);
    }

    @Override
    public int getBlockTexture(int side) {
        return this.getMachineType().getTexture(side);
    }

    @Override
    public void g() {
        super.g();
        if (Game.isNotHost(this.getWorld())) {
            return;
        }
        this.emptyCart();
        this.clearInv();
    }

    private void emptyCart() {
        boolean movedItemCart = false;
        py cart = CartTools.getMinecartOnSide(this.k, this.l, this.m, this.n, 0.1f, this.getOrientation());
        if (cart == null) {
            this.setPowered(false);
            this.currentCart = null;
            return;
        }
        if ((cart.k_() == 0 || InvTools.isInventoryEmpty((la)cart)) && (CartTools.cartVelocityIsLessThan(cart, 0.02f) || cart.isPoweredCart())) {
            this.setPowered(true);
            return;
        }
        if (cart != this.currentCart) {
            this.setPowered(false);
            this.currentCart = cart;
            this.transferedItems.clear();
            this.cartSent();
        }
        if (this.isSendCart()) {
            if (CartTools.cartVelocityIsLessThan(cart, 0.02f)) {
                this.setPowered(true);
            }
            return;
        }
        ur minecartSlot1 = this.getCartFilters().a(0);
        ur minecartSlot2 = this.getCartFilters().a(1);
        if (!(minecartSlot1 == null && minecartSlot2 == null || CartTools.doesCartMatchFilter(minecartSlot1, cart) || CartTools.doesCartMatchFilter(minecartSlot2, cart))) {
            if (CartTools.cartVelocityIsLessThan(cart, 0.02f)) {
                this.setPowered(true);
            }
            return;
        }
        List chests = InvTools.getAdjacentInventories(this.k, this.l, this.m, this.n);
        chests.add(this.invBuffer);
        this.checkedItems.clear();
        block0 : switch (this.getMode()) {
            case TRANSFER: {
                ur moved;
                boolean hasFilter = false;
                for (ur filter : this.getItemFilters().getContents()) {
                    ur moved2;
                    if (filter == null || !this.checkedItems.add(filter)) continue;
                    hasFilter = true;
                    Short numMoved = (Short)this.transferedItems.get(filter);
                    if (numMoved == null) {
                        numMoved = 0;
                    }
                    if (numMoved >= InvTools.countItems((la)this.getItemFilters(), filter) || (moved2 = InvTools.moveOneItem((la)cart, chests, filter)) == null) continue;
                    movedItemCart = true;
                    Short s = numMoved;
                    Short s2 = numMoved = Short.valueOf((short)(numMoved + 1));
                    this.transferedItems.put(moved2, numMoved);
                    break;
                }
                if (hasFilter || (moved = InvTools.moveOneItem((la)cart, chests, new ur[0])) == null) break;
                movedItemCart = true;
                break;
            }
            case STOCK: {
                for (ur filter : this.getItemFilters().getContents()) {
                    ur moved;
                    if (filter == null || !this.checkedItems.add(filter)) continue;
                    int stocked = InvTools.countItems(chests, filter);
                    if (stocked >= InvTools.countItems((la)this.getItemFilters(), filter) || (moved = InvTools.moveOneItem((la)cart, chests, filter)) == null) continue;
                    movedItemCart = true;
                    break block0;
                }
                break;
            }
            case EXCESS: {
                for (ur filter : this.getItemFilters().getContents()) {
                    ur moved;
                    if (filter == null || !this.checkedItems.add(filter)) continue;
                    int stocked = InvTools.countItems((la)cart, filter);
                    if (stocked <= InvTools.countItems((la)this.getItemFilters(), filter) || (moved = InvTools.moveOneItem((la)cart, chests, filter)) == null) continue;
                    movedItemCart = true;
                    break;
                }
                if (movedItemCart) break;
                boolean bl = movedItemCart = InvTools.moveOneItemExcept((la)cart, chests, this.getItemFilters().getContents()) != null;
            }
        }
        if (!this.isPowered() && (CartTools.cartVelocityIsLessThan(cart, 0.02f) || cart.isPoweredCart())) {
            if (!movedItemCart && !this.cartShouldWait()) {
                this.setPowered(true);
            } else if (this.getMode() == TileLoaderItemBase.EnumItemMode.TRANSFER && this.isTranferComplete(this.getItemFilters().getContents())) {
                this.setPowered(true);
            } else if (this.getMode() == TileLoaderItemBase.EnumItemMode.STOCK && this.isStockComplete(chests, this.getItemFilters().getContents())) {
                this.setPowered(true);
            } else if (this.getMode() == TileLoaderItemBase.EnumItemMode.EXCESS && this.isExcessComplete(cart, this.getItemFilters().getContents())) {
                this.setPowered(true);
            } else if (!movedItemCart && InvTools.isInventoryEmpty((la)cart, MiscTools.getOppositeSide(this.getFacing()))) {
                this.setPowered(true);
            }
        }
    }

    private boolean isTranferComplete(ur[] filters) {
        this.checkedItems.clear();
        boolean hasFilter = false;
        for (ur filter : filters) {
            if (filter == null || !this.checkedItems.add(filter)) continue;
            hasFilter = true;
            Short numMoved = (Short)this.transferedItems.get(filter);
            if (numMoved != null && numMoved >= InvTools.countItems((la)this.getItemFilters(), filter)) continue;
            return false;
        }
        return hasFilter;
    }

    private boolean isStockComplete(List chests, ur[] filters) {
        this.checkedItems.clear();
        for (ur filter : filters) {
            if (filter == null || !this.checkedItems.add(filter)) continue;
            int stocked = InvTools.countItems(chests, filter);
            if (stocked >= InvTools.countItems((la)this.getItemFilters(), filter)) continue;
            return false;
        }
        return true;
    }

    private boolean isExcessComplete(py cart, ur[] filters) {
        this.checkedItems.clear();
        int max = 0;
        for (ur filter : filters) {
            if (filter == null || !this.checkedItems.add(filter)) continue;
            int stocked = InvTools.countItems((la)cart, filter);
            max += filter.a;
            if (stocked <= InvTools.countItems((la)this.getItemFilters(), filter)) continue;
            return false;
        }
        return InvTools.countItems((la)cart) <= max;
    }

    private void clearInv() {
        block1: {
            la inv;
            if (InvTools.isInventoryEmpty(this.invBuffer)) break block1;
            List chests = InvTools.getAdjacentInventories(this.k, this.l, this.m, this.n);
            Iterator i$ = chests.iterator();
            while (i$.hasNext() && ((inv = (la)i$.next()) instanceof TileItemUnloader || InvTools.moveOneItem(this.invBuffer, inv) == null)) {
            }
        }
    }

    @Override
    public boolean openGui(qx player) {
        GuiHandler.openGui(EnumGui.LOADER_ITEM, player, this.k, this.l, this.m, this.n);
        return true;
    }

    @Override
    public short getFacing() {
        return (short)this.getOrientation().ordinal();
    }

    public ForgeDirection getOrientation() {
        return ForgeDirection.UP;
    }

    @Override
    public int addItem(ur stack, boolean doAdd, ForgeDirection from) {
        return 0;
    }

    @Override
    public ur[] extractItem(boolean doRemove, ForgeDirection from, int maxItemCount) {
        la inv = this.invBuffer;
        if (!doRemove) {
            inv = new InventoryCopy(inv);
        }
        return InvTools.removeItems(inv, maxItemCount);
    }
}

