/*
 * Decompiled with CFR 0.152.
 */
package railcraft.common.blocks.machine.gamma;

import buildcraft.api.gates.IAction;
import ic2.api.IWrenchable;
import net.minecraftforge.common.ForgeDirection;
import railcraft.common.blocks.machine.TileMachineItem;
import railcraft.common.plugins.buildcraft.actions.EnumTriggerActions;
import railcraft.common.plugins.buildcraft.triggers.IHasCart;
import railcraft.common.util.inventory.PhantomInventory;
import railcraft.common.util.misc.MiscTools;

public abstract class TileLoaderBase
extends TileMachineItem
implements IHasCart,
IWrenchable {
    public static final float STOP_VELOCITY = 0.02f;
    private boolean powered;
    protected py currentCart;
    private boolean sendCart = false;
    private final PhantomInventory invCarts = new PhantomInventory(2, this);

    @Override
    public boolean hasMinecart() {
        return this.currentCart != null;
    }

    public final PhantomInventory getCartFilters() {
        return this.invCarts;
    }

    @Override
    public void actionActivated(IAction action) {
        if (action == EnumTriggerActions.SEND_CART.getAction()) {
            this.sendCart = true;
        }
    }

    public boolean isSendCart() {
        return this.sendCart;
    }

    public void cartSent() {
        this.sendCart = false;
    }

    @Override
    public final boolean canUpdate() {
        return true;
    }

    @Override
    public final boolean canConnectRedstone(int dir) {
        return true;
    }

    @Override
    public final boolean isPoweringTo(int side) {
        if (!this.isPowered()) {
            return false;
        }
        ForgeDirection opSide = MiscTools.getOppositeSide(side);
        int id = MiscTools.getBlockIdOnSide((ym)this.k, this.l, this.m, this.n, opSide);
        return alr.e((int)id) || id == amq.ay.cm || id == amq.bl.cm || id == amq.bk.cm;
    }

    public final boolean isPowered() {
        return this.powered;
    }

    protected void setPowered(boolean p) {
        if (this.powered != p) {
            this.powered = p;
            int i = this.l;
            int j = this.m;
            int k = this.n;
            if (this.k != null) {
                int blockID = this.getBlockId();
                this.k.h(i, j, k, blockID);
            }
        }
    }

    @Override
    public void b(bq data) {
        super.b(data);
        data.a("powered", this.powered);
        this.getCartFilters().writeToNBT("invCarts", data);
    }

    @Override
    public void a(bq data) {
        super.a(data);
        this.setPowered(data.n("powered"));
        this.getCartFilters().readFromNBT("invCarts", data);
    }

    @Override
    public boolean wrenchCanSetFacing(qx entityPlayer, int side) {
        return false;
    }

    @Override
    public void setFacing(short facing) {
    }

    @Override
    public boolean wrenchCanRemove(qx entityPlayer) {
        return true;
    }

    @Override
    public float getWrenchDropRate() {
        return 1.0f;
    }

    @Override
    public ur getWrenchDrop(qx entityPlayer) {
        return this.getMachineType().getItem();
    }
}

