/*
 * Decompiled with CFR 0.152.
 */
package railcraft.common.blocks.machine.gamma;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import railcraft.common.blocks.machine.gamma.TileLoaderBase;
import railcraft.common.util.inventory.PhantomInventory;
import railcraft.common.util.misc.SafeNBTWrapper;
import railcraft.common.util.network.IGuiReturnHandler;

public abstract class TileLoaderItemBase
extends TileLoaderBase
implements IGuiReturnHandler {
    private EnumItemMode mode = EnumItemMode.TRANSFER;
    private final PhantomInventory invFilters = new PhantomInventory(9, this);
    private boolean cartShouldWait = false;

    public final PhantomInventory getItemFilters() {
        return this.invFilters;
    }

    public abstract sr getBufferSlot(int var1, int var2, int var3);

    public final boolean cartShouldWait() {
        return this.cartShouldWait;
    }

    public final void setCartShouldWait(boolean wait) {
        this.cartShouldWait = wait;
    }

    public final EnumItemMode getMode() {
        return this.mode;
    }

    public final void setMode(EnumItemMode mode) {
        this.mode = mode;
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        data.writeBoolean(this.cartShouldWait);
        data.writeByte(this.mode.ordinal());
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        this.cartShouldWait = data.readBoolean();
        this.mode = EnumItemMode.values()[data.readByte()];
    }

    @Override
    public void writeGuiData(DataOutputStream data) throws IOException {
        data.writeBoolean(this.cartShouldWait);
        data.writeByte(this.mode.ordinal());
    }

    @Override
    public void readGuiData(DataInputStream data) throws IOException {
        this.cartShouldWait = data.readBoolean();
        this.mode = EnumItemMode.values()[data.readByte()];
    }

    @Override
    public void b(bq data) {
        super.b(data);
        data.a("waitTillComplete", this.cartShouldWait);
        data.a("mode", (byte)this.mode.ordinal());
        this.getItemFilters().writeToNBT("invFilters", data);
    }

    @Override
    public void a(bq data) {
        super.a(data);
        SafeNBTWrapper safe = new SafeNBTWrapper(data);
        this.cartShouldWait = data.n("waitTillComplete");
        this.mode = EnumItemMode.values()[safe.getByte("mode")];
        if (data.b("filters")) {
            bq filters = data.l("filters");
            this.getItemFilters().readFromNBT("Items", filters);
        } else {
            this.getItemFilters().readFromNBT("invFilters", data);
        }
    }

    public static enum EnumItemMode {
        TRANSFER,
        STOCK,
        EXCESS;

    }
}

