/*
 * Decompiled with CFR 0.152.
 */
package railcraft.common.blocks.tracks;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import railcraft.common.api.core.items.IToolCrowbar;
import railcraft.common.api.tracks.ITrackPowered;
import railcraft.common.blocks.tracks.EnumTrack;
import railcraft.common.blocks.tracks.TrackBaseRailcraft;
import railcraft.common.carts.EntityLocomotive;

public class TrackLimiter
extends TrackBaseRailcraft
implements ITrackPowered {
    private boolean powered = false;
    private byte mode = 0;

    @Override
    public EnumTrack getTrackType() {
        return EnumTrack.LIMITER;
    }

    @Override
    public int getTextureIndex() {
        if (this.isPowered()) {
            return this.getTrackType().getTextureIndex() + this.mode % EntityLocomotive.LocoSpeed.VALUES.length;
        }
        return this.getTrackType().getTextureIndex() - 16 + 3;
    }

    @Override
    public boolean blockActivated(qx player) {
        IToolCrowbar crowbar;
        ur current = player.bS();
        if (current != null && current.b() instanceof IToolCrowbar && (crowbar = (IToolCrowbar)current.b()).canWhack(player, current, this.getX(), this.getY(), this.getZ())) {
            this.mode = (byte)(this.mode + 1);
            crowbar.onWhack(player, current, this.getX(), this.getY(), this.getZ());
            this.sendUpdateToClient();
            return true;
        }
        return false;
    }

    @Override
    public void onMinecartPass(py cart) {
        if (this.isPowered() && cart instanceof EntityLocomotive) {
            ((EntityLocomotive)cart).setSpeed(EntityLocomotive.LocoSpeed.VALUES[this.mode % EntityLocomotive.LocoSpeed.VALUES.length]);
        }
    }

    @Override
    public boolean isPowered() {
        return this.powered;
    }

    @Override
    public void setPowered(boolean powered) {
        this.powered = powered;
    }

    @Override
    public int getPowerPropagation() {
        return 8;
    }

    @Override
    public void writeToNBT(bq data) {
        super.writeToNBT(data);
        data.a("powered", this.powered);
        data.a("mode", this.mode);
    }

    @Override
    public void readFromNBT(bq data) {
        super.readFromNBT(data);
        this.powered = data.n("powered");
        this.mode = data.c("mode");
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        data.writeBoolean(this.powered);
        data.writeByte(this.mode);
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        this.powered = data.readBoolean();
        this.mode = data.readByte();
        this.markBlockNeedsUpdate();
    }
}

