/*
 * Decompiled with CFR 0.152.
 */
package railcraft.common.blocks.tracks;

import railcraft.common.api.tracks.ITrackInstance;
import railcraft.common.blocks.tracks.TileTrack;
import railcraft.common.blocks.tracks.TrackBaseRailcraft;
import railcraft.common.blocks.tracks.speedcontroller.SpeedControllerHighSpeed;

public class TrackTools {
    public static ITrackInstance getTrackInstanceAt(yc world, int x, int y, int z) {
        any tile = world.q(x, y, z);
        if (tile instanceof TileTrack) {
            return ((TileTrack)tile).getTrackInstance();
        }
        return null;
    }

    public static boolean isHighSpeedTrackAt(yc world, int x, int y, int z) {
        ITrackInstance track = TrackTools.getTrackInstanceAt(world, x, y, z);
        if (track instanceof TrackBaseRailcraft) {
            return ((TrackBaseRailcraft)track).speedController instanceof SpeedControllerHighSpeed;
        }
        return false;
    }

    public static boolean areTracksConnectedAlongAxis(yc world, int i1, int j1, int k1, int i2, int j2, int k2) {
        block13: {
            block12: {
                if (j1 < 0 || j2 < 0) {
                    return false;
                }
                if (i1 != i2 && k1 != k2) {
                    return false;
                }
                if (i1 == i2) break block12;
                int min = 0;
                int max = 0;
                int jj = 0;
                if (i1 < i2) {
                    min = i1;
                    max = i2;
                    jj = j1;
                } else {
                    min = i2;
                    max = i1;
                    jj = j2;
                }
                for (int ii = min; ii <= max; ++ii) {
                    if (!world.f(ii, jj, k1) || alr.e_((yc)world, (int)ii, (int)jj, (int)k1)) continue;
                    if (alr.e_((yc)world, (int)ii, (int)(jj - 1), (int)k1)) {
                        --jj;
                        continue;
                    }
                    if (alr.e_((yc)world, (int)ii, (int)(jj + 1), (int)k1)) {
                        ++jj;
                        continue;
                    }
                    return false;
                }
                break block13;
            }
            if (k1 == k2) break block13;
            int min = 0;
            int max = 0;
            int jj = 0;
            if (k1 < k2) {
                min = k1;
                max = k2;
                jj = j1;
            } else {
                min = k2;
                max = k1;
                jj = j2;
            }
            for (int kk = min; kk <= max; ++kk) {
                if (!world.f(i1, jj, kk) || alr.e_((yc)world, (int)i1, (int)jj, (int)kk)) continue;
                if (alr.e_((yc)world, (int)i1, (int)(jj - 1), (int)kk)) {
                    --jj;
                    continue;
                }
                if (alr.e_((yc)world, (int)i1, (int)(jj + 1), (int)kk)) {
                    ++jj;
                    continue;
                }
                return false;
            }
        }
        return true;
    }
}

