/*
 * Decompiled with CFR 0.152.
 */
package railcraft.common.carts;

import com.google.common.collect.MapMaker;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import railcraft.common.api.carts.CartTools;
import railcraft.common.api.carts.ILinkableCart;
import railcraft.common.api.carts.ILinkageManager;
import railcraft.common.carts.Train;

public class LinkageManager
implements ILinkageManager {
    private final Map carts = new MapMaker().weakValues().makeMap();
    private final Map trains = new HashMap();
    public static final String LINK_A_HIGH = "rcLinkAHigh";
    public static final String LINK_A_LOW = "rcLinkALow";
    public static final String LINK_B_HIGH = "rcLinkBHigh";
    public static final String LINK_B_LOW = "rcLinkBLow";
    public static final String TRAIN_HIGH = "rcTrainHigh";
    public static final String TRAIN_LOW = "rcTrainLow";

    private LinkageManager() {
    }

    public static LinkageManager getInstance(yc world) {
        return (LinkageManager)CartTools.serverLinkageManager;
    }

    public static void reset() {
        CartTools.serverLinkageManager = new LinkageManager();
    }

    public void removeLinkageId(py cart) {
        this.carts.remove(this.getLinkageId(cart));
    }

    public UUID getLinkageId(py cart) {
        UUID id = cart.getPersistentID();
        this.carts.put(id, cart);
        return id;
    }

    public py getCartFromLinkageId(UUID id) {
        return (py)this.carts.get(id);
    }

    private float getLinkageDistanceSq(py cart1, py cart2) {
        float dist = 0.0f;
        dist = cart1 instanceof ILinkableCart ? (dist += ((ILinkableCart)cart1).getLinkageDistance(cart2)) : (dist += 1.25f);
        dist = cart2 instanceof ILinkableCart ? (dist += ((ILinkableCart)cart2).getLinkageDistance(cart1)) : (dist += 1.25f);
        return dist * dist;
    }

    private boolean canLinkCarts(py cart1, py cart2) {
        ILinkableCart link;
        if (cart1 == null || cart2 == null) {
            return false;
        }
        if (cart1 == cart2) {
            return false;
        }
        if (!(!(cart1 instanceof ILinkableCart) || (link = (ILinkableCart)cart1).isLinkable() && link.canLinkWithCart(cart2))) {
            return false;
        }
        if (!(!(cart2 instanceof ILinkableCart) || (link = (ILinkableCart)cart2).isLinkable() && link.canLinkWithCart(cart1))) {
            return false;
        }
        if (this.areLinked(cart1, cart2)) {
            return false;
        }
        if (cart1.e((lq)cart2) > (double)this.getLinkageDistanceSq(cart1, cart2)) {
            return false;
        }
        return this.hasFreeLink(cart1) && this.hasFreeLink(cart2);
    }

    @Override
    public boolean createLink(py cart1, py cart2) {
        if (this.canLinkCarts(cart1, cart2)) {
            this.setLink(cart1, cart2);
            this.setLink(cart2, cart1);
            if (cart1 instanceof ILinkableCart) {
                ((ILinkableCart)cart1).onLinkCreated(cart2);
            }
            if (cart2 instanceof ILinkableCart) {
                ((ILinkableCart)cart2).onLinkCreated(cart1);
            }
            return true;
        }
        return false;
    }

    private boolean hasFreeLink(py cart) {
        return this.getLinkedCartA(cart) == null || this.hasLinkB(cart) && this.getLinkedCartB(cart) == null;
    }

    private boolean hasLinkB(py cart) {
        if (cart instanceof ILinkableCart) {
            return ((ILinkableCart)cart).hasTwoLinks();
        }
        return true;
    }

    private void setLink(py cart1, py cart2) {
        if (this.getLinkedCartA(cart1) == null) {
            this.setLinkA(cart1, cart2);
        } else if (this.hasLinkB(cart1) && this.getLinkedCartB(cart1) == null) {
            this.setLinkB(cart1, cart2);
        }
    }

    public UUID getLinkA(py cart) {
        long high = cart.getEntityData().f(LINK_A_HIGH);
        long low = cart.getEntityData().f(LINK_A_LOW);
        return new UUID(high, low);
    }

    private void setLinkA(py cart1, py cart2) {
        this.resetTrain(cart1);
        this.resetTrain(cart2);
        UUID id = this.getLinkageId(cart2);
        cart1.getEntityData().a(LINK_A_HIGH, id.getMostSignificantBits());
        cart1.getEntityData().a(LINK_A_LOW, id.getLeastSignificantBits());
    }

    @Override
    public py getLinkedCartA(py cart) {
        return this.getCartFromLinkageId(this.getLinkA(cart));
    }

    public UUID getLinkB(py cart) {
        long high = cart.getEntityData().f(LINK_B_HIGH);
        long low = cart.getEntityData().f(LINK_B_LOW);
        return new UUID(high, low);
    }

    private void setLinkB(py cart1, py cart2) {
        if (!this.hasLinkB(cart1)) {
            return;
        }
        this.resetTrain(cart1);
        this.resetTrain(cart2);
        UUID id = this.getLinkageId(cart2);
        cart1.getEntityData().a(LINK_B_HIGH, id.getMostSignificantBits());
        cart1.getEntityData().a(LINK_B_LOW, id.getLeastSignificantBits());
    }

    @Override
    public py getLinkedCartB(py cart) {
        return this.getCartFromLinkageId(this.getLinkB(cart));
    }

    public Train getTrain(py cart) {
        Train train = (Train)this.trains.get(this.getTrainUUID(cart));
        if (train != null && !train.containsCart(cart)) {
            train.releaseTrain(this);
            this.trains.remove(train.getUUID());
            train = null;
        }
        if (train == null) {
            train = new Train(cart);
            this.trains.put(train.getUUID(), train);
        }
        return train;
    }

    public UUID getTrainUUID(py cart) {
        long high = cart.getEntityData().f(TRAIN_HIGH);
        long low = cart.getEntityData().f(TRAIN_LOW);
        return new UUID(high, low);
    }

    private void resetTrain(py cart) {
        Train train = (Train)this.trains.remove(this.getTrainUUID(cart));
        if (train != null) {
            train.releaseTrain(this);
        }
    }

    @Override
    public boolean areLinked(py cart1, py cart2) {
        if (cart1 == null || cart2 == null) {
            return false;
        }
        if (cart1 == cart2) {
            return false;
        }
        boolean cart1Linked = false;
        UUID id1 = this.getLinkageId(cart1);
        UUID id2 = this.getLinkageId(cart2);
        if (id2.equals(this.getLinkA(cart1)) || id2.equals(this.getLinkB(cart1))) {
            cart1Linked = true;
        }
        boolean cart2Linked = false;
        if (id1.equals(this.getLinkA(cart2)) || id1.equals(this.getLinkB(cart2))) {
            cart2Linked = true;
        }
        return cart1Linked && cart2Linked;
    }

    @Override
    public void breakLink(py cart1, py cart2) {
        UUID link = this.getLinkageId(cart2);
        if (link.equals(this.getLinkA(cart1))) {
            this.breakLinkA(cart1);
        }
        if (link.equals(this.getLinkB(cart1))) {
            this.breakLinkB(cart1);
        }
    }

    @Override
    public void breakLinks(py cart) {
        this.breakLinkA(cart);
        this.breakLinkB(cart);
    }

    @Override
    public void breakLinkA(py cart) {
        this.resetTrain(cart);
        UUID link = this.getLinkA(cart);
        cart.getEntityData().a(LINK_A_HIGH, 0L);
        cart.getEntityData().a(LINK_A_LOW, 0L);
        py other = this.getCartFromLinkageId(link);
        if (other != null) {
            this.breakLink(other, cart);
        }
        if (cart instanceof ILinkableCart) {
            ((ILinkableCart)cart).onLinkBroken(other);
        }
    }

    @Override
    public void breakLinkB(py cart) {
        this.resetTrain(cart);
        UUID link = this.getLinkB(cart);
        cart.getEntityData().a(LINK_B_HIGH, 0L);
        cart.getEntityData().a(LINK_B_LOW, 0L);
        py other = this.getCartFromLinkageId(link);
        if (other != null) {
            this.breakLink(other, cart);
        }
        if (cart instanceof ILinkableCart) {
            ((ILinkableCart)cart).onLinkBroken(other);
        }
    }

    @Override
    public int countCartsInTrain(py cart) {
        py linkA = this.getLinkedCartA(cart);
        py linkB = this.getLinkedCartB(cart);
        int count1 = 0;
        int count2 = 0;
        return (count1 += this.countLinksRecursive(linkA, cart)) + (count2 += this.countLinksRecursive(linkB, cart)) + 1;
    }

    private int countLinksRecursive(py cart, py prev) {
        if (cart == null) {
            return 0;
        }
        py linkA = this.getLinkedCartA(cart);
        py linkB = this.getLinkedCartB(cart);
        int count1 = 0;
        if (linkA != prev) {
            count1 += this.countLinksRecursive(linkA, cart);
        }
        int count2 = 0;
        if (linkB != prev) {
            count2 += this.countLinksRecursive(linkB, cart);
        }
        return count1 + count2 + 1;
    }
}

