/*
 * Decompiled with CFR 0.152.
 */
package railcraft.common.core;

import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.primitives.Ints;
import cpw.mods.fml.common.IScheduledTickHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLFingerprintViolationEvent;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStoppingEvent;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.registry.TickRegistry;
import cpw.mods.fml.relauncher.Side;
import java.io.File;
import java.util.logging.Level;
import net.minecraftforge.liquids.LiquidDictionary;
import net.minecraftforge.liquids.LiquidStack;
import railcraft.common.api.core.items.ItemRegistry;
import railcraft.common.api.fuel.FuelManager;
import railcraft.common.blocks.aesthetics.cube.EnumCube;
import railcraft.common.blocks.aesthetics.post.BlockPostMetal;
import railcraft.common.blocks.aesthetics.post.EnumPost;
import railcraft.common.blocks.machine.alpha.EnumMachineAlpha;
import railcraft.common.blocks.machine.beta.EnumMachineBeta;
import railcraft.common.blocks.machine.gamma.EnumMachineGamma;
import railcraft.common.blocks.signals.EnumSignal;
import railcraft.common.carts.LinkageManager;
import railcraft.common.core.CommonProxy;
import railcraft.common.core.StartupChecks;
import railcraft.common.modules.ModuleManager;
import railcraft.common.plugins.craftguide.CraftGuidePlugin;
import railcraft.common.plugins.forge.Creeper$Plugin;
import railcraft.common.plugins.forge.Fishing$Plugin;
import railcraft.common.util.inventory.EnumItemType;
import railcraft.common.util.misc.BallastRegistry;
import railcraft.common.util.misc.BlinkTick;
import railcraft.common.util.misc.EnumColor;
import railcraft.common.util.misc.Game;
import railcraft.common.util.network.RailcraftPacketHandler;

@Mod(modid="Railcraft", name="Railcraft", version="6.17.0.0", certificateFingerprint="a0c255ac501b2749537d5824bb0f0588bf0320fa", dependencies="required-after:Forge@[6.6.0.516,);after:BuildCraft|Core;after:BuildCraft|Energy;after:BuildCraft|Builders;after:BuildCraft|Factory;after:Forestry;after:BasicComponents@[1.2.6,);after:IC2")
@NetworkMod(channels={"RC"}, clientSideRequired=true, serverSideRequired=false, packetHandler=RailcraftPacketHandler.class)
public final class Railcraft {
    public static final String VERSION = "6.17.0.0";
    @Mod.Instance(value="Railcraft")
    public static Railcraft instance;
    private File configFolder;
    @SidedProxy(clientSide="railcraft.client.core.ClientProxy", serverSide="railcraft.common.core.CommonProxy")
    public static CommonProxy proxy;

    public static CommonProxy getProxy() {
        return proxy;
    }

    public static Railcraft getMod() {
        return instance;
    }

    public static String getVersion() {
        return VERSION;
    }

    public File getConfigFolder() {
        return this.configFolder;
    }

    @Mod.IMCCallback
    public void processIMCRequests(FMLInterModComms.IMCEvent event) {
        Splitter splitter = Splitter.on((String)"@").trimResults();
        for (FMLInterModComms.IMCMessage mess : event.getMessages()) {
            String[] tokens;
            if (mess.key.equals("ballast")) {
                tokens = (String[])Iterables.toArray((Iterable)splitter.split((CharSequence)mess.getStringValue()), String.class);
                if (tokens.length != 2) {
                    Game.log(Level.WARNING, String.format("Mod %s attempted to register a ballast, but failed: %s", mess.getSender(), mess.getStringValue()), new Object[0]);
                    continue;
                }
                Integer blockId = Ints.tryParse((String)tokens[0]);
                Integer metadata = Ints.tryParse((String)tokens[1]);
                if (blockId == null || metadata == null) {
                    Game.log(Level.WARNING, String.format("Mod %s attempted to register a ballast, but failed: %s", mess.getSender(), mess.getStringValue()), new Object[0]);
                    continue;
                }
                BallastRegistry.registerBallast(blockId, metadata);
                Game.log(Level.WARNING, String.format("Mod %s registered %s as a valid ballast", mess.getSender(), mess.getStringValue()), new Object[0]);
                continue;
            }
            if (mess.key.equals("boiler-fuel-liquid")) {
                tokens = (String[])Iterables.toArray((Iterable)splitter.split((CharSequence)mess.getStringValue()), String.class);
                if (tokens.length != 2) {
                    Game.log(Level.WARNING, String.format("Mod %s attempted to register a liquid Boiler fuel, but failed: %s", mess.getSender(), mess.getStringValue()), new Object[0]);
                    continue;
                }
                LiquidStack liquid = LiquidDictionary.getLiquid((String)tokens[0], (int)1000);
                Integer fuel = Ints.tryParse((String)tokens[1]);
                if (liquid == null || fuel == null) {
                    Game.log(Level.WARNING, String.format("Mod %s attempted to register a liquid Boiler fuel, but failed: %s", mess.getSender(), mess.getStringValue()), new Object[0]);
                    continue;
                }
                FuelManager.addBoilerFuel(liquid, fuel);
                Game.log(Level.WARNING, String.format("Mod %s registered %s as a valid liquid Boiler fuel", mess.getSender(), mess.getStringValue()), new Object[0]);
                continue;
            }
            if (!mess.key.equals("securityViolation")) continue;
            Creeper$Plugin.doFix();
        }
    }

    @Mod.FingerprintWarning
    public void fingerprintWarning(FMLFingerprintViolationEvent event) {
        if (Game.isObfuscated()) {
            Creeper$Plugin.pluckTheWeb("Tampering Detected. Please re-download Railcraft.");
            Runtime.getRuntime().halt(1);
        }
    }

    @Mod.PreInit
    public void preInit(FMLPreInitializationEvent event) {
        Game.log(Level.FINE, "Pre-Init Phase", new Object[0]);
        Fishing$Plugin.reel$ItIn();
        this.configFolder = new File(event.getModConfigurationDirectory(), "railcraft");
        StartupChecks.checkForNewVersion();
        EnumItemType.initialize();
        ModuleManager.preInit();
        proxy.preInitClient();
    }

    @Mod.Init
    public void init(FMLInitializationEvent event) {
        Game.log(Level.FINE, "Init Phase", new Object[0]);
        ModuleManager.init();
        TickRegistry.registerScheduledTickHandler((IScheduledTickHandler)new BlinkTick(), (Side)Side.CLIENT);
        for (EnumMachineAlpha enumMachineAlpha : EnumMachineAlpha.values()) {
            if (!enumMachineAlpha.isEnabled()) continue;
            ItemRegistry.registerItem(enumMachineAlpha.getTag(), enumMachineAlpha.getItem());
        }
        for (Enum enum_ : EnumMachineBeta.values()) {
            if (!((EnumMachineBeta)enum_).isEnabled()) continue;
            ItemRegistry.registerItem(((EnumMachineBeta)enum_).getTag(), ((EnumMachineBeta)enum_).getItem());
        }
        for (Enum enum_ : EnumMachineGamma.values()) {
            if (!((EnumMachineGamma)enum_).isEnabled()) continue;
            ItemRegistry.registerItem(((EnumMachineGamma)enum_).getTag(), ((EnumMachineGamma)enum_).getItem());
        }
        block6: for (Enum enum_ : EnumSignal.values()) {
            if (!((EnumSignal)enum_).isEnabled()) continue;
            switch (1.$SwitchMap$railcraft$common$blocks$signals$EnumSignal[enum_.ordinal()]) {
                case 1: 
                case 2: 
                case 3: {
                    continue block6;
                }
                default: {
                    ItemRegistry.registerItem(((EnumSignal)enum_).getTag(), ((EnumSignal)enum_).getItem());
                }
            }
        }
        for (Enum enum_ : EnumCube.values()) {
            if (!((EnumCube)enum_).isEnabled()) continue;
            ItemRegistry.registerItem(((EnumCube)enum_).getTag(), ((EnumCube)enum_).getItem());
        }
        for (Enum enum_ : EnumPost.values()) {
            ItemRegistry.registerItem(((EnumPost)enum_).getTag(), ((EnumPost)enum_).getItem());
        }
        for (Enum enum_ : EnumColor.values()) {
            ItemRegistry.registerItem("post.metal." + ((EnumColor)enum_).getBasicTag(), BlockPostMetal.getItem(1, enum_.ordinal()));
        }
    }

    @Mod.PostInit
    public void postInit(FMLPostInitializationEvent event) {
        Game.log(Level.FINE, "Post-Init Phase", new Object[0]);
        ModuleManager.postInit();
        proxy.initClient();
        CraftGuidePlugin.init();
    }

    @Mod.ServerStopping
    public void serverCleanUp(FMLServerStoppingEvent event) {
        LinkageManager.reset();
    }

    static class 1 {
        static final /* synthetic */ int[] $SwitchMap$railcraft$common$blocks$signals$EnumSignal;

        static {
            $SwitchMap$railcraft$common$blocks$signals$EnumSignal = new int[EnumSignal.values().length];
            try {
                1.$SwitchMap$railcraft$common$blocks$signals$EnumSignal[EnumSignal.STONE_POST.ordinal()] = 1;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$railcraft$common$blocks$signals$EnumSignal[EnumSignal.WOOD_POST.ordinal()] = 2;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$railcraft$common$blocks$signals$EnumSignal[EnumSignal.METAL_POST.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }
}

