/*
 * Decompiled with CFR 0.152.
 */
package railcraft.common.liquids;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraftforge.liquids.ILiquidTank;
import railcraft.common.core.Railcraft;
import railcraft.common.gui.util.ToolTip;
import railcraft.common.liquids.tanks.FilteredTank;

public class LiquidGauge {
    public final ILiquidTank tank;
    public final int x;
    public final int y;
    public final int h;
    public final int w;

    public LiquidGauge(ILiquidTank tank, int x, int y, int w, int h) {
        this.tank = tank;
        this.x = x;
        this.y = y;
        this.h = h;
        this.w = w;
    }

    public List getToolTip() {
        if (this.tank instanceof FilteredTank) {
            return ((FilteredTank)this.tank).getToolTip();
        }
        ArrayList<ToolTip> list = new ArrayList<ToolTip>();
        int amount = 0;
        if (this.tank.getLiquid() != null && this.tank.getLiquid().itemID != 0 && this.tank.getLiquid().amount > 0) {
            ur stack = this.tank.getLiquid().asItemStack();
            if (stack.b() == null) {
                return list;
            }
            list.add(new ToolTip(Railcraft.getProxy().getItemDisplayName(stack), Railcraft.getProxy().getItemRarityColor(stack)));
            amount = this.tank.getLiquid().amount;
        }
        list.add(new ToolTip(String.format(Locale.ENGLISH, "%,d / %,d", amount, this.tank.getCapacity())));
        return list;
    }
}

